/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;

public abstract class PipelineAggregator
implements NamedWriteable {
    private String name;
    private String[] bucketsPaths;
    private Map<String, Object> metaData;

    protected PipelineAggregator(String name, String[] bucketsPaths, Map<String, Object> metaData) {
        this.name = name;
        this.bucketsPaths = bucketsPaths;
        this.metaData = metaData;
    }

    protected PipelineAggregator(StreamInput in) throws IOException {
        this.name = in.readString();
        this.bucketsPaths = in.readStringArray();
        this.metaData = in.readMap();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringArray(this.bucketsPaths);
        out.writeMap(this.metaData);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public String name() {
        return this.name;
    }

    public String[] bucketsPaths() {
        return this.bucketsPaths;
    }

    public Map<String, Object> metaData() {
        return this.metaData;
    }

    public abstract InternalAggregation reduce(InternalAggregation var1, InternalAggregation.ReduceContext var2);

    @FunctionalInterface
    public static interface Parser {
        public static final ParseField BUCKETS_PATH = new ParseField("buckets_path", new String[0]);
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
        public static final ParseField GAP_POLICY = new ParseField("gap_policy", new String[0]);

        public PipelineAggregationBuilder parse(String var1, XContentParser var2) throws IOException;
    }
}

