/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.bo.AdHocRouteRecipient;
import org.kuali.rice.krad.bo.AdHocRouteWorkgroup;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentAdHocService;

public class DocumentAdHocServiceImpl
implements DocumentAdHocService {
    protected DataObjectService dataObjectService;

    public void replaceAdHocsForDocument(Document document) {
        if (document == null || StringUtils.isBlank((String)document.getDocumentNumber())) {
            return;
        }
        this.dataObjectService.deleteMatching(AdHocRoutePerson.class, QueryByCriteria.Builder.forAttribute((String)"documentNumber", (Object)document.getDocumentNumber()).build());
        this.dataObjectService.deleteMatching(AdHocRouteWorkgroup.class, QueryByCriteria.Builder.forAttribute((String)"documentNumber", (Object)document.getDocumentNumber()).build());
        document.setAdHocRoutePersons(this.saveAdHocRouteRecipients(document.getDocumentNumber(), document.getAdHocRoutePersons()));
        document.getAdHocRoutePersons().forEach(AdHocRoutePerson::getPerson);
        document.setAdHocRouteWorkgroups(this.saveAdHocRouteRecipients(document.getDocumentNumber(), document.getAdHocRouteWorkgroups()));
        document.getAdHocRouteWorkgroups().forEach(adHocRouteWorkgroup -> adHocRouteWorkgroup.setId(adHocRouteWorkgroup.getId()));
    }

    protected <T extends AdHocRouteRecipient> List<T> saveAdHocRouteRecipients(String documentNumber, List<T> adHocRouteRecipients) {
        ArrayList<AdHocRouteRecipient> savedAdHocRouteWorkgroup = new ArrayList<AdHocRouteRecipient>();
        if (adHocRouteRecipients != null) {
            for (AdHocRouteRecipient recipient : adHocRouteRecipients) {
                recipient.setdocumentNumber(documentNumber);
                savedAdHocRouteWorkgroup.add((AdHocRouteRecipient)this.dataObjectService.save((Object)recipient, new PersistenceOption[0]));
            }
        }
        return savedAdHocRouteWorkgroup;
    }

    public void addAdHocs(Document document) {
        if (document == null) {
            return;
        }
        QueryResults adHocRoutePersons = this.dataObjectService.findMatching(AdHocRoutePerson.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"documentNumber", (Object)document.getDocumentNumber()), PredicateFactory.equal((String)"type", (Object)AdHocRoutePerson.PERSON_TYPE)}));
        QueryResults adHocRouteWorkgroups = this.dataObjectService.findMatching(AdHocRouteWorkgroup.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"documentNumber", (Object)document.getDocumentNumber()), PredicateFactory.equal((String)"type", (Object)AdHocRoutePerson.WORKGROUP_TYPE)}));
        for (AdHocRouteWorkgroup adHocRouteWorkgroup : adHocRouteWorkgroups.getResults()) {
            Group group = KimApiServiceLocator.getGroupService().getGroup(adHocRouteWorkgroup.getId());
            adHocRouteWorkgroup.setRecipientName(group.getName());
            adHocRouteWorkgroup.setRecipientNamespaceCode(group.getNamespaceCode());
        }
        document.setAdHocRoutePersons(new ArrayList(adHocRoutePersons.getResults()));
        document.setAdHocRouteWorkgroups(new ArrayList(adHocRouteWorkgroups.getResults()));
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

