/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.notification;

import java.util.List;
import org.kuali.coeus.common.framework.mail.EmailAttachment;
import org.kuali.coeus.common.notification.impl.NotificationContextBase;
import org.kuali.coeus.common.notification.impl.NotificationRenderer;
import org.kuali.coeus.common.notification.impl.bo.NotificationTypeRecipient;
import org.kuali.coeus.common.notification.impl.exception.UnknownRoleException;
import org.kuali.coeus.common.notification.impl.service.KcNotificationModuleRoleService;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.notification.CommitteeNotificationRoleQualifierService;
import org.springframework.util.CollectionUtils;

public class CommitteeNotificationContext
extends NotificationContextBase {
    private static final long serialVersionUID = 6642334312368480034L;
    private Committee committee;
    private CommitteeSchedule committeeSchedule;
    private String actionTypeCode;
    private String contextName;
    private CommitteeNotificationRoleQualifierService committeeNotificationRoleQualifierService;

    public CommitteeNotificationContext(CommitteeSchedule committeeSchedule, String actionTypeCode, String contextName, NotificationRenderer renderer) {
        super(renderer);
        this.committee = committeeSchedule.getParentCommittee();
        this.committeeSchedule = committeeSchedule;
        this.actionTypeCode = actionTypeCode;
        this.contextName = contextName;
        this.setNotificationService(KcServiceLocator.getService(KcNotificationService.class));
        this.setNotificationModuleRoleService(KcServiceLocator.getService(KcNotificationModuleRoleService.class));
        this.setNotificationRoleQualifierService(KcServiceLocator.getService(CommitteeNotificationRoleQualifierService.class));
        ((CommitteeNotificationRoleQualifierService)this.getNotificationRoleQualifierService()).setCommitteeSchedule(this.committeeSchedule);
        ((CommitteeNotificationRoleQualifierService)this.getNotificationRoleQualifierService()).setCommittee(this.committee);
    }

    @Override
    public String getModuleCode() {
        return "11";
    }

    @Override
    public String getDocumentNumber() {
        return ((CommitteeDocument)this.committee.getCommitteeDocument()).getDocumentNumber();
    }

    @Override
    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    @Override
    public String getContextName() {
        return this.contextName;
    }

    @Override
    public void populateRoleQualifiers(NotificationTypeRecipient notificationRecipient) throws UnknownRoleException {
        if (CollectionUtils.isEmpty(notificationRecipient.getRoleQualifiers())) {
            super.populateRoleQualifiers(notificationRecipient);
        }
    }

    @Override
    public List<EmailAttachment> getEmailAttachments() {
        return null;
    }

    public CommitteeNotificationRoleQualifierService getCommitteeNotificationRoleQualifierService() {
        return this.committeeNotificationRoleQualifierService;
    }

    public void setCommitteeNotificationRoleQualifierService(CommitteeNotificationRoleQualifierService committeeNotificationRoleQualifierService) {
        this.committeeNotificationRoleQualifierService = committeeNotificationRoleQualifierService;
    }
}

