/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDao;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolLookupableHelperServiceImplBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;

public class IacucProtocolLookupableHelperServiceImpl
extends ProtocolLookupableHelperServiceImplBase<IacucProtocol> {
    private static final long serialVersionUID = -4930225152545760432L;
    private static final String[] AMEND_RENEW_PROTOCOL_TASK_CODES = new String[]{"createIacucAmendment", "createRenewal"};
    private static final String[] REQUEST_PROTOCOL_TASK_CODES = new String[]{"iacucProtocolRequestClose", "iacucProtocolRequestClose", "iacucProtocolRequestSuspension", "iacucProtocolRequestTerminate"};
    private static final String[] PENDING_PROTOCOL_STATUS_CODES = new String[]{"100", "101", "104", "107", "105"};
    private static final String[] PENDING_PI_ACTION_PROTOCOL_STATUS_CODES = new String[]{"104", "107", "308"};

    @Override
    protected List<? extends BusinessObject> getSearchResultsFilteredByTask(Map<String, String> fieldValues) {
        List<BusinessObject> searchResults = null;
        searchResults = BooleanUtils.toBoolean((String)fieldValues.get("lookupActionAmendRenewProtocol")) ? this.filterProtocolsByTask(fieldValues, AMEND_RENEW_PROTOCOL_TASK_CODES) : (BooleanUtils.toBoolean((String)fieldValues.get("lookupActionRequestProtocol")) ? this.filterProtocolsByTask(fieldValues, REQUEST_PROTOCOL_TASK_CODES) : (BooleanUtils.toBoolean((String)fieldValues.get("lookupPendingProtocol")) ? this.filterProtocolsByStatus(fieldValues, PENDING_PROTOCOL_STATUS_CODES) : (BooleanUtils.toBoolean((String)fieldValues.get("lookupPendingPIActionProtocol")) ? this.filterProtocolsByStatus(fieldValues, PENDING_PI_ACTION_PROTOCOL_STATUS_CODES) : (StringUtils.isNotBlank((CharSequence)fieldValues.get("lookupProtocolPersonId")) ? this.filterProtocolsByPrincipal(fieldValues, "lookupProtocolPersonId") : this.filterProtocols(fieldValues)))));
        return searchResults;
    }

    @Override
    protected Map<String, String> removeExtraFilterParameters(Map<String, String> fieldValues) {
        fieldValues.remove("lookupActionAmendRenewProtocol");
        fieldValues.remove("lookupActionRequestProtocol");
        fieldValues.remove("lookupPendingProtocol");
        fieldValues.remove("lookupPendingPIActionProtocol");
        fieldValues.remove("lookupProtocolPersonId");
        return fieldValues;
    }

    @Override
    protected List<HtmlData> getCustomActions(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        if (this.isParameterTrue("lookupActionAmendRenewProtocol")) {
            htmlDataList.add((HtmlData)this.getPerformActionLink(businessObject, "lookupActionAmendRenewProtocol"));
        } else if (this.isParameterTrue("lookupActionRequestProtocol")) {
            htmlDataList.add((HtmlData)this.getPerformActionLink(businessObject, "lookupActionRequestProtocol"));
        } else {
            htmlDataList.addAll(this.getEditCopyViewLinks(businessObject, pkNames));
        }
        return htmlDataList;
    }

    @Override
    protected List<HtmlData> getEditCopyViewLinks(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        if (this.kraAuthorizationService.hasPermission(this.getUserIdentifier(), (ProtocolBase)businessObject, "Modify IACUC Protocol")) {
            HtmlData.AnchorHtmlData editHtmlData = this.getViewLink(((ProtocolBase)businessObject).getProtocolDocument().getDocumentNumber());
            String href = editHtmlData.getHref();
            href = href.replace("viewDocument=true", "viewDocument=false");
            editHtmlData.setHref(href);
            editHtmlData.setDisplayText("edit");
            htmlDataList.add((HtmlData)editHtmlData);
            HtmlData.AnchorHtmlData copyHtmlData = this.getUrlData(businessObject, "copy", pkNames);
            IacucProtocolDocument document = ((IacucProtocol)businessObject).getIacucProtocolDocument();
            copyHtmlData.setHref("../DocCopyHandler.do?docId=" + document.getDocumentNumber() + "&command=displayDocSearchView&documentTypeName=" + this.getDocumentTypeName() + "&doCopy=True");
            htmlDataList.add((HtmlData)copyHtmlData);
        }
        if (this.kraAuthorizationService.hasPermission(this.getUserIdentifier(), (IacucProtocol)businessObject, "View IACUC Protocol")) {
            htmlDataList.add((HtmlData)this.getViewLink(((ProtocolBase)businessObject).getProtocolDocument().getDocumentNumber()));
        }
        return htmlDataList;
    }

    protected IacucProtocolDao getProtocolDaoHook() {
        return this.getIacucProtocolDao();
    }

    protected IacucProtocolDao getIacucProtocolDao() {
        return KcServiceLocator.getService(IacucProtocolDao.class);
    }

    @Override
    protected String getDocumentTypeNameHook() {
        return "IacucProtocolDocument";
    }

    @Override
    protected String getHtmlActionHook() {
        return "iacucProtocolProtocol.do";
    }

    @Override
    protected ProtocolTaskBase createNewProtocolTaskInstanceHook(String taskName, ProtocolBase protocol) {
        return new IacucProtocolTask(taskName, (IacucProtocol)protocol);
    }

    @Override
    protected Class<? extends ProtocolBase> getProtocolClassHook() {
        return IacucProtocol.class;
    }
}

