/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.questionnaire.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.common.framework.print.AbstractPrint;
import org.kuali.coeus.common.framework.print.Printable;
import org.kuali.coeus.common.framework.print.PrintingService;
import org.kuali.coeus.common.questionnaire.framework.core.Questionnaire;
import org.kuali.coeus.common.questionnaire.framework.print.QuestionnairePrint;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.iacuc.questionnaire.print.QuestionnairePrintingService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.print.QuestionnairePrintOption;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class QuestionnairePrintingServiceImpl
implements QuestionnairePrintingService {
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SUBMISSION_NUMBER = "submissionNumber";
    private static final String SEQUENCE_NUMBER = "SEQUENCE_NUMBER";
    public static final String TEMPLATE = "template";
    public static final String MODULE_SUB_ITEM_CODE = "moduleSubItemCode";
    public static final String SUBMISSION_ID = "submissionId";
    private PrintingService printingService;
    private QuestionnairePrint questionnairePrint;
    private BusinessObjectService businessObjectService;

    private Questionnaire getQuestionnaire(Long id) {
        HashMap<String, Long> pkMap = new HashMap<String, Long>();
        pkMap.put("id", id);
        return (Questionnaire)this.businessObjectService.findByPrimaryKey(Questionnaire.class, pkMap);
    }

    @Override
    public List<Printable> getQuestionnairePrintable(KcPersistableBusinessObjectBase printableBusinessObject, List<QuestionnairePrintOption> questionnairesToPrints) {
        ArrayList<Printable> printables = new ArrayList<Printable>();
        for (QuestionnairePrintOption printOption : questionnairesToPrints) {
            if (!printOption.isSelected()) continue;
            QuestionnairePrint printable = new QuestionnairePrint();
            ((AbstractPrint)printable).setXmlStream(this.getQuestionnairePrint().getXmlStream());
            HashMap<String, Object> reportParameters = new HashMap<String, Object>();
            Questionnaire questionnaire = this.getQuestionnaire(printOption.getQuestionnaireId());
            reportParameters.put("questionnaireSeqId", questionnaire.getQuestionnaireSeqIdAsInteger());
            reportParameters.put("id", questionnaire.getId());
            reportParameters.put(TEMPLATE, questionnaire.getTemplate());
            reportParameters.put(MODULE_SUB_ITEM_CODE, printOption.getSubItemCode());
            if ("2".equals(printOption.getSubItemCode())) {
                reportParameters.put(PROTOCOL_NUMBER, printOption.getItemKey());
                reportParameters.put(SUBMISSION_NUMBER, printOption.getSubItemKey());
            }
            if (printable == null) continue;
            printable.setPrintableBusinessObject(this.getProtocolPrintable(printOption));
            printable.setReportParameters(reportParameters);
            printables.add(printable);
        }
        return printables;
    }

    private ProtocolBase getProtocolPrintable(QuestionnairePrintOption printOption) {
        if ("2".equals(printOption.getSubItemCode())) {
            HashMap<String, String> keyValues = new HashMap<String, String>();
            keyValues.put(PROTOCOL_NUMBER, printOption.getItemKey());
            keyValues.put(SUBMISSION_NUMBER, printOption.getSubItemKey());
            return ((ProtocolSubmissionBase)((List)this.businessObjectService.findMatchingOrderBy(this.getProtocolSubmissionBOClassHook(), keyValues, SUBMISSION_ID, false)).get(0)).getProtocol();
        }
        HashMap<String, String> keyValues = new HashMap<String, String>();
        keyValues.put(PROTOCOL_NUMBER, printOption.getItemKey());
        keyValues.put(SEQUENCE_NUMBER, printOption.getSubItemKey());
        return (ProtocolBase)((List)this.businessObjectService.findMatching(this.getProtocolBOClassHook(), keyValues)).get(0);
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public QuestionnairePrint getQuestionnairePrint() {
        return this.questionnairePrint;
    }

    public void setQuestionnairePrint(QuestionnairePrint questionnairePrint) {
        this.questionnairePrint = questionnairePrint;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected abstract Class<? extends ProtocolBase> getProtocolBOClassHook();

    protected abstract Class<? extends ProtocolSubmissionBase> getProtocolSubmissionBOClassHook();
}

