/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notification.service.impl;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kcb.api.message.MessageDTO;
import org.kuali.rice.kcb.api.service.MessagingService;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.notification.service.impl.DefaultNotificationService;

public class KCBNotificationService
extends DefaultNotificationService {
    @Override
    protected void sendNotification(ActionItem actionItem) {
        super.sendNotification(actionItem);
        String enableKENNotificationValue = ConfigContext.getCurrentContextConfig().getProperty("rice.kew.enableKENNotification");
        boolean enableKENNotification = Boolean.parseBoolean(enableKENNotificationValue);
        if (!enableKENNotification || actionItem.getPrincipalId() != null) {
            return;
        }
        MessagingService ms = (MessagingService)GlobalResourceLoader.getService((QName)new QName("KCB", "messagingService"));
        if (ms == null) {
            this.LOG.info("Could not locate KCB MessagingService.  Message will not be forwarded to the KCB.");
            return;
        }
        MessageDTO mvo = new MessageDTO();
        mvo.setChannel("KEW");
        mvo.setContent("i'm a kew notification");
        mvo.setContentType("KEW notification");
        mvo.setDeliveryType(actionItem.getActionRequestCd());
        mvo.setProducer("kew@localhost");
        mvo.setTitle(actionItem.getDocLabel() + " - " + actionItem.getDocName() + " - " + actionItem.getDocTitle());
        if (StringUtils.isNotBlank((String)actionItem.getDocHandlerURL())) {
            mvo.setUrl(actionItem.getDocHandlerURL() + "?docId=" + actionItem.getDocumentId());
        }
        mvo.setOriginId(String.valueOf(actionItem.getId()));
        try {
            mvo.setRecipient(actionItem.getPrincipalId());
            this.LOG.debug("Sending message to KCB: " + mvo);
            ms.deliver(mvo);
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException("could not deliver message to KCB", (Throwable)e);
        }
    }

    @Override
    public void removeNotification(List<ActionItem> actionItems) {
        String enableKENNotificationValue = ConfigContext.getCurrentContextConfig().getProperty("rice.kew.enableKENNotification");
        boolean enableKENNotification = Boolean.parseBoolean(enableKENNotificationValue);
        if (!enableKENNotification) {
            return;
        }
        MessagingService ms = (MessagingService)GlobalResourceLoader.getService((QName)new QName("KCB", "messagingService"));
        for (ActionItem actionItem : actionItems) {
            this.LOG.debug("Removing KCB messages for action item: " + actionItem.getId() + " " + actionItem.getActionRequestCd() + " " + actionItem.getPrincipalId());
            try {
                ms.removeByOriginId(String.valueOf(actionItem.getId()), null, null);
            }
            catch (Exception e) {
                throw new RuntimeException("could not remove message from KCB", e);
            }
        }
    }
}

