/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.validation;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;
import org.kuali.rice.kew.api.extension.ExtensionRepositoryService;
import org.kuali.rice.kew.api.extension.ExtensionUtils;
import org.kuali.rice.kew.api.validation.RuleValidationContext;
import org.kuali.rice.kew.api.validation.ValidationResults;
import org.kuali.rice.kew.framework.validation.RuleValidationAttributeExporterService;
import org.kuali.rice.kew.rule.RuleValidationAttribute;
import org.springframework.beans.factory.annotation.Required;

public class RuleValidationAttributeExporterServiceImpl
implements RuleValidationAttributeExporterService {
    private ExtensionRepositoryService extensionRepositoryService;

    @Required
    public void setExtensionRepositoryService(ExtensionRepositoryService extensionRepositoryService) {
        this.extensionRepositoryService = extensionRepositoryService;
    }

    private ExtensionRepositoryService getExtensionRepositoryService() {
        return this.extensionRepositoryService;
    }

    public ValidationResults validate(String attributeName, RuleValidationContext validationContext) {
        if (StringUtils.isBlank((String)attributeName)) {
            throw new RiceIllegalArgumentException("attribute name was null or blank");
        }
        RuleValidationAttribute attr = this.loadAttribute(attributeName);
        return attr.validate(validationContext);
    }

    protected RuleValidationAttribute loadAttribute(String attributeName) {
        ExtensionDefinition extensionDefinition = this.getExtensionRepositoryService().getExtensionByName(attributeName);
        if (extensionDefinition == null) {
            throw new RiceIllegalArgumentException("Failed to locate a RuleValidationAttribute with the given name: " + attributeName);
        }
        RuleValidationAttribute attribute = (RuleValidationAttribute)ExtensionUtils.loadExtension((ExtensionDefinitionContract)extensionDefinition);
        if (attribute == null) {
            throw new RiceIllegalArgumentException("Failed to load RuleValidationAttribute for: " + extensionDefinition);
        }
        return attribute;
    }
}

