/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.dao.ojb;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.sys.framework.rest.SearchResults;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.institutionalproposal.dao.InstitutionalProposalDao;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.dao.impl.LookupDaoOjb;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class InstitutionalProposalDaoOjb
extends LookupDaoOjb
implements InstitutionalProposalDao {
    private static final String ACTIVE = "active";
    private static final String UPDATE_TIMESTAMP = "updateTimestamp";
    private static final String PROPOSAL_SEQUENCE_STATUS = "proposalSequenceStatus";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    @Override
    public Long getProposalId(Award award) {
        Criteria crit = new Criteria();
        crit.addEqualTo("proposalNumber", (Object)award.getProposalNumber());
        ReportQueryByCriteria q = QueryFactory.newReportQuery(InstitutionalProposal.class, (Criteria)crit);
        q.setAttributes(new String[]{"proposalId"});
        Iterator resultsIter = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)q);
        if (!resultsIter.hasNext()) {
            return null;
        }
        Long proposalId = (Long)resultsIter.next();
        while (resultsIter.hasNext()) {
            resultsIter.next();
        }
        return proposalId;
    }

    @Override
    public SearchResults<InstitutionalProposal> retrievePopulatedInstitutionalProposalByCriteria(Map<String, Object> fieldValues, java.util.Date updatedSince, Integer page, Integer numberPerPage) {
        SearchResults<InstitutionalProposal> result = new SearchResults<InstitutionalProposal>();
        Criteria origCrit = this.getCollectionCriteriaFromMap((BusinessObject)new InstitutionalProposal(), fieldValues);
        Criteria crit = new Criteria();
        crit.addEqualTo(PROPOSAL_SEQUENCE_STATUS, (Object)VersionStatus.ACTIVE.toString());
        if (updatedSince != null) {
            crit.addGreaterOrEqualThan((Object)UPDATE_TIMESTAMP, (Object)new Date(updatedSince.getTime()));
        }
        crit.addAndCriteria(origCrit);
        QueryByCriteria newCrit = QueryFactory.newQuery(InstitutionalProposal.class, (Criteria)crit);
        if (page != null) {
            result.setTotalResults(this.getPersistenceBrokerTemplate().getCount((Query)newCrit));
            newCrit.setStartAtIndex((page - 1) * numberPerPage);
            newCrit.setEndAtIndex(page * numberPerPage);
        }
        result.setResults(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)newCrit));
        if (page == null) {
            result.setTotalResults(result.getResults().size());
        }
        return result;
    }

    @Override
    public List<InstitutionalProposal> getProposalsModifiedBetween(java.util.Date startDate, java.util.Date endDate) {
        Criteria crit = new Criteria();
        if (startDate != null) {
            crit.addGreaterOrEqualThan((Object)UPDATE_TIMESTAMP, (Object)new Date(startDate.getTime()));
        }
        if (endDate != null) {
            crit.addLessOrEqualThan((Object)UPDATE_TIMESTAMP, (Object)new Date(endDate.getTime()));
        }
        QueryByCriteria finalCriteria = QueryFactory.newQuery(InstitutionalProposal.class, (Criteria)crit);
        return new ArrayList<InstitutionalProposal>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)finalCriteria));
    }

    @Override
    public List<InstitutionalProposal> getIpByIpNumber(String ipNumber, boolean activeVersionOnly) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("proposalNumber", ipNumber);
        if (activeVersionOnly) {
            criteria.put(PROPOSAL_SEQUENCE_STATUS, VersionStatus.ACTIVE.toString());
        }
        return (List)this.getBusinessObjectService().findMatching(InstitutionalProposal.class, criteria);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

