/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import org.drools.core.SessionConfiguration;
import org.drools.core.impl.AbstractKieSessionsPool;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.impl.StatefulSessionPool;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;

public class KieSessionsPoolImpl
extends AbstractKieSessionsPool {
    private final KnowledgeBaseImpl kBase;

    KieSessionsPoolImpl(KnowledgeBaseImpl kBase, int initialSize) {
        super(initialSize);
        this.kBase = kBase;
    }

    public KieSession newKieSession() {
        return this.newKieSession(this.kBase.getSessionConfiguration());
    }

    public KieSession newKieSession(KieSessionConfiguration conf) {
        return this.getPool(conf, false).get();
    }

    public StatelessKieSession newStatelessKieSession() {
        return this.newStatelessKieSession(this.kBase.getSessionConfiguration());
    }

    public StatelessKieSession newStatelessKieSession(KieSessionConfiguration conf) {
        return new StatelessKnowledgeSessionImpl(conf, this.getPool(conf, true));
    }

    @Override
    protected String getKey(String kSessionName, KieSessionConfiguration conf, boolean stateless) {
        String key = stateless ? "DEFAULT_STATELESS" : "DEFAULT";
        return conf == null ? key : key + "@" + System.identityHashCode(conf);
    }

    @Override
    protected StatefulSessionPool createStatefulSessionPool(String kSessionName, KieSessionConfiguration conf, boolean stateless) {
        return new StatefulSessionPool(this.kBase, this.initialSize, () -> stateless ? this.kBase.internalCreateStatefulKnowledgeSession(this.environment, (SessionConfiguration)conf).setStateless(true) : (StatefulKnowledgeSessionImpl)this.kBase.newKieSession(conf, this.environment));
    }
}

