/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.Macro;
import freemarker.core.ParameterRole;
import freemarker.core.TextBlock;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class KualiTemplateUtils {
    private KualiTemplateUtils() {
    }

    public static void invokeMacro(Environment env, Macro macro, Map args, String body) {
        HashMap wrappedArgs = new HashMap();
        Iterator argEntryIterator = args.entrySet().iterator();
        while (argEntryIterator.hasNext()) {
            Map.Entry argEntry = argEntryIterator.next();
            try {
                wrappedArgs.put(argEntry.getKey(), new WrappedObjectExpression(argEntry.getValue()));
            }
            catch (TemplateModelException e) {
                throw new RuntimeException("Error wrapping argument as a FreeMarker model element", e);
            }
        }
        try {
            env.visit(macro, wrappedArgs, null, null, body == null ? null : new TextBlock(body));
        }
        catch (TemplateException e) {
            throw new RuntimeException("Error invoking macro " + macro.getCanonicalForm(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error invoking macro " + macro.getCanonicalForm(), e);
        }
    }

    private static class WrappedObjectExpression
    extends Expression {
        private final Object wrappedObject;
        private final TemplateModel model;

        private WrappedObjectExpression(Object wrappedObject) throws TemplateModelException {
            this.wrappedObject = wrappedObject;
            this.model = wrappedObject instanceof TemplateModel ? (TemplateModel)wrappedObject : ObjectWrapper.DEFAULT_WRAPPER.wrap(wrappedObject);
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            return this.model;
        }

        boolean isLiteral() {
            return false;
        }

        protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
            try {
                return new WrappedObjectExpression(this.wrappedObject);
            }
            catch (TemplateModelException e) {
                throw new RuntimeException("Error cloning wrapped object expression", e);
            }
        }

        public String getCanonicalForm() {
            return "-KUALI-wrapped-object-expression-" + (this.wrappedObject == null ? "null" : this.wrappedObject.getClass().getName());
        }

        String getNodeTypeSymbol() {
            return "-KUALI-wrapped-object-expression";
        }

        int getParameterCount() {
            return 0;
        }

        Object getParameterValue(int idx) {
            return null;
        }

        ParameterRole getParameterRole(int idx) {
            return null;
        }
    }
}

