/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.rankeval;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchHit;

public class RatedSearchHit
implements Writeable,
ToXContentObject {
    private final SearchHit searchHit;
    private final Optional<Integer> rating;
    private static final ParseField HIT_FIELD = new ParseField("hit", new String[0]);
    private static final ParseField RATING_FIELD = new ParseField("rating", new String[0]);
    private static final ConstructingObjectParser<RatedSearchHit, Void> PARSER = new ConstructingObjectParser("rated_hit", true, a -> new RatedSearchHit((SearchHit)a[0], (Optional)a[1]));

    public RatedSearchHit(SearchHit searchHit, Optional<Integer> rating) {
        this.searchHit = searchHit;
        this.rating = rating;
    }

    RatedSearchHit(StreamInput in) throws IOException {
        this(SearchHit.readSearchHit((StreamInput)in), in.readBoolean() ? Optional.of(in.readVInt()) : Optional.empty());
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.searchHit.writeTo(out);
        out.writeBoolean(this.rating.isPresent());
        if (this.rating.isPresent()) {
            out.writeVInt(this.rating.get().intValue());
        }
    }

    public SearchHit getSearchHit() {
        return this.searchHit;
    }

    public Optional<Integer> getRating() {
        return this.rating;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("hit", (ToXContent)this.searchHit);
        builder.field("rating", (Integer)this.rating.orElse(null));
        builder.endObject();
        return builder;
    }

    public static RatedSearchHit parse(XContentParser parser) throws IOException {
        return (RatedSearchHit)PARSER.apply(parser, null);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RatedSearchHit other = (RatedSearchHit)obj;
        return Objects.equals(this.rating, other.rating) && Objects.equals(this.searchHit, other.searchHit);
    }

    public final int hashCode() {
        return Objects.hash(this.rating, this.searchHit);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> SearchHit.fromXContent((XContentParser)p), HIT_FIELD);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? Optional.empty() : Optional.of(p.intValue()), RATING_FIELD, ObjectParser.ValueType.INT_OR_NULL);
    }
}

