/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.property;

import com.codiform.moo.GetPropertyException;
import com.codiform.moo.SetPropertyException;
import com.codiform.moo.annotation.MapProperty;
import com.codiform.moo.property.AbstractMapProperty;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MapMethodProperty
extends AbstractMapProperty {
    private Method getter;
    private Method setter;
    private Class<?> type;
    private String name;
    private String expression;
    private String getterFailure;
    private boolean explicit;
    private boolean ignore;

    public MapMethodProperty(Method setter, MapProperty annotation, String name, String expression, boolean explicit, boolean ignore) {
        super(annotation);
        this.setter = setter;
        this.name = name;
        this.expression = expression;
        this.explicit = explicit;
        this.ignore = ignore;
        this.type = setter.getParameterTypes()[0];
        if (!setter.isAccessible()) {
            setter.setAccessible(true);
        }
        this.findGetter(setter.getDeclaringClass());
    }

    private void findGetter(Class<?> searchClass) {
        this.getter = this.findGetter(searchClass, "get");
        if (this.getter == null) {
            this.getterFailure = "No get " + this.name + " getter.";
        }
        if (this.getter != null && !this.getter.getReturnType().isAssignableFrom(this.type)) {
            this.getter = null;
            this.getterFailure = "Getter return type is incompatible with " + this.type.getName();
        }
    }

    private Method findGetter(Class<?> startClass, String prefix) {
        StringBuilder getterBuilder = new StringBuilder(prefix);
        getterBuilder.append(Character.toUpperCase(this.name.charAt(0)));
        if (this.name.length() > 1) {
            getterBuilder.append(this.name.substring(1));
        }
        Method getter = null;
        String getterName = getterBuilder.toString();
        for (Class<?> currentClass = startClass; getter == null && currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                getter = currentClass.getDeclaredMethod(getterName, new Class[0]);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return getter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSourcePropertyExpression() {
        return this.expression;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public void setValue(Object instance, Object value) {
        this.checkValue(value);
        try {
            this.setter.invoke(instance, value);
        }
        catch (IllegalArgumentException exception) {
            throw new SetPropertyException(this.getName(), this.getType(), value, exception);
        }
        catch (IllegalAccessException exception) {
            throw new SetPropertyException(this.getName(), this.getType(), value, exception);
        }
        catch (InvocationTargetException exception) {
            throw new SetPropertyException(this.getName(), this.getType(), value, exception);
        }
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.setter.getDeclaringClass();
    }

    @Override
    public boolean isExplicit() {
        return this.explicit;
    }

    @Override
    public boolean isIgnored() {
        return this.ignore;
    }

    @Override
    public boolean canGetValue() {
        return this.getter != null;
    }

    @Override
    public Object getValue(Object instance) {
        if (this.getter == null) {
            throw new UnsupportedOperationException("Cannot get value: " + this.getterFailure);
        }
        try {
            this.getter.setAccessible(true);
            return this.getter.invoke(instance, new Object[0]);
        }
        catch (IllegalArgumentException exception) {
            throw new GetPropertyException(this.getName(), this.getType(), exception);
        }
        catch (IllegalAccessException exception) {
            throw new GetPropertyException(this.getName(), this.getType(), exception);
        }
        catch (InvocationTargetException exception) {
            throw new GetPropertyException(this.getName(), this.getType(), exception);
        }
    }
}

