/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.workgroup;

import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kew.workgroup.GroupId;

public final class GroupNameId
implements GroupId {
    private static final long serialVersionUID = -4625193242111678434L;
    private String namespace = "KUALI";
    private String nameId;

    public GroupNameId(String nameId) {
        this.nameId = nameId;
        this.namespace = Utilities.parseGroupNamespaceCode(nameId);
        this.nameId = Utilities.parseGroupName(nameId);
    }

    public GroupNameId(String namespace, String nameId) {
        this.namespace = namespace;
        this.nameId = nameId;
    }

    public String getNameId() {
        return this.nameId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isEmpty() {
        return this.nameId == null || this.nameId.trim().length() == 0;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj != null && obj instanceof GroupNameId) {
            GroupNameId w = (GroupNameId)obj;
            if (w.getNameId() != null && this.getNameId() != null) {
                return w.getNameId().equals(this.getNameId()) && w.getNamespace().equals(this.getNamespace());
            }
            return false;
        }
        return isEqual;
    }

    public int hashCode() {
        if (this.nameId == null) {
            return 0;
        }
        return this.nameId.hashCode();
    }

    public String toString() {
        if (this.nameId != null) {
            return this.nameId;
        }
        return "null";
    }
}

