/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.dc.tm;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.kuali.coeus.dc.common.db.ConnectionDaoService;
import org.kuali.coeus.dc.common.db.PreparedStatementUtils;
import org.kuali.coeus.dc.tm.KewDocHeaderDao;
import org.kuali.coeus.dc.tm.KewDocHeaderStatus;
import org.kuali.coeus.dc.tm.TimeAndMoneyDocumentStatusDao;

public class TimeAndMoneyDocumentStatusDaoImpl
implements TimeAndMoneyDocumentStatusDao {
    private static final Logger LOG = Logger.getLogger(TimeAndMoneyDocumentStatusDaoImpl.class.getName());
    private static final String ARCHIVED_STATUS = "ARCHIVED";
    private static final String PENDING_STATUS = "PENDING";
    private static final String CANCELED_STATUS = "CANCELED";
    private static final String ACTIVE_STATUS = "ACTIVE";
    private static final String MAX_ACTIVE_DOCUMENT_QUERY = "select max(CAST(DOCUMENT_NUMBER AS DECIMAL (38,0))) from TIME_AND_MONEY_DOCUMENT where TIME_AND_MONEY_DOC_STATUS = 'ARCHIVED' group by AWARD_NUMBER";
    private static final String UPDATE_ACTIVE_TIME_AND_MONEY_DOC_STATUS = "update TIME_AND_MONEY_DOCUMENT doc set TIME_AND_MONEY_DOC_STATUS = 'ACTIVE' where DOCUMENT_NUMBER = ?";
    private static final String UPDATE_TIME_AND_MONEY_DOC_STATUS = "update TIME_AND_MONEY_DOCUMENT set TIME_AND_MONEY_DOC_STATUS = ? where DOCUMENT_NUMBER = ?";
    private ConnectionDaoService connectionDaoService;
    private KewDocHeaderDao krewDocHeaderDao;
    private List<String> canceledStatuses = new ArrayList<String>();
    private List<String> pendingStatuses;
    private List<String> activeStatuses;

    public TimeAndMoneyDocumentStatusDaoImpl() {
        this.canceledStatuses.add("X");
        this.canceledStatuses.add("D");
        this.pendingStatuses = new ArrayList<String>();
        this.pendingStatuses.add("I");
        this.pendingStatuses.add("S");
        this.pendingStatuses.add("R");
        this.pendingStatuses.add("E");
        this.activeStatuses = new ArrayList<String>();
        this.activeStatuses.add("P");
        this.activeStatuses.add("F");
    }

    @Override
    public void updateTimeAndMoneyDocumentStatusFromKew() {
        List<KewDocHeaderStatus> krewDocHeaderStatuses = this.krewDocHeaderDao.getTimeAndMoneyDocumentHeaderStatus();
        Connection connection = this.connectionDaoService.getCoeusConnection();
        try (PreparedStatement setFromKewStatement = connection.prepareStatement(UPDATE_TIME_AND_MONEY_DOC_STATUS);
             PreparedStatement maxActiveDocStatement = connection.prepareStatement(MAX_ACTIVE_DOCUMENT_QUERY);
             PreparedStatement setActiveStatement = connection.prepareStatement(UPDATE_ACTIVE_TIME_AND_MONEY_DOC_STATUS);){
            for (KewDocHeaderStatus status : krewDocHeaderStatuses) {
                PreparedStatementUtils.setString(1, this.getDocumentStatusFromKewStatus(status.documentStatusCode, status.documentHeaderId), PreparedStatementUtils.setString(2, status.documentHeaderId, setFromKewStatement));
                setFromKewStatement.execute();
            }
            try (ResultSet rs = maxActiveDocStatement.executeQuery();){
                while (rs.next()) {
                    PreparedStatementUtils.setString(1, rs.getString(1), setActiveStatement).execute();
                }
            }
            LOG.info("Time and Money Document statuses have been updated successfully.");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDocumentStatusFromKewStatus(String statusCode, String documentNumber) {
        if (this.canceledStatuses.contains(statusCode)) {
            return CANCELED_STATUS;
        }
        if (this.pendingStatuses.contains(statusCode)) {
            return PENDING_STATUS;
        }
        if (this.activeStatuses.contains(statusCode)) {
            return ARCHIVED_STATUS;
        }
        LOG.warning("Unknown document status code encountered. Document Number = '" + documentNumber + "', Status = '" + statusCode + "'");
        return ARCHIVED_STATUS;
    }

    public ConnectionDaoService getConnectionDaoService() {
        return this.connectionDaoService;
    }

    public void setConnectionDaoService(ConnectionDaoService connectionDaoService) {
        this.connectionDaoService = connectionDaoService;
    }

    public KewDocHeaderDao getKrewDocHeaderDao() {
        return this.krewDocHeaderDao;
    }

    public void setKewDocHeaderDao(KewDocHeaderDao krewDocHeaderDao) {
        this.krewDocHeaderDao = krewDocHeaderDao;
    }
}

