/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.notification;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.notification.CommitteeReplacementParameters;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.notification.impl.NotificationRendererBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.service.BusinessObjectService;

public class CommitteeNotificationRenderer
extends NotificationRendererBase {
    private static final long serialVersionUID = 6334584979829689495L;
    private CommitteeBase committee;
    private transient BusinessObjectService businessObjectService;
    private transient KcPersonService kcPersonService;

    public CommitteeNotificationRenderer(CommitteeBase committee) {
        this.committee = committee;
    }

    @Override
    public Map<String, String> getDefaultReplacementParameters() {
        String[] replacementParameters = CommitteeReplacementParameters.REPLACEMENT_PARAMETERS;
        Map<String, String> params = super.getDefaultReplacementParameters();
        String key = null;
        for (int i = 0; i < replacementParameters.length; ++i) {
            key = replacementParameters[i];
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{DOCUMENT_NUMBER}")) {
                params.put(key, this.committee.getCommitteeDocument().getDocumentNumber());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{SEQUENCE_NUMBER}")) {
                params.put(key, this.committee.getSequenceNumber().toString());
                continue;
            }
            if (!StringUtils.equals((CharSequence)key, (CharSequence)"{COMMITTEE_NAME}")) continue;
            params.put(key, this.committee.getCommitteeName().toString());
        }
        return params;
    }

    public CommitteeBase getCommittee() {
        return this.committee;
    }

    public void setCommittee(CommitteeBase committee) {
        this.committee = committee;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KNSServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    @Override
    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

