/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.ShallowEtagHeaderFilter;

public class StaticResourceCachingFilter
extends ShallowEtagHeaderFilter {
    public static final String CACHE_DURATION_INIT_PARAM = "cacheDuration";
    public static final int DEFAULT_CACHE_DURATION = 300;
    private int cacheDuration = 300;

    public void initFilterBean() throws ServletException {
        String cacheDurationString = this.getFilterConfig().getInitParameter(CACHE_DURATION_INIT_PARAM);
        if (cacheDurationString != null) {
            this.cacheDuration = Integer.parseInt(cacheDurationString);
        }
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        response.setHeader("Cache-Control", String.format("max-age=%d", this.cacheDuration));
        super.doFilterInternal(request, response, filterChain);
    }
}

