/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.compliance.core.AddSpecialReviewEvent;
import org.kuali.coeus.common.framework.compliance.core.SaveSpecialReviewEvent;
import org.kuali.coeus.common.framework.compliance.core.SaveSpecialReviewLinkEvent;
import org.kuali.coeus.common.framework.compliance.core.SpecialReviewService;
import org.kuali.coeus.common.notification.impl.SpecialReviewNotificationRenderer;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.notification.AwardNotification;
import org.kuali.kra.award.notification.AwardNotificationContext;
import org.kuali.kra.award.notification.AwardNotificationRenderer;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.award.web.struts.action.AwardAction;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;

public class AwardSpecialReviewAction
extends AwardAction {
    private static final String SAVE_SPECIAL_REVIEW_FIELD = "document.awardList[0].specialReviews";
    private static final String CONFIRM_DELETE_SPECIAL_REVIEW_KEY = "confirmDeleteSpecialReview";
    private SpecialReviewService specialReviewService;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        AwardForm awardForm = (AwardForm)form;
        awardForm.getSpecialReviewHelper().prepareView();
        return forward;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.refresh(mapping, form, request, response);
        String prefix = this.getSpecialReviewService().getProtocolSaveLocationPrefix(request.getParameterMap());
        AwardForm awardForm = (AwardForm)form;
        AwardSpecialReview awardSpecialReview = null;
        if (StringUtils.startsWith((CharSequence)prefix, (CharSequence)"specialReviewHelper.newSpecialReview")) {
            awardSpecialReview = (AwardSpecialReview)awardForm.getSpecialReviewHelper().getNewSpecialReview();
        } else {
            int index = this.getSpecialReviewService().getProtocolIndex(prefix);
            if (index != -1) {
                awardSpecialReview = awardForm.getAwardDocument().getAward().getSpecialReviews().get(index);
            }
        }
        awardForm.getSpecialReviewHelper().prepareProtocolLinkViewFields(awardSpecialReview);
        return forward;
    }

    public ActionForward addSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument document = awardForm.getAwardDocument();
        AwardSpecialReview specialReview = (AwardSpecialReview)awardForm.getSpecialReviewHelper().getNewSpecialReview();
        List<AwardSpecialReview> specialReviews = document.getAward().getSpecialReviews();
        boolean isProtocolLinkingEnabled = false;
        if ("1".equals(specialReview.getSpecialReviewTypeCode())) {
            isProtocolLinkingEnabled = awardForm.getSpecialReviewHelper().getIsIrbProtocolLinkingEnabled();
        } else if ("2".equals(specialReview.getSpecialReviewTypeCode())) {
            isProtocolLinkingEnabled = awardForm.getSpecialReviewHelper().getIsIacucProtocolLinkingEnabled();
        }
        awardForm.getSpecialReviewHelper().prepareProtocolLinkViewFields(specialReview);
        ActionForward forward = mapping.findForward("basic");
        if (this.applyRules((DocumentEvent)new AddSpecialReviewEvent<AwardSpecialReview>((Document)document, specialReview, specialReviews, isProtocolLinkingEnabled))) {
            specialReview.setSpecialReviewNumber(document.getDocumentNextValue("SPECIAL_REVIEW_NUMBER"));
            document.getAward().getSpecialReviews().add(specialReview);
            awardForm.getSpecialReviewHelper().setNewSpecialReview(new AwardSpecialReview());
            if (specialReview.getSpecialReviewType() == null) {
                specialReview.refreshReferenceObject("specialReviewType");
            }
            AwardNotificationContext context = null;
            SpecialReviewNotificationRenderer renderer = new SpecialReviewNotificationRenderer(new AwardNotificationRenderer(document.getAward()), specialReview);
            if (StringUtils.equals((CharSequence)specialReview.getSpecialReviewType().getSpecialReviewTypeCode(), (CharSequence)"1")) {
                context = new AwardNotificationContext(document.getAward(), "552", "Special Review Inserted", renderer, "specialReview");
            } else if (StringUtils.equals((CharSequence)specialReview.getSpecialReviewType().getSpecialReviewTypeCode(), (CharSequence)"2")) {
                context = new AwardNotificationContext(document.getAward(), "554", "Special Review Inserted", renderer, "specialReview");
            }
            if (context != null) {
                if (awardForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                    awardForm.getNotificationHelper().initializeDefaultValues(context);
                    forward = mapping.findForward("notificationEditor");
                } else {
                    this.getNotificationService().sendNotificationAndPersist(context, new AwardNotification(), document.getAward());
                }
            }
        }
        return forward;
    }

    public ActionForward deleteSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_SPECIAL_REVIEW_KEY, "question.special.review.delete.confirmation", new String[0]), CONFIRM_DELETE_SPECIAL_REVIEW_KEY, "");
    }

    public ActionForward confirmDeleteSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_SPECIAL_REVIEW_KEY.equals(question)) {
            AwardForm awardForm = (AwardForm)form;
            AwardDocument document = awardForm.getAwardDocument();
            AwardSpecialReview specialReview = document.getAward().getSpecialReviews().get(this.getLineToDelete(request));
            document.getAward().getSpecialReviews().remove(specialReview);
            if (specialReview.getSpecialReviewType() == null) {
                specialReview.refreshReferenceObject("specialReviewType");
            }
            AwardNotificationContext context = null;
            SpecialReviewNotificationRenderer renderer = new SpecialReviewNotificationRenderer(new AwardNotificationRenderer(document.getAward()), specialReview);
            if (StringUtils.equals((CharSequence)specialReview.getSpecialReviewType().getSpecialReviewTypeCode(), (CharSequence)"1")) {
                context = new AwardNotificationContext(document.getAward(), "553", "Special Review Deleted", renderer, "specialReview");
            } else if (StringUtils.equals((CharSequence)specialReview.getSpecialReviewType().getSpecialReviewTypeCode(), (CharSequence)"2")) {
                context = new AwardNotificationContext(document.getAward(), "555", "Special Review Deleted", renderer, "specialReview");
            }
            if (context != null) {
                if (awardForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                    awardForm.getNotificationHelper().initializeDefaultValues(context);
                    forward = mapping.findForward("notificationEditor");
                } else {
                    this.getNotificationService().sendNotificationAndPersist(context, new AwardNotification(), document.getAward());
                }
            }
        }
        return forward;
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        AwardForm awardForm = (AwardForm)form;
        AwardDocument document = awardForm.getAwardDocument();
        List<AwardSpecialReview> specialReviews = document.getAward().getSpecialReviews();
        List<String> linkedProtocolNumbers = awardForm.getSpecialReviewHelper().getLinkedProtocolNumbers();
        boolean isAwardIrbProtocolLinkingEnabled = awardForm.getSpecialReviewHelper().getIsIrbProtocolLinkingEnabled();
        boolean isAwardIacucProtocolLinkingEnabled = awardForm.getSpecialReviewHelper().getIsIacucProtocolLinkingEnabled();
        if (awardForm.getAwardDocument().getAward().getSpecialReviews() == null || awardForm.getAwardDocument().getAward().getSpecialReviews().isEmpty()) {
            awardForm.getAwardDocument().getAward().setSpecialReviewIndicator("N");
        } else {
            awardForm.getAwardDocument().getAward().setSpecialReviewIndicator("Y");
        }
        if ((isAwardIrbProtocolLinkingEnabled || isAwardIacucProtocolLinkingEnabled) && this.applyRules((DocumentEvent)new SaveSpecialReviewLinkEvent<AwardSpecialReview>((Document)document, specialReviews, linkedProtocolNumbers))) {
            awardForm.getSpecialReviewHelper().syncProtocolFundingSourcesWithSpecialReviews();
        }
        if (this.applyRules((DocumentEvent)new SaveSpecialReviewEvent<AwardSpecialReview>(SAVE_SPECIAL_REVIEW_FIELD, (Document)document, specialReviews, isAwardIrbProtocolLinkingEnabled, isAwardIacucProtocolLinkingEnabled))) {
            forward = super.save(mapping, form, request, response);
        }
        return forward;
    }

    public ActionForward viewNewSpecialReviewProtocolLink(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewProtocolUrl = "";
        AwardForm awardForm = (AwardForm)form;
        AwardSpecialReview awardSpecialReview = (AwardSpecialReview)awardForm.getSpecialReviewHelper().getNewSpecialReview();
        viewProtocolUrl = this.getViewProtocolUrl(awardSpecialReview);
        return new ActionForward(viewProtocolUrl, true);
    }

    public ActionForward viewSpecialReviewProtocolLink(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewProtocolUrl = "";
        AwardForm awardForm = (AwardForm)form;
        String lineNumber = request.getParameter("line");
        if (NumberUtils.isNumber((String)lineNumber)) {
            int index = Integer.parseInt(lineNumber);
            AwardSpecialReview awardSpecialReview = awardForm.getAwardDocument().getAward().getSpecialReviews().get(index);
            viewProtocolUrl = this.getViewProtocolUrl(awardSpecialReview);
        }
        return new ActionForward(viewProtocolUrl, true);
    }

    private String getViewProtocolUrl(AwardSpecialReview specialReview) throws Exception {
        Object viewProtocolUrl = "";
        String protocolNumber = specialReview.getProtocolNumber();
        String routeHeaderId = this.getSpecialReviewService().getViewSpecialReviewProtocolRouteHeaderId(protocolNumber, specialReview.getSpecialReviewTypeCode());
        if (StringUtils.isNotEmpty((CharSequence)routeHeaderId)) {
            viewProtocolUrl = this.buildForwardUrl(routeHeaderId) + "&viewDocument=true";
        }
        return viewProtocolUrl;
    }

    public SpecialReviewService getSpecialReviewService() {
        if (this.specialReviewService == null) {
            this.specialReviewService = KcServiceLocator.getService(SpecialReviewService.class);
        }
        return this.specialReviewService;
    }

    public void setSpecialReviewService(SpecialReviewService specialReviewService) {
        this.specialReviewService = specialReviewService;
    }
}

