/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.onlinereview;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.sys.framework.controller.KcTransactionalDocumentActionBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewFormBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewService;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolOnlineReviewRedirectActionBase
extends KcTransactionalDocumentActionBase {
    private static final String PROTOCOL_DOCUMENT_NUMBER = "protocolDocumentNumber";
    private static final String PROTOCOL_ONLINE_REVIEW_DOCUMENT_NUMBER = "protocolOnlineReviewDocumentNumber";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        return forward;
    }

    public ActionForward redirectToProtocolFromReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolOnlineReviewFormBase protocolOnlineReviewForm = (ProtocolOnlineReviewFormBase)form;
        super.loadDocument((KualiDocumentFormBase)protocolOnlineReviewForm);
        HashMap<String, Long> keymap = new HashMap<String, Long>();
        if (protocolOnlineReviewForm.getProtocolOnlineReviewDocument().getProtocolOnlineReview().isActive()) {
            keymap.put("protocolId", protocolOnlineReviewForm.getProtocolOnlineReviewDocument().getProtocolOnlineReview().getProtocolId());
            ProtocolBase protocol = (ProtocolBase)this.getBusinessObjectService().findByPrimaryKey(this.getProtocolClass(), keymap);
            if (this.isOnlineReviewEnabled(form, protocol)) {
                return new ActionRedirect(String.format(this.getProtocolOnlineReviewActionIdHook() + ".do?methodToCall=startProtocolOnlineReview&%s=%s", PROTOCOL_DOCUMENT_NUMBER, protocol.getProtocolDocument().getDocumentNumber()));
            }
            return mapping.findForward("displayInactive");
        }
        return mapping.findForward("displayInactive");
    }

    protected abstract String getProtocolOnlineReviewActionIdHook();

    protected abstract Class<? extends ProtocolBase> getProtocolClass();

    private boolean isOnlineReviewEnabled(ActionForm form, ProtocolBase protocol) {
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        ProtocolSubmissionBase submission = protocol.getProtocolSubmission();
        boolean isUserOnlineReviewer = this.getProtocolOnlineReviewService().isProtocolReviewer(principalId, false, submission);
        boolean isProtocolInStateToBeReviewed = this.getProtocolOnlineReviewService().isProtocolInStateToBeReviewed(protocol);
        boolean isUserAdmin = this.getSystemAuthorizationService().hasRole(GlobalVariables.getUserSession().getPrincipalId(), "KC-UNT", this.getAdminRoleName());
        return isProtocolInStateToBeReviewed && (isUserOnlineReviewer || isUserAdmin);
    }

    protected String getAdminRoleName() {
        return "IRB Administrator";
    }

    private SystemAuthorizationService getSystemAuthorizationService() {
        return KcServiceLocator.getService(SystemAuthorizationService.class);
    }

    private ProtocolOnlineReviewService getProtocolOnlineReviewService() {
        return KcServiceLocator.getService(this.getProtocolOnlineReviewServiceClassHook());
    }

    protected abstract Class<? extends ProtocolOnlineReviewService> getProtocolOnlineReviewServiceClassHook();

    public ActionForward startProtocolOnlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String protocolOnlineReviewDocumentNumber = request.getParameter(PROTOCOL_ONLINE_REVIEW_DOCUMENT_NUMBER);
        ((ProtocolOnlineReviewFormBase)form).setDocument(this.getDocumentService().getByDocumentHeaderId(protocolOnlineReviewDocumentNumber));
        return mapping.findForward("displayInactive");
    }

    public ActionForward onlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("portal");
    }
}

