/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.question;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.questionnaire.framework.question.Question;
import org.kuali.coeus.common.questionnaire.framework.question.QuestionExplanation;
import org.kuali.coeus.common.questionnaire.framework.question.QuestionMultiChoice;
import org.kuali.coeus.common.questionnaire.impl.question.QuestionService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiMaintenanceForm;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;

public class QuestionMaintainableImpl
extends KraMaintainableImpl {
    private static final long serialVersionUID = 713068582185818373L;
    private static final String SEQUENCE_STATUS_ARCHIVED = "A";
    private transient BusinessObjectService businessObjectService;

    @Override
    public void prepareForSave() {
        super.prepareForSave();
        if (this.businessObject != null && this.businessObject instanceof KcPersistableBusinessObjectBase && this.businessObject instanceof Question) {
            Question question = (Question)this.businessObject;
            question.setDocumentNumber(this.getDocumentNumber());
            if (StringUtils.isNotBlank((CharSequence)((Question)this.businessObject).getLookupClass())) {
                GlobalVariables.getUserSession().addObject("lookupClassName", (Object)question.getLookupClass());
            }
            if (question.getQuestionSeqId() == null) {
                Long newQuestionId = KcServiceLocator.getService(SequenceAccessorService.class).getNextAvailableSequenceNumber("SEQ_QUESTION_ID", question.getClass());
                question.setQuestionSeqId(newQuestionId.intValue());
            }
        }
    }

    @Override
    public List<Section> getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        Question question;
        if (KNSGlobalVariables.getKualiForm() != null && KNSGlobalVariables.getKualiForm() instanceof KualiMaintenanceForm && StringUtils.isNotBlank((CharSequence)(question = (Question)((MaintenanceDocumentBase)((KualiMaintenanceForm)KNSGlobalVariables.getKualiForm()).getDocument()).getDocumentBusinessObject()).getLookupClass()) && StringUtils.isBlank((CharSequence)((String)GlobalVariables.getUserSession().retrieveObject("lookupClassName"))) && (GlobalVariables.getUserSession().retrieveObject("lookupReturnFields") == null || ((List)GlobalVariables.getUserSession().retrieveObject("lookupReturnFields")).size() == 0)) {
            GlobalVariables.getUserSession().addObject("lookupClassName", (Object)question.getLookupClass());
        }
        return new ArrayList<Section>();
    }

    public void doRouteStatusChange(DocumentHeader documentHeader) {
        this.executeAsLastActionUser(() -> {
            this.clearUnusedFieldValues();
            return null;
        });
    }

    private void clearUnusedFieldValues() {
        Question question = (Question)this.businessObject;
        if (question.getQuestionType() != null) {
            switch (question.getQuestionTypeId().intValue()) {
                case 1: {
                    question.setLookupClass(null);
                    question.setLookupReturn(null);
                    question.setDisplayedAnswers(null);
                    question.setMaxAnswers(null);
                    question.setAnswerMaxLength(null);
                    question.setQuestionMultiChoices(new ArrayList<QuestionMultiChoice>());
                    break;
                }
                case 2: {
                    question.setLookupClass(null);
                    question.setLookupReturn(null);
                    question.setDisplayedAnswers(null);
                    question.setMaxAnswers(null);
                    question.setAnswerMaxLength(null);
                    question.setQuestionMultiChoices(new ArrayList<QuestionMultiChoice>());
                    break;
                }
                case 3: {
                    question.setLookupClass(null);
                    question.setLookupReturn(null);
                    question.setQuestionMultiChoices(new ArrayList<QuestionMultiChoice>());
                    break;
                }
                case 7: {
                    question.setLookupClass(null);
                    question.setLookupReturn(null);
                    question.setQuestionMultiChoices(new ArrayList<QuestionMultiChoice>());
                    break;
                }
                case 4: {
                    question.setLookupClass(null);
                    question.setLookupReturn(null);
                    question.setAnswerMaxLength(null);
                    question.setQuestionMultiChoices(new ArrayList<QuestionMultiChoice>());
                    break;
                }
                case 5: {
                    question.setLookupClass(null);
                    question.setLookupReturn(null);
                    question.setQuestionMultiChoices(new ArrayList<QuestionMultiChoice>());
                    break;
                }
                case 6: {
                    question.setDisplayedAnswers(null);
                    question.setAnswerMaxLength(null);
                    question.setQuestionMultiChoices(new ArrayList<QuestionMultiChoice>());
                    break;
                }
                case 100: {
                    question.setDisplayedAnswers(question.getQuestionMultiChoices().size());
                }
            }
        }
    }

    public void saveBusinessObject() {
        Question newQuestion = (Question)this.businessObject;
        QuestionService questionService = KcServiceLocator.getService(QuestionService.class);
        Question oldQuestion = questionService.getQuestionByQuestionSequenceId(newQuestion.getQuestionSeqId());
        for (QuestionMultiChoice choice : newQuestion.getQuestionMultiChoices()) {
            choice.setQuestionId(newQuestion.getId());
        }
        if (oldQuestion != null && !oldQuestion.getId().equals(newQuestion.getId())) {
            oldQuestion.setSequenceStatus(SEQUENCE_STATUS_ARCHIVED);
            this.getBusinessObjectService().save((PersistableBusinessObject)oldQuestion);
        }
        super.saveBusinessObject();
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        Question newQuestion = (Question)document.getNewMaintainableObject().getBusinessObject();
        newQuestion.setQuestionSeqId(null);
        newQuestion.setSequenceNumber(1);
        for (QuestionMultiChoice choice : newQuestion.getQuestionMultiChoices()) {
            choice.setQuestionId(null);
            choice.setId(null);
        }
        for (QuestionExplanation questionExplanation : newQuestion.getQuestionExplanations()) {
            questionExplanation.setQuestionId(null);
            questionExplanation.setId(null);
        }
    }

    public void deleteBusinessObject() {
        if (this.businessObject == null) {
            return;
        }
        this.handleRelationshipsForDelete((Question)this.businessObject);
        super.deleteBusinessObject();
    }

    public void deleteDataObject() {
        Object dataObject = this.getDataObject();
        if (dataObject == null) {
            return;
        }
        this.handleRelationshipsForDelete((Question)dataObject);
        super.deleteDataObject();
    }

    private void handleRelationshipsForDelete(Question question) {
        if (question.getQuestionMultiChoices() != null && !question.getQuestionMultiChoices().isEmpty()) {
            this.getBusinessObjectService().delete(question.getQuestionMultiChoices());
        }
        if (question.getQuestionExplanations() != null && !question.getQuestionExplanations().isEmpty()) {
            this.getBusinessObjectService().delete(question.getQuestionExplanations());
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

