/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.irb.api;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.irb.api.dto.IrbProtocolActionDto;
import org.kuali.coeus.irb.api.dto.IrbProtocolDto;
import org.kuali.coeus.irb.api.dto.IrbProtocolPersonDto;
import org.kuali.coeus.irb.api.dto.IrbProtocolSubmissionDto;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLoggerFactory;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.NotImplementedException;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.approve.ProtocolApproveService;
import org.kuali.kra.irb.actions.delete.ProtocolDeleteService;
import org.kuali.kra.irb.actions.expeditedapprove.ProtocolExpeditedApproveBean;
import org.kuali.kra.irb.actions.grantexemption.ProtocolGrantExemptionBean;
import org.kuali.kra.irb.actions.grantexemption.ProtocolGrantExemptionService;
import org.kuali.kra.irb.actions.noreview.ProtocolReviewNotRequiredBean;
import org.kuali.kra.irb.actions.noreview.ProtocolReviewNotRequiredService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionService;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.protocol.ProtocolNumberService;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/api/v1/"})
@Controller(value="irbProtocolDocumentController")
public class IrbProtocolDocumentController
extends RestController
implements InitializingBean {
    public static final String PROTOCOL_PERSON_ROLE = "protocolPersonRole";
    public static final String ROLODEX = "rolodex";
    public static final String ACTION_ERROR_MESSAGE = "This action cannot be taken on a document that is not in progress.";
    @Autowired
    @Qualifier(value="restAuditLoggerFactory")
    private RestAuditLoggerFactory restAuditLoggerFactory;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="protocolNumberService")
    private ProtocolNumberService protocolNumberService;
    @Autowired
    @Qualifier(value="protocolPersonnelService")
    private ProtocolPersonnelService protocolPersonnelService;
    @Autowired
    @Qualifier(value="routeHeaderService")
    private RouteHeaderService routeHeaderService;
    @Autowired
    @Qualifier(value="commonApiService")
    private CommonApiService commonApiService;
    @Autowired
    @Qualifier(value="protocolSubmitActionService")
    private ProtocolSubmitActionService protocolSubmitActionService;
    @Autowired
    @Qualifier(value="protocolDeleteService")
    private ProtocolDeleteService protocolDeleteService;
    @Autowired
    @Qualifier(value="protocolApproveService")
    private ProtocolApproveService protocolApproveService;
    @Autowired
    @Qualifier(value="protocolGrantExemptionService")
    private ProtocolGrantExemptionService protocolGrantExemptionService;
    @Autowired
    @Qualifier(value="protocolReviewNotRequiredService")
    private ProtocolReviewNotRequiredService protocolReviewNotRequiredService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;
    @Autowired
    @Qualifier(value="configurationService")
    private ConfigurationService configurationService;
    private List<String> irbProtocolDtoProperties;
    private List<String> irbPersonDtoProperties;
    private List<String> irbProtocolActionDtoProperties;

    protected List<String> getDtoProperties(Class dtoClass) throws IntrospectionException {
        return Arrays.asList(Introspector.getBeanInfo(dtoClass).getPropertyDescriptors()).stream().map(FeatureDescriptor::getName).filter(prop -> !"class".equals(prop)).collect(Collectors.toList());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"irb-protocol-documents/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public IrbProtocolDto createProtocol(@RequestBody IrbProtocolDto protocolDto) throws WorkflowException, IllegalAccessException {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        ProtocolDocument protocolDocument = (ProtocolDocument)this.documentService.getNewDocument(ProtocolDocument.class);
        Protocol protocol = this.commonApiService.convertObject(protocolDto, Protocol.class);
        protocolDocument.setProtocol(protocol);
        protocol.setProtocolDocument(protocolDocument);
        protocolDocument.initialize();
        String protocolNumber = this.protocolNumberService.generateProtocolNumber();
        protocol.setProtocolNumber(protocolNumber);
        protocolDocument.initializeProtocolLocation();
        this.createInitialProtocolAction(protocol);
        this.addProtocolPersonnel(protocol, protocolDto.getProtocolPersons());
        this.saveDocument(protocolDocument);
        IrbProtocolDto irbProtocolDto = this.commonApiService.convertObject(protocolDocument.getProtocol(), IrbProtocolDto.class);
        irbProtocolDto.setDocNbr(protocolDocument.getDocumentNumber());
        irbProtocolDto.setStatus(protocolDocument.getProtocol().getProtocolStatusCode());
        return irbProtocolDto;
    }

    public void addProtocolPersonnel(Protocol protocol, List<IrbProtocolPersonDto> protocolDtos) {
        protocol.setProtocolPersons(new ArrayList<ProtocolPersonBase>());
        protocolDtos.stream().forEach(personDto -> this.addPerson(protocol, (IrbProtocolPersonDto)personDto));
    }

    public void addPerson(Protocol protocol, IrbProtocolPersonDto personDto) {
        ProtocolPerson protocolPerson = this.commonApiService.convertObject(personDto, ProtocolPerson.class);
        String personId = personDto.getPersonId();
        Integer rolodexId = personDto.getRolodexId();
        this.commonApiService.validatePerson(personId, rolodexId);
        if (protocolPerson.isPrincipalInvestigator()) {
            ProtocolPersonBase principalInvestigator = this.createPrincipalInvestigator(personId, rolodexId, protocol);
            principalInvestigator.setAffiliationTypeCode(protocolPerson.getAffiliationTypeCode());
            this.protocolPersonnelService.addProtocolPerson(protocol, principalInvestigator);
        } else {
            protocolPerson.setPersonName(this.getPersonName(personId, rolodexId));
            this.protocolPersonnelService.addProtocolPerson(protocol, protocolPerson);
        }
    }

    protected ProtocolPersonBase createPrincipalInvestigator(String personId, Integer rolodexId, Protocol protocol) {
        ProtocolPerson pi = new ProtocolPerson();
        pi.setProtocolPersonRoleId("PI");
        pi.setProtocolNumber(protocol.getProtocolNumber());
        pi.setSequenceNumber(0);
        pi.refreshReferenceObject(PROTOCOL_PERSON_ROLE);
        if (personId == null) {
            pi.refreshReferenceObject(ROLODEX);
            pi.setRolodexId((int)rolodexId);
        } else {
            pi.setPersonId(personId);
        }
        pi.setPersonName(this.getPersonName(personId, rolodexId));
        return pi;
    }

    protected String getPersonName(String personId, Integer rolodexId) {
        if (personId == null) {
            RolodexContract rolodex = this.rolodexService.getRolodex(rolodexId);
            return rolodex.getFullName();
        }
        KcPerson person = this.kcPersonService.getKcPersonByPersonId(personId);
        return person.getFullName();
    }

    public void createInitialProtocolAction(Protocol protocol) {
        protocol.getProtocolActions().clear();
        ProtocolAction protocolAction = new ProtocolAction(protocol, null, "100");
        protocolAction.setComments("100");
        protocol.getProtocolActions().add(protocolAction);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"irb-protocol-documents/{documentNumber}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    void deleteProtocol(@PathVariable Long documentNumber) throws WorkflowException {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        ProtocolDocument protocolDocument = this.getProtocolDocument(documentNumber);
        DocumentRouteHeaderValue routeHeader = this.routeHeaderService.getRouteHeader(protocolDocument.getDocumentHeader().getWorkflowDocument().getDocumentId());
        if (!routeHeader.getDocRouteStatus().equalsIgnoreCase("X")) {
            try {
                this.protocolDeleteService.delete(protocolDocument);
            }
            catch (InvalidActionTakenException e) {
                throw new UnprocessableEntityException("Document " + documentNumber + " is not in a state to be cancelled.", e);
            }
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"irb-protocol-documents/{documentNumber}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    IrbProtocolDto getProtocol(@PathVariable Long documentNumber) {
        this.assertUserHasReadAccess();
        this.commonApiService.clearErrors();
        ProtocolDocument protocolDocument = this.getProtocolDocument(documentNumber);
        Protocol protocol = protocolDocument.getProtocol();
        IrbProtocolDto protocolDto = this.commonApiService.convertObject(protocol, IrbProtocolDto.class);
        protocolDto.setDocNbr(protocolDocument.getDocumentNumber());
        protocolDto.setStatus(protocolDocument.getProtocol().getProtocolStatusCode());
        return protocolDto;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(method={RequestMethod.POST}, value={"irb-protocol-documents/{documentNumber}/submissions/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    IrbProtocolSubmissionDto takeAction(@RequestBody IrbProtocolActionDto protocolActionDto, @PathVariable Long documentNumber) throws Exception {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        ProtocolDocument protocolDocument = this.getProtocolDocument(documentNumber);
        List<ErrorMessage> errors = this.commonApiService.getAuditErrors((Document)protocolDocument);
        if (errors.size() == 0) {
            String actionTypeCode = protocolActionDto.getActionCode();
            Protocol protocol = protocolDocument.getProtocol();
            if (actionTypeCode.equalsIgnoreCase("101")) {
                this.submitForReview(protocolActionDto, protocolDocument, protocol);
            } else if (actionTypeCode.equalsIgnoreCase("205")) {
                this.performExpeditedApproval(protocolActionDto, protocolDocument, protocol);
            } else if (actionTypeCode.equalsIgnoreCase("206")) {
                this.performGrantExemption(protocolActionDto, protocol);
            } else {
                if (!actionTypeCode.equalsIgnoreCase("210")) throw new NotImplementedException();
                this.performIrbReviewNotRequired(protocolActionDto, protocolDocument, protocol);
            }
        } else {
            String errorsMessages = String.join((CharSequence)",", this.createValidationErrors(errors));
            throw new UnprocessableEntityException(errorsMessages);
        }
        ProtocolSubmission protocolSubmission = protocolDocument.getProtocol().getProtocolSubmission();
        IrbProtocolSubmissionDto submissionDto = this.commonApiService.convertObject(protocolSubmission, IrbProtocolSubmissionDto.class);
        submissionDto.setApprovalDate(protocolDocument.getProtocol().getApprovalDate());
        return submissionDto;
    }

    private List<String> createValidationErrors(List<ErrorMessage> errors) {
        return errors.stream().map(error -> MessageFormat.format(this.configurationService.getPropertyValueAsString(error.getErrorKey()), error.getMessageParameters())).collect(Collectors.toList());
    }

    private void performIrbReviewNotRequired(IrbProtocolActionDto protocolActionDto, ProtocolDocument protocolDocument, Protocol protocol) {
        if (!protocol.getProtocolStatus().getProtocolStatusCode().equalsIgnoreCase("101")) {
            throw new UnprocessableEntityException(ACTION_ERROR_MESSAGE);
        }
        ProtocolReviewNotRequiredBean reviewNotRequiredBean = this.commonApiService.convertObject(protocolActionDto, ProtocolReviewNotRequiredBean.class);
        this.protocolReviewNotRequiredService.reviewNotRequired(protocolDocument, reviewNotRequiredBean);
    }

    private void performGrantExemption(IrbProtocolActionDto protocolActionDto, Protocol protocol) throws Exception {
        if (!protocol.getProtocolStatus().getProtocolStatusCode().equalsIgnoreCase("101")) {
            throw new UnprocessableEntityException(ACTION_ERROR_MESSAGE);
        }
        ProtocolGrantExemptionBean exemptionBean = this.commonApiService.convertObject(protocolActionDto, ProtocolGrantExemptionBean.class);
        this.protocolGrantExemptionService.grantExemption(protocol, exemptionBean);
    }

    private void performExpeditedApproval(IrbProtocolActionDto protocolActionDto, ProtocolDocument protocolDocument, Protocol protocol) throws Exception {
        if (!protocol.getProtocolStatus().getProtocolStatusCode().equalsIgnoreCase("101")) {
            throw new UnprocessableEntityException(ACTION_ERROR_MESSAGE);
        }
        ProtocolExpeditedApproveBean approveBean = this.commonApiService.convertObject(protocolActionDto, ProtocolExpeditedApproveBean.class);
        approveBean.setAssignToAgenda(false);
        approveBean.setExpirationDate(this.protocolApproveService.buildExpirationDate(protocol, approveBean.getApprovalDate()));
        this.protocolApproveService.grantExpeditedApproval(protocolDocument, approveBean);
    }

    private void submitForReview(IrbProtocolActionDto protocolActionDto, ProtocolDocument protocolDocument, Protocol protocol) {
        if (!protocol.getProtocolStatus().getProtocolStatusCode().equalsIgnoreCase("100")) {
            throw new UnprocessableEntityException(ACTION_ERROR_MESSAGE);
        }
        ProtocolSubmitAction submitAction = this.commonApiService.convertObject(protocolActionDto, ProtocolSubmitAction.class);
        submitAction.setNewCommitteeId(submitAction.getCommitteeId());
        protocol.setInitialSubmissionDate(protocolActionDto.getInitialSubmissionDate());
        Timestamp actionTimestamp = protocolActionDto.getActionDate() != null ? new Timestamp(protocolActionDto.getActionDate().getTime()) : null;
        this.protocolSubmitActionService.submitToIrbForReview(protocolDocument, submitAction, actionTimestamp);
        protocol.getProtocolSubmission().setSubmissionDate(protocol.getInitialSubmissionDate());
        this.commonApiService.routeDocument((Document)protocolDocument);
    }

    private ProtocolDocument getProtocolDocument(Long documentNumber) {
        Document document = this.commonApiService.getDocumentFromDocId(documentNumber);
        if (!ProtocolDocument.class.isAssignableFrom(document.getClass())) {
            throw new ResourceNotFoundException("The docId used in the request was not of type ProtocolDocument.");
        }
        ProtocolDocument protocolDocument = (ProtocolDocument)document;
        return protocolDocument;
    }

    protected void saveDocument(ProtocolDocument protocolDocument) throws WorkflowException {
        WorkflowDocument workflowDocument = protocolDocument.getDocumentHeader().getWorkflowDocument();
        if (!this.commonApiService.isDocInModifiableState(workflowDocument)) {
            throw new UnprocessableEntityException("Document " + protocolDocument.getDocumentNumber() + " with status " + workflowDocument.getStatus() + " is not in a state to be saved.");
        }
        this.commonApiService.saveDocument((Document)protocolDocument);
    }

    public void afterPropertiesSet() throws Exception {
        this.irbProtocolDtoProperties = this.getDtoProperties(IrbProtocolDto.class);
        this.irbPersonDtoProperties = this.getDtoProperties(IrbProtocolPersonDto.class);
        this.irbProtocolActionDtoProperties = this.getDtoProperties(IrbProtocolActionDto.class);
    }

    public boolean isApiAuthEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "Document", "RESKC-2456_Enable_Api_Authorization");
    }

    protected void assertUserHasReadAccess() {
        if (this.isApiAuthEnabled() && (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", Protocol.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasWriteAccess() {
        if (this.isApiAuthEnabled() && (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Write Class", Collections.singletonMap("className", Protocol.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setProtocolNumberService(ProtocolNumberService protocolNumberService) {
        this.protocolNumberService = protocolNumberService;
    }

    public void setProtocolPersonnelService(ProtocolPersonnelService protocolPersonnelService) {
        this.protocolPersonnelService = protocolPersonnelService;
    }

    public void setRouteHeaderService(RouteHeaderService routeHeaderService) {
        this.routeHeaderService = routeHeaderService;
    }

    public void setCommonApiService(CommonApiService commonApiService) {
        this.commonApiService = commonApiService;
    }

    public void setProtocolSubmitActionService(ProtocolSubmitActionService protocolSubmitActionService) {
        this.protocolSubmitActionService = protocolSubmitActionService;
    }

    public void setProtocolApproveService(ProtocolApproveService protocolApproveService) {
        this.protocolApproveService = protocolApproveService;
    }

    public void setProtocolGrantExemptionService(ProtocolGrantExemptionService protocolGrantExemptionService) {
        this.protocolGrantExemptionService = protocolGrantExemptionService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }
}

