/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.krms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jws.WebParam;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.impl.krms.KcValidationAction;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableRadioButtonGroup;
import org.kuali.rice.core.api.uif.RemotableSelect;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.core.api.uif.RemotableTextarea;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttribute;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.framework.engine.Action;
import org.kuali.rice.krms.framework.type.ActionTypeService;
import org.kuali.rice.krms.framework.type.ValidationActionType;
import org.kuali.rice.krms.impl.type.KrmsTypeServiceBase;
import org.kuali.rice.krms.impl.validation.RadioButtonTypeServiceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="kcValidationActionTypeService")
@Lazy
public class KcValidationActionTypeServiceImpl
extends KrmsTypeServiceBase
implements ActionTypeService {
    @Autowired
    @Qualifier(value="krmsTypeRepositoryService")
    private KrmsTypeRepositoryService krmsTypeRepositoryService;

    public Action loadAction(ActionDefinition validationActionDefinition) {
        if (validationActionDefinition == null) {
            throw new RiceIllegalArgumentException("validationActionDefinition must not be null");
        }
        if (validationActionDefinition.getAttributes() == null) {
            throw new RiceIllegalArgumentException("validationActionDefinition must not be null");
        }
        if (!validationActionDefinition.getAttributes().containsKey("actionTypeCode")) {
            throw new RiceIllegalArgumentException("validationActionDefinition does not contain an actionTypeCode attribute");
        }
        String validationActionTypeCode = (String)validationActionDefinition.getAttributes().get("actionTypeCode");
        if (StringUtils.isBlank((CharSequence)validationActionTypeCode)) {
            throw new RiceIllegalArgumentException("actionTypeCode attribute must not be null or blank");
        }
        if (!validationActionDefinition.getAttributes().containsKey("actionMessage")) {
            throw new RiceIllegalArgumentException("validationActionDefinition does not contain an actionMessage attribute");
        }
        String validationMessage = (String)validationActionDefinition.getAttributes().get("actionMessage");
        if (StringUtils.isBlank((CharSequence)validationMessage)) {
            throw new RiceIllegalArgumentException("actionMessage attribute must not be null or blank");
        }
        String validationActionArea = null;
        String validationActionSection = null;
        String validationActionNavigateToPageId = null;
        String validationActionNavigateToSectionId = null;
        String validationActionUIPanel = null;
        if (validationActionDefinition.getNamespace().equals("KC-PD")) {
            if (!validationActionDefinition.getAttributes().containsKey("actionArea")) {
                throw new RiceIllegalArgumentException("validationActionDefinition does not contain an actionArea attribute");
            }
            validationActionArea = (String)validationActionDefinition.getAttributes().get("actionArea");
            if (StringUtils.isBlank((CharSequence)validationActionArea)) {
                throw new RiceIllegalArgumentException("actionArea attribute must not be null or blank");
            }
            if (!validationActionDefinition.getAttributes().containsKey("actionSection")) {
                throw new RiceIllegalArgumentException("validationActionDefinition does not contain an actionSection attribute");
            }
            validationActionSection = (String)validationActionDefinition.getAttributes().get("actionSection");
            if (!validationActionDefinition.getAttributes().containsKey("actionNavigateToPageId")) {
                throw new RiceIllegalArgumentException("validationActionDefinition does not contain an actionNavigateToPageId attribute");
            }
            validationActionNavigateToPageId = (String)validationActionDefinition.getAttributes().get("actionNavigateToPageId");
            if (StringUtils.isBlank((CharSequence)validationActionNavigateToPageId)) {
                throw new RiceIllegalArgumentException("actionNavigateToPageId attribute must not be null or blank");
            }
            if (!validationActionDefinition.getAttributes().containsKey("actionNavigateToSectionId")) {
                throw new RiceIllegalArgumentException("validationActionDefinition does not contain an actionNavigateToSectionId attribute");
            }
            validationActionNavigateToSectionId = (String)validationActionDefinition.getAttributes().get("actionNavigateToSectionId");
            if (StringUtils.isBlank((CharSequence)validationActionNavigateToSectionId)) {
                throw new RiceIllegalArgumentException("actionNavigateToSectionId attribute must not be null or blank");
            }
        } else {
            if (!validationActionDefinition.getAttributes().containsKey("actionUIPanel")) {
                throw new RiceIllegalArgumentException("validationActionDefinition does not contain an actionUIPanel attribute");
            }
            validationActionUIPanel = (String)validationActionDefinition.getAttributes().get("actionUIPanel");
            if (StringUtils.isBlank((CharSequence)validationActionUIPanel)) {
                throw new RiceIllegalArgumentException("actionUIPanel attribute must not be null or blank");
            }
        }
        if (ValidationActionType.WARNING.getCode().equals(validationActionTypeCode)) {
            return new KcValidationAction(ValidationActionType.WARNING, validationActionArea, validationActionSection, validationActionNavigateToPageId, validationActionNavigateToSectionId, validationActionUIPanel, validationMessage);
        }
        if (ValidationActionType.ERROR.getCode().equals(validationActionTypeCode)) {
            return new KcValidationAction(ValidationActionType.ERROR, validationActionArea, validationActionSection, validationActionNavigateToPageId, validationActionNavigateToSectionId, validationActionUIPanel, validationMessage);
        }
        return null;
    }

    public List<RemotableAttributeField> getAttributeFields(@WebParam(name="krmsTypeId") String krmsTypeId) throws RiceIllegalArgumentException {
        ArrayList<RemotableAttributeField> results = new ArrayList<RemotableAttributeField>();
        KrmsTypeDefinition krmsType = this.getKrmsTypeRepositoryService().getTypeById(krmsTypeId);
        if (krmsType == null) {
            throw new RiceIllegalArgumentException("krmsTypeId must be a valid id of a KRMS type");
        }
        List typeAttributes = krmsType.getAttributes();
        TreeMap attribDefIdSequenceNumbers = new TreeMap();
        TreeMap unsortedIdLables = new TreeMap();
        if (!CollectionUtils.isEmpty((Collection)typeAttributes)) {
            TreeMap<String, String> keyLabels = new TreeMap<String, String>();
            keyLabels.put(ValidationActionType.WARNING.getCode(), "Warning Action");
            keyLabels.put(ValidationActionType.ERROR.getCode(), "Error Action");
            KrmsAttributeDefinition attributeDefinition = null;
            RadioButtonTypeServiceUtil util = new RadioButtonTypeServiceUtil();
            for (KrmsTypeAttribute typeAttribute : typeAttributes) {
                RemotableAttributeField attributeField;
                attributeDefinition = this.getKrmsTypeRepositoryService().getAttributeDefinitionById(typeAttribute.getAttributeDefinitionId());
                if ("actionTypeCode".equals(attributeDefinition.getName())) {
                    attributeField = this.translateTypeAttribute(attributeDefinition, keyLabels);
                    results.add(attributeField);
                }
                if ("actionMessage".equals(attributeDefinition.getName())) {
                    attributeField = this.createMessageField(attributeDefinition);
                    results.add(attributeField);
                }
                if ("actionArea".equals(attributeDefinition.getName()) || "actionSection".equals(attributeDefinition.getName()) || "actionNavigateToPageId".equals(attributeDefinition.getName()) || "actionNavigateToSectionId".equals(attributeDefinition.getName())) {
                    attributeField = this.createTextField(attributeDefinition);
                    results.add(attributeField);
                }
                if (!"actionUIPanel".equals(attributeDefinition.getName())) continue;
                attributeField = this.createUIDropDown(attributeDefinition);
                results.add(attributeField);
            }
        }
        return results;
    }

    protected RemotableAttributeField createUIDropDown(KrmsAttributeDefinition krmsAttributeDefinition) {
        Map<String, String> uiOptions = this.getUIPanelDropDownOptions();
        RemotableSelect.Builder controlBuilder = RemotableSelect.Builder.create(uiOptions);
        controlBuilder.setMultiple(false);
        RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)krmsAttributeDefinition.getName());
        builder.setRequired(false);
        builder.setDataType(DataType.STRING);
        builder.setControl((RemotableAbstractControl.Builder)controlBuilder);
        builder.setLongLabel(krmsAttributeDefinition.getLabel());
        builder.setShortLabel("Action UI Panel");
        return builder.build();
    }

    protected Map<String, String> getUIPanelDropDownOptions() {
        return Collections.emptyMap();
    }

    private RemotableAttributeField createTextField(KrmsAttributeDefinition krmsAttributeDefinition) {
        RemotableTextInput.Builder controlBuilder = RemotableTextInput.Builder.create();
        controlBuilder.setSize(Integer.valueOf(100));
        controlBuilder.setWatermark("");
        RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)krmsAttributeDefinition.getName());
        if ("actionSection".equals(krmsAttributeDefinition.getName())) {
            builder.setRequired(false);
        } else {
            builder.setRequired(true);
        }
        builder.setDataType(DataType.STRING);
        builder.setControl((RemotableAbstractControl.Builder)controlBuilder);
        builder.setLongLabel(krmsAttributeDefinition.getLabel());
        builder.setShortLabel(krmsAttributeDefinition.getLabel());
        return builder.build();
    }

    private RemotableAttributeField createMessageField(KrmsAttributeDefinition krmsAttributeDefinition) {
        RemotableTextarea.Builder controlBuilder = RemotableTextarea.Builder.create();
        controlBuilder = RemotableTextarea.Builder.create();
        controlBuilder.setRows(Integer.valueOf(2));
        controlBuilder.setCols(Integer.valueOf(30));
        controlBuilder.setWatermark("Enter a Validation Action Message");
        RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)krmsAttributeDefinition.getName());
        builder.setRequired(true);
        builder.setDataType(DataType.STRING);
        builder.setControl((RemotableAbstractControl.Builder)controlBuilder);
        builder.setLongLabel(krmsAttributeDefinition.getLabel());
        builder.setShortLabel("Message");
        builder.setMinLength(Integer.valueOf(1));
        builder.setMaxLength(Integer.valueOf(4000));
        return builder.build();
    }

    RemotableAttributeField translateTypeAttribute(KrmsAttributeDefinition krmsAttributeDefinition, Map<String, String> valueLabels) {
        RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)krmsAttributeDefinition.getName());
        RemotableRadioButtonGroup.Builder controlBuilder = RemotableRadioButtonGroup.Builder.create(valueLabels);
        builder.setLongLabel(krmsAttributeDefinition.getLabel());
        builder.setName(krmsAttributeDefinition.getName());
        builder.setRequired(true);
        ArrayList<String> defaultValue = new ArrayList<String>();
        defaultValue.add((String)valueLabels.keySet().toArray()[0]);
        builder.setDefaultValues(defaultValue);
        builder.setControl((RemotableAbstractControl.Builder)controlBuilder);
        return builder.build();
    }

    public KrmsTypeRepositoryService getKrmsTypeRepositoryService() {
        return this.krmsTypeRepositoryService;
    }

    public void setKrmsTypeRepositoryService(KrmsTypeRepositoryService krmsTypeRepositoryService) {
        this.krmsTypeRepositoryService = krmsTypeRepositoryService;
    }
}

