/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.contacts.AwardUnitContact;

public class AwardCentralAdminContactsBean
implements Serializable {
    private static final long serialVersionUID = 7614119508539116964L;
    protected AwardForm awardForm;
    private List<AwardUnitContact> centralAdminContacts;
    private static final String DEFAULT_GROUP_CODE_FOR_CENTRAL_ADMIN_CONTACTS = "C";

    public AwardCentralAdminContactsBean(AwardForm awardForm) {
        this.awardForm = awardForm;
    }

    public void initCentralAdminContacts() {
        this.centralAdminContacts = new ArrayList<AwardUnitContact>();
        List<UnitAdministrator> unitAdministrators = this.getUnitService().retrieveUnitAdministratorsByUnitNumber(this.awardForm.getAwardDocument().getAward().getUnitNumber());
        for (UnitAdministrator unitAdministrator : unitAdministrators) {
            if (!unitAdministrator.getUnitAdministratorType().getDefaultGroupFlag().equals(DEFAULT_GROUP_CODE_FOR_CENTRAL_ADMIN_CONTACTS)) continue;
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(unitAdministrator.getPersonId());
            AwardUnitContact newAwardUnitContact = new AwardUnitContact();
            newAwardUnitContact.setAward(this.awardForm.getAwardDocument().getAward());
            newAwardUnitContact.setPerson(person);
            newAwardUnitContact.setUnitAdministratorType(unitAdministrator.getUnitAdministratorType());
            newAwardUnitContact.setFullName(person.getFullName());
            this.centralAdminContacts.add(newAwardUnitContact);
        }
    }

    public UnitService getUnitService() {
        return KcServiceLocator.getService(UnitService.class);
    }

    public KcPersonService getKcPersonService() {
        return KcServiceLocator.getService(KcPersonService.class);
    }

    public List<AwardUnitContact> getCentralAdminContacts() {
        return this.centralAdminContacts;
    }

    public int getCentralAdminContactsCount() {
        if (CollectionUtils.isEmpty(this.getCentralAdminContacts())) {
            return 0;
        }
        return this.getCentralAdminContacts().size();
    }
}

