/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.mo.ModelObjectUtils;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krms.api.repository.function.FunctionDefinition;
import org.kuali.rice.krms.api.repository.function.FunctionDefinitionContract;
import org.kuali.rice.krms.api.repository.function.FunctionRepositoryService;
import org.kuali.rice.krms.impl.repository.FunctionBo;
import org.kuali.rice.krms.impl.repository.FunctionBoService;
import org.kuali.rice.krms.impl.repository.FunctionParameterBo;

public class FunctionBoServiceImpl
implements FunctionRepositoryService,
FunctionBoService {
    private DataObjectService dataObjectService;
    private static final ModelObjectUtils.Transformer<FunctionBo, FunctionDefinition> toFunctionDefinition = new ModelObjectUtils.Transformer<FunctionBo, FunctionDefinition>(){

        public FunctionDefinition transform(FunctionBo input) {
            return FunctionBo.to(input);
        }
    };

    public FunctionDefinition getFunction(String functionId) {
        return this.getFunctionById(functionId);
    }

    public List<FunctionDefinition> getFunctions(List<String> functionIds) {
        if (functionIds == null) {
            throw new RiceIllegalArgumentException();
        }
        ArrayList<FunctionDefinition> functionDefinitions = new ArrayList<FunctionDefinition>();
        for (String functionId : functionIds) {
            FunctionDefinition functionDefinition;
            if (StringUtils.isBlank((String)functionId) || (functionDefinition = this.getFunctionById(functionId)) == null) continue;
            functionDefinitions.add(functionDefinition);
        }
        return Collections.unmodifiableList(functionDefinitions);
    }

    @Override
    public FunctionDefinition createFunction(FunctionDefinition function) {
        String namespaceKey;
        if (function == null) {
            throw new IllegalArgumentException("function is null");
        }
        String nameKey = function.getName();
        FunctionDefinition existing = this.getFunctionByNameAndNamespace(nameKey, namespaceKey = function.getNamespace());
        if (existing != null && existing.getName().equals(nameKey) && existing.getNamespace().equals(namespaceKey)) {
            throw new IllegalStateException("the function to create already exists: " + function);
        }
        FunctionBo functionBo = FunctionBo.from(function);
        for (FunctionParameterBo param : functionBo.getParameters()) {
            param.setFunction(functionBo);
        }
        functionBo = (FunctionBo)this.dataObjectService.save((Object)functionBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        return FunctionBo.to(functionBo);
    }

    @Override
    public FunctionDefinition updateFunction(FunctionDefinition function) {
        FunctionDefinition toUpdate;
        if (function == null) {
            throw new IllegalArgumentException("function is null");
        }
        String functionIdKey = function.getId();
        FunctionDefinition existing = this.getFunctionById(functionIdKey);
        if (existing == null) {
            throw new IllegalStateException("the function does not exist: " + function);
        }
        if (!existing.getId().equals(function.getId())) {
            FunctionDefinition.Builder builder = FunctionDefinition.Builder.create((FunctionDefinitionContract)function);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = function;
        }
        return FunctionBo.to((FunctionBo)this.dataObjectService.save((Object)FunctionBo.from(toUpdate), new PersistenceOption[]{PersistenceOption.FLUSH}));
    }

    @Override
    public FunctionDefinition getFunctionById(String functionId) {
        if (StringUtils.isBlank((String)functionId)) {
            throw new RiceIllegalArgumentException("functionId is null or blank");
        }
        FunctionBo functionBo = (FunctionBo)this.dataObjectService.find(FunctionBo.class, (Object)functionId);
        return FunctionBo.to(functionBo);
    }

    @Override
    public FunctionDefinition getFunctionByNameAndNamespace(String name, String namespace) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is null or blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("namespace", namespace);
        QueryByCriteria query = QueryByCriteria.Builder.andAttributes(map).build();
        QueryResults results = this.dataObjectService.findMatching(FunctionBo.class, query);
        if (results != null && results.getResults().size() != 0) {
            if (results.getResults().size() == 1) {
                return FunctionBo.to((FunctionBo)results.getResults().get(0));
            }
            if (results.getResults().size() > 1) {
                throw new IllegalStateException("there can be only one FunctionDefinition for a given name and namespace");
            }
        }
        return null;
    }

    public List<FunctionDefinition> getFunctionsByNamespace(String namespace) {
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is null or blank");
        }
        QueryByCriteria criteria = QueryByCriteria.Builder.forAttribute((String)"namespace", (Object)namespace).build();
        QueryResults queryResults = this.dataObjectService.findMatching(FunctionBo.class, criteria);
        List functionBos = queryResults.getResults();
        return this.convertFunctionBosToImmutables(functionBos);
    }

    private List<FunctionDefinition> convertFunctionBosToImmutables(Collection<FunctionBo> functionBos) {
        if (CollectionUtils.isEmpty(functionBos)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(ModelObjectUtils.transform(functionBos, toFunctionDefinition));
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

