/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml;

import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Element;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class CommonXmlParser {
    private static final Logger LOG = LogManager.getLogger(CommonXmlParser.class);

    public static RuleResponsibilityBo parseResponsibilityNameAndType(Element element) throws XmlException {
        RuleResponsibilityBo responsibility = new RuleResponsibilityBo();
        String principalId = element.getChildText("principalId", element.getNamespace());
        String principalName = element.getChildText("principalName", element.getNamespace());
        String groupId = element.getChildText("groupId", element.getNamespace());
        Element groupNameElement = element.getChild("groupName", element.getNamespace());
        String role = element.getChildText("role", element.getNamespace());
        Element roleNameElement = element.getChild("roleName", element.getNamespace());
        String user = element.getChildText("user", element.getNamespace());
        String workgroup = element.getChildText("workgroup", element.getNamespace());
        if (!StringUtils.isEmpty((String)user)) {
            principalName = user;
            LOG.warn("Rule XML is using deprecated element 'user', please use 'principalName' instead.");
        }
        if (!StringUtils.isBlank((String)principalId)) {
            principalId = Utilities.substituteConfigParameters(principalId);
            Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId);
            if (principal == null) {
                throw new XmlException("Could not locate principal with the given id: " + principalId);
            }
            responsibility.setRuleResponsibilityName(principalId);
            responsibility.setRuleResponsibilityType("F");
        } else if (!StringUtils.isBlank((String)principalName)) {
            principalName = Utilities.substituteConfigParameters(principalName);
            Principal principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(principalName);
            if (principal == null) {
                throw new XmlException("Could not locate principal with the given name: " + principalName);
            }
            responsibility.setRuleResponsibilityName(principal.getPrincipalId());
            responsibility.setRuleResponsibilityType("F");
        } else if (!StringUtils.isBlank((String)groupId)) {
            groupId = Utilities.substituteConfigParameters(groupId);
            Group group = KimApiServiceLocator.getGroupService().getGroup(groupId);
            if (group == null) {
                throw new XmlException("Could not locate group with the given id: " + groupId);
            }
            responsibility.setRuleResponsibilityName(groupId);
            responsibility.setRuleResponsibilityType("G");
        } else if (groupNameElement != null) {
            String groupName = groupNameElement.getText();
            String groupNamespace = groupNameElement.getAttributeValue("namespace");
            if (StringUtils.isBlank((String)groupName)) {
                throw new XmlException("Group name element has no value");
            }
            if (StringUtils.isBlank((String)groupNamespace)) {
                throw new XmlException("namespace attribute must be specified");
            }
            groupName = Utilities.substituteConfigParameters(groupName);
            groupNamespace = Utilities.substituteConfigParameters(groupNamespace);
            Group group = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(groupNamespace, groupName);
            if (group == null) {
                throw new XmlException("Could not locate group with the given namespace: " + groupNamespace + " and name: " + groupName);
            }
            responsibility.setRuleResponsibilityName(group.getId());
            responsibility.setRuleResponsibilityType("G");
        } else if (!StringUtils.isBlank((String)role)) {
            role = Utilities.substituteConfigParameters(role);
            responsibility.setRuleResponsibilityName(role);
            responsibility.setRuleResponsibilityType("R");
        } else if (roleNameElement != null) {
            String roleName = roleNameElement.getText();
            String attributeClassName = roleNameElement.getAttributeValue("attributeClassName");
            if (StringUtils.isBlank((String)roleName)) {
                throw new XmlException("Role name element has no value");
            }
            if (StringUtils.isBlank((String)attributeClassName)) {
                throw new XmlException("attributeClassName attribute must be specified");
            }
            roleName = Utilities.substituteConfigParameters(roleName);
            attributeClassName = Utilities.substituteConfigParameters(attributeClassName);
            responsibility.setRuleResponsibilityName(RoleName.constructRoleValue((String)attributeClassName, (String)roleName));
            responsibility.setRuleResponsibilityType("R");
        } else if (!StringUtils.isBlank((String)workgroup)) {
            LOG.warn("Rule XML is using deprecated element 'workgroup', please use 'groupName' instead.");
            workgroup = Utilities.substituteConfigParameters(workgroup);
            String workgroupNamespace = Utilities.parseGroupNamespaceCode(workgroup);
            String workgroupName = Utilities.parseGroupName(workgroup);
            Group workgroupObject = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(workgroupNamespace, workgroupName);
            if (workgroupObject == null) {
                throw new XmlException("Could not locate workgroup: " + workgroup);
            }
            responsibility.setRuleResponsibilityName(workgroupObject.getId());
            responsibility.setRuleResponsibilityType("G");
        } else {
            return null;
        }
        return responsibility;
    }
}

