/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.kim.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.org.OrganizationService;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.bo.IacucOrganizationCorrespondent;
import org.kuali.kra.iacuc.bo.IacucUnitCorrespondent;
import org.kuali.kra.iacuc.summary.IacucProtocolSummary;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationBase;
import org.kuali.kra.protocol.summary.OrganizationSummary;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class IacucCorrespondentDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase
implements RoleTypeService {
    private OrganizationService organizationService;
    private UnitService unitService;
    private final String ROLE_NAME_ORGANIZATION_CORRESPONDENT = "IACUC Organization Correspondent";
    private final String ROLE_NAME_UNIT_CORRESPONDENT = "IACUC Unit Correspondent";
    private final String PERFORMING_ORG_TYPE_CODE = "1";
    protected List<String> requiredAttributes = new ArrayList<String>();

    public IacucCorrespondentDerivedRoleTypeServiceImpl() {
        this.requiredAttributes.add("protocol");
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        if ("IACUC Organization Correspondent".equals(roleName)) {
            return this.hasApplicationRoleOrganization(principalId, groupIds, namespaceCode, roleName, qualification);
        }
        if ("IACUC Unit Correspondent".equals(roleName)) {
            return this.hasApplicationRoleUnit(principalId, groupIds, namespaceCode, roleName, qualification);
        }
        return false;
    }

    public boolean hasApplicationRoleOrganization(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        String protocolNumber = qualification.get("protocol");
        IacucProtocol protocol = this.getProtocolByNumber(protocolNumber);
        if (protocol != null) {
            for (ProtocolLocationBase location : protocol.getProtocolLocations()) {
                if (!StringUtils.equals((CharSequence)location.getProtocolOrganizationTypeCode(), (CharSequence)"1")) continue;
                List<IacucOrganizationCorrespondent> organizationCorrespondents = this.getOrganizationService().retrieveIacucOrganizationCorrespondentsByOrganizationId(location.getOrganizationId());
                for (IacucOrganizationCorrespondent organizationCorrespondent : organizationCorrespondents) {
                    if (!organizationCorrespondent.getPersonId().equals(principalId)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasApplicationRoleUnit(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        String protocolNumber = qualification.get("protocol");
        IacucProtocol protocol = this.getProtocolByNumber(protocolNumber);
        String unitNumber = protocol.getLeadUnitNumber();
        if (StringUtils.isNotBlank((CharSequence)unitNumber)) {
            List<IacucUnitCorrespondent> unitCorrespondents = this.getUnitService().retrieveIacucUnitCorrespondentsByUnitNumber(unitNumber);
            for (IacucUnitCorrespondent unitCorrespondent : unitCorrespondents) {
                if (!unitCorrespondent.getPersonId().equals(principalId)) continue;
                return true;
            }
        }
        return false;
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        String protocolNumber = qualification.get("protocol");
        if (protocolNumber != null) {
            IacucProtocol protocol = this.getProtocolByNumber(protocolNumber);
            if ("IACUC Organization Correspondent".equals(roleName)) {
                return this.getRoleMembersFromApplicationRoleOrganization(protocol, namespaceCode, roleName, qualification);
            }
            if ("IACUC Unit Correspondent".equals(roleName)) {
                return this.getRoleMembersFromApplicationRoleUnit(protocol, namespaceCode, roleName, qualification);
            }
        }
        return new ArrayList<RoleMembership>();
    }

    public List<RoleMembership> getRoleMembersFromApplicationRoleOrganization(IacucProtocol protocol, String namespaceCode, String roleName, Map<String, String> qualification) {
        IacucProtocolSummary protocolSummary = (IacucProtocolSummary)protocol.getProtocolSummary();
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        for (OrganizationSummary orgSummary : protocolSummary.getOrganizations()) {
            String organizationId = orgSummary.getId();
            if (!StringUtils.isNotBlank((CharSequence)organizationId)) continue;
            List<IacucOrganizationCorrespondent> organizationCorrespondents = this.getOrganizationService().retrieveIacucOrganizationCorrespondentsByOrganizationId(organizationId);
            for (IacucOrganizationCorrespondent organizationCorrespondent : organizationCorrespondents) {
                if (!StringUtils.isNotBlank((CharSequence)organizationCorrespondent.getPersonId())) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)organizationCorrespondent.getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    public List<RoleMembership> getRoleMembersFromApplicationRoleUnit(IacucProtocol protocol, String namespaceCode, String roleName, Map<String, String> qualification) {
        String unitNumber = protocol.getLeadUnitNumber();
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        if (StringUtils.isNotBlank((CharSequence)unitNumber)) {
            List<IacucUnitCorrespondent> unitCorrespondents = this.getUnitService().retrieveIacucUnitCorrespondentsByUnitNumber(unitNumber);
            for (IacucUnitCorrespondent unitCorrespondent : unitCorrespondents) {
                if (!StringUtils.isNotBlank((CharSequence)unitCorrespondent.getPersonId())) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)unitCorrespondent.getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    private UnitService getUnitService() {
        if (this.unitService == null) {
            this.unitService = KcServiceLocator.getService(UnitService.class);
        }
        return this.unitService;
    }

    private OrganizationService getOrganizationService() {
        if (this.organizationService == null) {
            this.organizationService = KcServiceLocator.getService(OrganizationService.class);
        }
        return this.organizationService;
    }

    private IacucProtocol getProtocolByNumber(String protocolNumber) {
        HashMap<String, String> keymap = new HashMap<String, String>();
        keymap.put("protocolNumber", protocolNumber);
        keymap.put("active", "Y");
        Iterator iterator = this.getBusinessObjectService().findMatching(IacucProtocol.class, keymap).iterator();
        if (iterator.hasNext()) {
            IacucProtocol protocol = (IacucProtocol)iterator.next();
            return protocol;
        }
        return null;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

