/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.funding;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.bo.FundingSourceType;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditError;

public abstract class ProtocolFundingSourceAuditRuleBase
extends KcTransactionalDocumentRuleBase
implements DocumentAuditRule {
    private static final String FUNDING_SOURCE_AUDIT_ERRORS = "requiredFieldsAuditErrors";
    private static final String FUNDING_SOURCE_AUDIT_LINK = "protocol.Funding Source";

    public boolean processRunAuditBusinessRules(Document document) {
        boolean isValid = true;
        ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)document;
        return isValid;
    }

    private boolean processRequiredProtocolFundingSources(ProtocolBase protocol) {
        boolean isValid = true;
        Collection fundingSourceTypes = this.getBusinessObjectService().findAll(FundingSourceType.class);
        for (FundingSourceType fundingSourceType : fundingSourceTypes) {
            if (!fundingSourceType.getFundingSourceTypeFlag() || this.getProtocolContainsFundingSource(protocol, fundingSourceType.getFundingSourceTypeCode())) continue;
            AuditError auditError = new AuditError("document.title", "error.protocol.fundingSource.required", FUNDING_SOURCE_AUDIT_LINK, new String[]{fundingSourceType.getDescription()});
            this.addAuditError(auditError, FUNDING_SOURCE_AUDIT_ERRORS, "Protocol", "Error");
            isValid = false;
        }
        return isValid;
    }

    private boolean getProtocolContainsFundingSource(ProtocolBase protocol, String fundingSourceTypeCode) {
        boolean contains = false;
        for (ProtocolFundingSourceBase protocolFundingSource : protocol.getProtocolFundingSources()) {
            if (!StringUtils.equals((CharSequence)fundingSourceTypeCode, (CharSequence)protocolFundingSource.getFundingSourceTypeCode())) continue;
            contains = true;
            break;
        }
        return contains;
    }
}

