/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFText;

public class PDFUri
extends PDFAction {
    private String uri;

    public PDFUri(String uri) {
        this.uri = uri;
    }

    @Override
    public String getAction() {
        if (this.hasObjectNumber()) {
            return this.referencePDF();
        }
        return this.getDictString();
    }

    private String getDictString() {
        return "<< /URI " + this.encodeURI(this.uri) + "\n/S /URI >>";
    }

    @Override
    public String toPDFString() {
        return this.getDictString();
    }

    private String encodeURI(String text) {
        if (this.getDocument() != null && this.getDocumentSafely().isEncryptionActive()) {
            byte[] buf = PDFText.encode(text);
            byte[] enc = this.getDocument().getEncryption().encrypt(buf, this);
            return PDFText.toHex(enc, true);
        }
        return "(" + text + ")";
    }
}

