/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.mail.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.mail.EmailBody;
import org.kuali.rice.core.api.mail.EmailContent;
import org.kuali.rice.core.api.mail.EmailSubject;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionItemContract;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.mail.service.EmailContentService;
import org.kuali.rice.kew.mail.service.impl.ActionListEmailServiceImpl;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class CustomizableActionListEmailServiceImpl
extends ActionListEmailServiceImpl {
    private static final Logger LOG = LogManager.getLogger(CustomizableActionListEmailServiceImpl.class);
    private EmailContentService contentService;

    public void setEmailContentGenerator(EmailContentService contentService) {
        this.contentService = contentService;
    }

    protected EmailContentService getEmailContentGenerator() {
        return this.contentService;
    }

    @Override
    public void sendImmediateReminder(org.kuali.rice.kew.api.action.ActionItem actionItem, Boolean skipOnApprovals) {
        if (actionItem == null) {
            LOG.warn("Request to send immediate reminder to recipient of a null action item... aborting.");
            return;
        }
        if (actionItem.getPrincipalId() == null) {
            LOG.warn("Request to send immediate reminder to null recipient of an action item... aborting.");
            return;
        }
        if (skipOnApprovals != null && skipOnApprovals.booleanValue() && actionItem.getActionRequestCd().equals("A")) {
            LOG.debug("As requested, skipping immediate reminder notification on action item approval for " + actionItem.getPrincipalId());
            return;
        }
        Preferences preferences = KewApiServiceLocator.getPreferencesService().getPreferences(actionItem.getPrincipalId());
        if (!this.checkEmailNotificationPreferences((ActionItemContract)actionItem, preferences, "immediate")) {
            LOG.debug("Email suppressed due to the user's preferences");
            return;
        }
        if (!this.sendActionListEmailNotification()) {
            LOG.debug("not sending immediate reminder");
            return;
        }
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(actionItem.getDocumentId());
        Person person = KimApiServiceLocator.getPersonService().getPerson(actionItem.getPrincipalId());
        if (person != null) {
            EmailContent content = this.getEmailContentGenerator().generateImmediateReminder(person, actionItem, document.getDocumentType());
            this.sendEmail(person, new EmailSubject(content.getSubject()), new EmailBody(content.getBody()), document.getDocumentType(), content.isHtml());
        }
    }

    @Override
    protected void sendPeriodicReminder(String principalId, Collection<ActionItem> actionItems, String emailSetting) {
        EmailContent content;
        actionItems = this.filterActionItemsToNotify(principalId, actionItems, emailSetting);
        ArrayList<org.kuali.rice.kew.api.action.ActionItem> apiActionItems = new ArrayList<org.kuali.rice.kew.api.action.ActionItem>();
        for (ActionItem actionItem : actionItems) {
            apiActionItems.add(ActionItem.to(actionItem));
        }
        if (actionItems.isEmpty()) {
            return;
        }
        Person person = KimApiServiceLocator.getPersonService().getPerson(principalId);
        if ("daily".equals(emailSetting)) {
            content = this.getEmailContentGenerator().generateDailyReminder(person, apiActionItems);
        } else if ("weekly".equals(emailSetting)) {
            content = this.getEmailContentGenerator().generateWeeklyReminder(person, apiActionItems);
        } else {
            throw new RuntimeException("invalid email setting. this code needs refactoring");
        }
        this.sendEmail(person, new EmailSubject(content.getSubject()), new EmailBody(content.getBody()));
    }
}

