/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.impl.modular.ModularBudgetCommunicationException;
import org.kuali.coeus.common.framework.compliance.core.SaveSpecialReviewLinkEvent;
import org.kuali.coeus.common.framework.compliance.core.SpecialReviewService;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRulesEngine;
import org.kuali.coeus.common.notification.impl.bo.NotificationTypeRecipient;
import org.kuali.coeus.propdev.impl.action.ProposalDevelopmentActionBean;
import org.kuali.coeus.propdev.impl.action.ProposalDevelopmentRejectionRule;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.core.SubmitToSponsorEvent;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyService;
import org.kuali.coeus.propdev.impl.notification.NotificationControllerService;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotification;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationContext;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationRenderer;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.kuali.coeus.propdev.impl.s2s.override.S2sOverride;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.propdev.impl.state.ProposalStateService;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentRequestAuthorizationCache;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.RequestAuthorizationCache;
import org.kuali.rice.krad.web.form.DialogResponse;
import org.kuali.rice.krad.web.form.DocumentFormBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.CollectionControllerService;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentSubmitController
extends ProposalDevelopmentControllerBase {
    public static final String RETURN_ACTION_TYPE_CODE = "500";
    public static final String RETURN_NOTIFICATION = "Return Notification";
    public static final String ANOTHER_USER_APPROVED_ACTION_TYPE_CODE = "501";
    public static final String ANOTHER_USER_APPROVED_NOTIFICATION = "Another User Approved Notification";
    public static final String PROPOSAL_NUMBER = "proposalNumber";
    public static final String PROPOSAL_STATE = "proposalState";
    private static final String ENABLE_PD_WORKFLOW_APPROVAL_COMMENTS = "ENABLE_PD_WORKFLOW_APPROVAL_COMMENTS";
    private static final String APPROVE_CHECK = "approveCheck";
    private static final String APPROVE = "approve";
    private static final String DATAVALIDATION = "datavalidation";
    private static final String PROP_DEV_SUBMIT_PAGE_S2S_OVERRIDE_EXISTS = "PropDev-SubmitPage-S2sOverride-Exists";
    private static final String PROP_DEV_OPPORTUNITY_PAGE = "PropDev-OpportunityPage";
    private static final String PROP_DEV_RESUMBIT_OPTIONS_SECTION = "PropDev-Resumbit-OptionsSection";
    private final Logger LOGGER = LogManager.getLogger(ProposalDevelopmentSubmitController.class);
    private static final String AUTO_SUBMIT_TO_SPONSOR_ON_FINAL_APPROVAL = "autoSubmitToSponsorOnFinalApproval";
    private static final String SUBMIT_TO_SPONSOR = "submitToSponsor";
    private static final String PROPOSAL_APPROVAL_ATTACHMENT = "Proposal approval attachment.";
    @Autowired
    @Qualifier(value="collectionControllerService")
    private CollectionControllerService collectionControllerService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="institutionalProposalService")
    private InstitutionalProposalService institutionalProposalService;
    @Autowired
    @Qualifier(value="kradWorkflowDocumentService")
    private WorkflowDocumentService kradWorkflowDocumentService;
    @Autowired
    @Qualifier(value="workflowDocumentActionsService")
    protected WorkflowDocumentActionsService workflowDocumentActionsService;
    @Autowired
    @Qualifier(value="documentDictionaryService")
    private DocumentDictionaryService documentDictionaryService;
    @Autowired
    @Qualifier(value="groupService")
    private GroupService groupService;
    @Autowired
    @Qualifier(value="kcBusinessRulesEngine")
    private KcBusinessRulesEngine kcBusinessRulesEngine;
    @Autowired
    @Qualifier(value="proposalStateService")
    private ProposalStateService proposalStateService;
    @Autowired
    @Qualifier(value="specialReviewService")
    private SpecialReviewService specialReviewService;
    @Autowired
    @Qualifier(value="proposalHierarchyService")
    private ProposalHierarchyService proposalHierarchyService;
    @Autowired
    @Qualifier(value="kcWorkflowService")
    private KcWorkflowService kcWorkflowService;
    @Autowired
    @Qualifier(value="actionRequestService")
    private ActionRequestService actionRequestService;
    @Autowired
    @Qualifier(value="notificationControllerService")
    private NotificationControllerService notificationControllerService;
    @Autowired
    @Qualifier(value="enActionListService")
    private ActionListService actionListService;

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=populateAdHocs"})
    public ModelAndView populateAdHocs(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        this.populateAdHocRecipients(form.getProposalDevelopmentDocument());
        return this.getModelAndViewService().showDialog("PropDev-DocumentAdHocRecipientsSection", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveAdHocChanges"})
    public ModelAndView saveAdHocChanges(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=deleteProposal"})
    public ModelAndView deleteProposal(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        if (form.getProposalDevelopmentDocument().getDevelopmentProposal().isInHierarchy()) {
            this.getGlobalVariableService().getMessageMap().putError("GLOBAL_ERRORS", "error.proposalDevelopment.deleteproposal.inhierarchy", new String[0]);
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        this.getProposalDevelopmentService().deleteProposal(form.getProposalDevelopmentDocument());
        return this.getKcCommonControllerService().returnHome((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=submitForReview"})
    public ModelAndView submitForReview(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        this.populateAdHocRecipients(form.getProposalDevelopmentDocument());
        AuditHelper.ValidationState severityLevel = this.getValidationState(form);
        if (severityLevel.equals((Object)AuditHelper.ValidationState.ERROR)) {
            return this.getModelAndViewService().showDialog("DataValidationSection", true, (UifFormBase)form);
        }
        if (severityLevel.equals((Object)AuditHelper.ValidationState.WARNING)) {
            return this.getModelAndViewService().showDialog("DataValidationSection-WithSubmit", true, (UifFormBase)form);
        }
        return this.internalSubmit(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=internalSubmit"})
    public ModelAndView internalSubmit(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        WorkflowDocument workflowDoc = form.getProposalDevelopmentDocument().getDocumentHeader().getWorkflowDocument();
        if (this.canGenerateRequestsInFuture(workflowDoc, this.getGlobalVariableService().getUserSession().getPrincipalId())) {
            DialogResponse dialogResponse = form.getDialogResponse("PropDev-SubmitPage-ReceiveFutureRequests");
            if (dialogResponse == null) {
                return this.getModelAndViewService().showDialog("PropDev-SubmitPage-ReceiveFutureRequests", false, (UifFormBase)form);
            }
            if (dialogResponse.getResponseAsBoolean()) {
                form.getWorkflowDocument().setReceiveFutureRequests();
            } else {
                form.getWorkflowDocument().setDoNotReceiveFutureRequests();
            }
        }
        form.setCanEditView(null);
        form.setEvaluateFlagsAndModes(true);
        DocumentRequestAuthorizationCache cache = new DocumentRequestAuthorizationCache();
        cache.createWorkflowDocumentInfo(workflowDoc);
        form.getView().getAuthorizer().setRequestAuthorizationCache((RequestAuthorizationCache)cache);
        form.getView().getPresentationController().setRequestAuthorizationCache((RequestAuthorizationCache)cache);
        if ("12".equals(form.getDevelopmentProposal().getProposalStateTypeCode())) {
            if (workflowDoc.isApprovalRequested()) {
                workflowDoc.approve("Revisions Requested Re-Submit");
            } else {
                form.getProposalDevelopmentDocument().getActionRequests().stream().filter(actionRequest -> "Aggregators Request for Review".equals(actionRequest.getAnnotation()) || "Submitter Request for Review".equals(actionRequest.getAnnotation())).map(actionRequest -> this.getActionRequestService().findByActionRequestId(actionRequest.getId())).forEach(actionRequest -> this.getActionRequestService().deactivateRequest(null, actionRequest));
                this.getTransactionalDocumentControllerService().route((DocumentFormBase)form);
            }
        } else {
            this.getTransactionalDocumentControllerService().route((DocumentFormBase)form);
        }
        DevelopmentProposal developmentProposal = form.getProposalDevelopmentDocument().getDevelopmentProposal();
        if (developmentProposal.isInHierarchy() && developmentProposal.isParent()) {
            this.getProposalHierarchyService().getHierarchyChildren(developmentProposal.getProposalNumber()).stream().forEach(child -> {
                ProposalDevelopmentDocument document = child.getProposalDocument();
                this.getActionListService().findByDocumentId(document.getDocumentNumber()).stream().forEach(actionItem -> {
                    ActionRequestValue actionRequest = this.getActionRequestService().findByActionRequestId(actionItem.getActionRequestId());
                    this.getActionRequestService().deactivateRequest(null, actionRequest);
                    this.getDataObjectService().delete(actionItem);
                });
            });
        }
        this.getProposalLockService().releaseWorkflowPessimisticLocking((Document)form.getProposalDevelopmentDocument());
        this.updateProposalAdminDetailsForSubmit(form.getDevelopmentProposal());
        return this.updateProposalState(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=cancelProposal"})
    public ModelAndView cancelProposal(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        form.setCanEditView(null);
        form.setEvaluateFlagsAndModes(true);
        form.getDevelopmentProposal().setProposalStateTypeCode("10");
        return this.getTransactionalDocumentControllerService().cancel((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=navigate", "actionParameters[navigateToPageId]=PropDev-SubmitPage"})
    public ModelAndView navigateToSubmit(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        Boolean shouldPopulateQuestionnaire = !StringUtils.equals((CharSequence)form.getPageId(), (CharSequence)"PropDev-QuestionnairePage");
        ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).prepareSummaryPage(form, shouldPopulateQuestionnaire);
        return super.navigate(form, result, request, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=blanketApprove"})
    public ModelAndView blanketApprove(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        if (!this.getValidationState(form).equals((Object)AuditHelper.ValidationState.ERROR)) {
            form.setCanEditView(null);
            form.setEvaluateFlagsAndModes(true);
            this.updateProposalAdminDetailsForBlanketApprove(form.getDevelopmentProposal());
            return this.getTransactionalDocumentControllerService().blanketApprove((DocumentFormBase)form);
        }
        return this.getModelAndViewService().showDialog("DataValidationSection", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=recall"})
    public ModelAndView recall(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        String successMessageKey = null;
        Document document = form.getDocument();
        if (this.getDocumentService().documentExists(document.getDocumentNumber())) {
            String recallExplanation = (String)form.getDialogExplanations().get("ConfirmRecallDialog");
            this.getDocumentService().recallDocument(document, recallExplanation, false);
            successMessageKey = "message.route.recalled";
            ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
            proposalDevelopmentDocument.getDevelopmentProposal().setProposalStateTypeCode("12");
            DevelopmentProposal developmentProposal = (DevelopmentProposal)this.getDataObjectService().save((Object)proposalDevelopmentDocument.getDevelopmentProposal(), new PersistenceOption[0]);
            developmentProposal.refreshReferenceObject(PROPOSAL_STATE);
        }
        if (successMessageKey != null) {
            this.getGlobalVariableService().getMessageMap().putInfo("GlobalMessages", successMessageKey, new String[0]);
        }
        return this.getTransactionalDocumentControllerService().reload((DocumentFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=disapproveProposal"})
    public ModelAndView disapproveProposal(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        String applicationUrl = this.getConfigurationService().getPropertyValueAsString("application.url");
        form.setReturnLocation(applicationUrl);
        form.setCanEditView(null);
        form.setEvaluateFlagsAndModes(true);
        return this.getTransactionalDocumentControllerService().disapprove((DocumentFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=prepareNotificationWizard"})
    public ModelAndView prepareNotificationWizard(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        return this.getNotificationControllerService().prepareNotificationWizard(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addRecipients"})
    public ModelAndView addRecipients(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        return this.getNotificationControllerService().addRecipients(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=performRecipientSearch"})
    public ModelAndView performRecipientSearch(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        return this.getNotificationControllerService().performRecipientSearch(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=sendNotifications"})
    public ModelAndView sendNotifications(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        ProposalDevelopmentNotificationContext context = new ProposalDevelopmentNotificationContext(form.getDevelopmentProposal(), "999", "Ad-Hoc Notification");
        return this.getNotificationControllerService().sendNotifications(form, context);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=cancelNotifications"})
    public ModelAndView cancelNotifications(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        return this.getNotificationControllerService().cancelNotifications(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=submitToS2s"})
    public ModelAndView submitToS2s(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        form.setGrantsGovSubmitFlag(true);
        form.setShowSubmissionDetails(true);
        form.setDirtyForm(false);
        form.setEvaluateFlagsAndModes(true);
        DocumentRequestAuthorizationCache cache = new DocumentRequestAuthorizationCache();
        cache.createWorkflowDocumentInfo(form.getProposalDevelopmentDocument().getDocumentHeader().getWorkflowDocument());
        form.getView().getAuthorizer().setRequestAuthorizationCache((RequestAuthorizationCache)cache);
        form.getView().getPresentationController().setRequestAuthorizationCache((RequestAuthorizationCache)cache);
        if (!this.requiresResubmissionPrompt(form)) {
            if (this.validToSubmitToSponsor(form)) {
                S2sOverride s2sOverride;
                if (this.autogenerateInstitutionalProposal() && !this.hasInstitutionalProposal(form.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalNumber())) {
                    this.submitApplication(form);
                }
                if ((s2sOverride = form.getDevelopmentProposal().getS2sOverride()) != null && s2sOverride.isActive() && this.isOverrideDataPresent(s2sOverride)) {
                    DialogResponse dialogResponse = form.getDialogResponse(PROP_DEV_SUBMIT_PAGE_S2S_OVERRIDE_EXISTS);
                    if (dialogResponse == null) {
                        return this.getModelAndViewService().showDialog(PROP_DEV_SUBMIT_PAGE_S2S_OVERRIDE_EXISTS, false, (UifFormBase)form);
                    }
                    if (dialogResponse.getResponseAsBoolean()) {
                        this.handleSubmissionToS2S(form);
                        return this.getModelAndViewService().getModelAndView((UifFormBase)form, PROP_DEV_OPPORTUNITY_PAGE);
                    }
                    return this.getModelAndViewService().getModelAndView((UifFormBase)form);
                }
                this.handleSubmissionToS2S(form);
                return this.getModelAndViewService().getModelAndView((UifFormBase)form, PROP_DEV_OPPORTUNITY_PAGE);
            }
            form.setDataValidationItems(((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).populateDataValidation());
            return this.getModelAndViewService().showDialog("DataValidationSection", true, (UifFormBase)form);
        }
        return this.getModelAndViewService().showDialog(PROP_DEV_RESUMBIT_OPTIONS_SECTION, true, (UifFormBase)form);
    }

    private boolean isOverrideDataPresent(S2sOverride s2sOverride) {
        return s2sOverride.getApplicationOverride() != null && s2sOverride.getApplicationOverride().getApplication() != null || StringUtils.isNotBlank((CharSequence)s2sOverride.getSignedBy()) || s2sOverride.getSubmittedDate() != null;
    }

    protected void handleSubmissionToS2S(ProposalDevelopmentDocumentForm form) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        try {
            boolean submitted = this.submitS2sApplication(proposalDevelopmentDocument);
            if (!submitted) {
                this.getGlobalVariableService().getMessageMap().putError("noField", "error.on.grantsGov.submission", new String[]{"Submission Failed. Please correct any validation errors and try again."});
            }
        }
        catch (S2SException e) {
            this.LOGGER.error("Error submitting to s2s", (Throwable)e);
            this.getGlobalVariableService().getMessageMap().putError("noField", "error.on.grantsGov.submission", new String[]{StringUtils.isNotBlank((CharSequence)e.getErrorMessage()) ? e.getErrorMessage() : e.getMessage()});
        }
        catch (S2sCommunicationException e) {
            this.LOGGER.error("Error submitting to s2s", (Throwable)e);
            this.getGlobalVariableService().getMessageMap().putError("noField", e.getErrorKey(), e.getMessageWithParams());
        }
        catch (ModularBudgetCommunicationException e) {
            this.LOGGER.error("Error communicating with standalone Budget service", (Throwable)e);
            this.getGlobalVariableService().getMessageMap().putError("noField", "error.standalone.budget.communication.error", new String[0]);
        }
    }

    protected boolean hasInstitutionalProposal(String proposalNumber) {
        return this.getProposalDevelopmentService().getInstitutionalProposal(proposalNumber) != null;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=submitToSponsor"})
    public ModelAndView submitToSponsor(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        form.setEvaluateFlagsAndModes(true);
        DocumentRequestAuthorizationCache cache = new DocumentRequestAuthorizationCache();
        cache.createWorkflowDocumentInfo(form.getProposalDevelopmentDocument().getDocumentHeader().getWorkflowDocument());
        form.getView().getAuthorizer().setRequestAuthorizationCache((RequestAuthorizationCache)cache);
        form.getView().getPresentationController().setRequestAuthorizationCache((RequestAuthorizationCache)cache);
        if (!this.requiresResubmissionPrompt(form)) {
            if (this.validToSubmitToSponsor(form)) {
                this.submitApplication(form);
                this.handleNotification(form, "101", "Proposal Submitted");
                form.setDeferredMessages(this.getGlobalVariableService().getMessageMap());
                return this.sendSubmitToSponsorNotification(form);
            }
            form.setDataValidationItems(((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).populateDataValidation());
            return this.getModelAndViewService().showDialog("DataValidationSection", true, (UifFormBase)form);
        }
        return this.getModelAndViewService().showDialog(PROP_DEV_RESUMBIT_OPTIONS_SECTION, true, (UifFormBase)form);
    }

    protected ModelAndView sendSubmitToSponsorNotification(ProposalDevelopmentDocumentForm proposalDevelopmentDocumentForm) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentDocumentForm.getProposalDevelopmentDocument();
        ProposalDevelopmentNotificationContext context = new ProposalDevelopmentNotificationContext(proposalDevelopmentDocument.getDevelopmentProposal(), "101", "Proposal Submitted");
        context.getRenderer().setDevelopmentProposal(proposalDevelopmentDocumentForm.getDevelopmentProposal());
        if (proposalDevelopmentDocumentForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            proposalDevelopmentDocumentForm.getNotificationHelper().initializeDefaultValues(context);
            return this.getModelAndViewService().showDialog("Kc-SendNotification-Wizard", true, (UifFormBase)proposalDevelopmentDocumentForm);
        }
        this.getKcNotificationService().sendNotificationAndPersist(context, new ProposalDevelopmentNotification(), proposalDevelopmentDocument.getDevelopmentProposal());
        return this.getModelAndViewService().getModelAndView((UifFormBase)proposalDevelopmentDocumentForm);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=deleteLineNotificationRecipient"})
    public ModelAndView deleteLine(@ModelAttribute(value="KualiForm") DocumentFormBase form, @RequestParam(value="actionParameters[selectedCollectionPath]") String selectedCollectionPath) {
        this.getCollectionControllerService().deleteLine((UifFormBase)form);
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)form, (String)selectedCollectionPath);
        form.getActionParameters().put("Kc-SendNotification-Wizard.step", collection.isEmpty() ? "0" : "2");
        return this.getModelAndViewService().showDialog("Kc-SendNotification-Wizard", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=proceed"})
    public ModelAndView proceed(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        return form.isGrantsGovSubmitFlag() ? this.submitToS2s(form) : this.submitToSponsor(form);
    }

    protected boolean validToSubmitToSponsor(ProposalDevelopmentDocumentForm form) {
        boolean isValid = !this.getValidationState(form).equals((Object)AuditHelper.ValidationState.ERROR);
        return isValid &= this.getKcBusinessRulesEngine().applyRules(new SubmitToSponsorEvent(form.getProposalDevelopmentDocument())).booleanValue();
    }

    public void submitApplication(ProposalDevelopmentDocumentForm proposalDevelopmentForm) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        boolean isIPProtocolLinkingEnabled = this.getParameterService().getParameterValueAsBoolean("KC-PROTOCOL", "Document", "irb.protocol.institute.proposal.linking.enabled");
        List<ProposalSpecialReview> specialReviews = proposalDevelopmentDocument.getDevelopmentProposal().getPropSpecialReviews();
        Boolean validSpecialReviewSave = this.getKcBusinessRulesEngine().applyRules(new SaveSpecialReviewLinkEvent<ProposalSpecialReview>((Document)proposalDevelopmentDocument, specialReviews));
        if (!isIPProtocolLinkingEnabled || validSpecialReviewSave.booleanValue()) {
            boolean generateIp;
            boolean bl = generateIp = !this.autogenerateInstitutionalProposal() || !"X".equals(proposalDevelopmentForm.getResubmissionOption());
            if (generateIp) {
                proposalDevelopmentDocument.getDevelopmentProposal().setSubmitFlag(true);
            }
            this.setProposalStateType(generateIp, proposalDevelopmentDocument);
            String pCode = proposalDevelopmentDocument.getDevelopmentProposal().getProposalStateTypeCode();
            proposalDevelopmentForm.setCanEditView(null);
            proposalDevelopmentForm.setEvaluateFlagsAndModes(true);
            this.getTransactionalDocumentControllerService().save((DocumentFormBase)proposalDevelopmentForm);
            if (!StringUtils.equals((CharSequence)pCode, (CharSequence)proposalDevelopmentDocument.getDevelopmentProposal().getProposalStateTypeCode())) {
                proposalDevelopmentDocument.getDevelopmentProposal().setProposalStateTypeCode(pCode);
                proposalDevelopmentDocument.getDevelopmentProposal().refresh();
                this.getDataObjectService().save((Object)proposalDevelopmentDocument.getDevelopmentProposal(), new PersistenceOption[0]);
            }
            this.updateProposalAdminDetailsForSubmitToSponsor(proposalDevelopmentDocument.getDevelopmentProposal());
            if (this.autogenerateInstitutionalProposal()) {
                this.generateInstitutionalProposal(proposalDevelopmentForm, isIPProtocolLinkingEnabled);
            }
        }
    }

    protected void setProposalStateType(boolean generateIp, ProposalDevelopmentDocument proposalDevelopmentDocument) {
        if (generateIp) {
            if ("13".equals(proposalDevelopmentDocument.getDevelopmentProposal().getProposalStateTypeCode())) {
                proposalDevelopmentDocument.getDevelopmentProposal().setProposalStateTypeCode("6");
            } else {
                proposalDevelopmentDocument.getDevelopmentProposal().setProposalStateTypeCode(this.proposalStateService.getProposalStateTypeCode(proposalDevelopmentDocument, false));
            }
        } else if (proposalDevelopmentDocument.getDocumentHeader().getWorkflowDocument().isFinal()) {
            proposalDevelopmentDocument.getDevelopmentProposal().setProposalStateTypeCode("13");
        } else {
            proposalDevelopmentDocument.getDevelopmentProposal().setProposalStateTypeCode("2");
        }
    }

    private void generateInstitutionalProposal(ProposalDevelopmentDocumentForm proposalDevelopmentForm, boolean isIPProtocolLinkingEnabled) {
        if ("X".equals(proposalDevelopmentForm.getResubmissionOption())) {
            this.doNotGenerateIp(proposalDevelopmentForm);
        } else if ("O".equals(proposalDevelopmentForm.getResubmissionOption())) {
            this.generateNewVersionOfOrigIp(proposalDevelopmentForm, isIPProtocolLinkingEnabled);
        } else if ("A".equals(proposalDevelopmentForm.getResubmissionOption())) {
            this.generateNewVersionIp(proposalDevelopmentForm, isIPProtocolLinkingEnabled);
        } else if (null == proposalDevelopmentForm.getResubmissionOption() || "N".equals(proposalDevelopmentForm.getResubmissionOption())) {
            this.generateNewIp(proposalDevelopmentForm, isIPProtocolLinkingEnabled);
        } else {
            this.LOGGER.warn("Invalid resubmission option " + proposalDevelopmentForm.getResubmissionOption());
        }
    }

    protected void doNotGenerateIp(ProposalDevelopmentDocumentForm proposalDevelopmentForm) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        if (proposalDevelopmentDocument.getDocumentHeader().getWorkflowDocument().isFinal()) {
            this.getGlobalVariableService().getMessageMap().putInfo("noField", "message.institutionalproposal.not.created", new String[0]);
        } else {
            this.getGlobalVariableService().getMessageMap().putInfo("noField", "message.institutionalproposal.not.created.inroute", new String[0]);
        }
    }

    protected void generateNewVersionOfOrigIp(ProposalDevelopmentDocumentForm proposalDevelopmentForm, boolean isIPProtocolLinkingEnabled) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        proposalDevelopmentForm.setInstitutionalProposalToVersion(proposalDevelopmentDocument.getDevelopmentProposal().getContinuedFrom());
        this.generateNewVersionIp(proposalDevelopmentForm, isIPProtocolLinkingEnabled);
    }

    protected void generateNewVersionIp(ProposalDevelopmentDocumentForm proposalDevelopmentForm, boolean isIPProtocolLinkingEnabled) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        String versionNumber = this.createInstitutionalProposalVersion(proposalDevelopmentForm.getInstitutionalProposalToVersion(), proposalDevelopmentDocument.getDevelopmentProposal(), proposalDevelopmentDocument.getDevelopmentProposal().getFinalBudget());
        this.getGlobalVariableService().getMessageMap().putInfo("noField", "message.institutionalproposal.versioned", new String[]{versionNumber, proposalDevelopmentForm.getInstitutionalProposalToVersion()});
        Long institutionalProposalId = this.getActiveProposalId(proposalDevelopmentForm.getInstitutionalProposalToVersion());
        this.updateProposalAdminDetailsAfterInstPropCreation(proposalDevelopmentDocument.getDevelopmentProposal(), institutionalProposalId);
        this.persistSpecialReviewProtocolFundingSourceLink(institutionalProposalId, isIPProtocolLinkingEnabled);
    }

    protected void generateNewIp(ProposalDevelopmentDocumentForm proposalDevelopmentForm, boolean isIPProtocolLinkingEnabled) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        String proposalNumber = this.createInstitutionalProposal(proposalDevelopmentDocument.getDevelopmentProposal(), proposalDevelopmentDocument.getDevelopmentProposal().getFinalBudget());
        this.getGlobalVariableService().getMessageMap().putInfo("noField", "message.institutionalproposal.created", new String[]{proposalNumber});
        Long institutionalProposalId = this.getActiveProposalId(proposalNumber);
        this.updateProposalAdminDetailsAfterInstPropCreation(proposalDevelopmentDocument.getDevelopmentProposal(), institutionalProposalId);
        this.persistSpecialReviewProtocolFundingSourceLink(institutionalProposalId, isIPProtocolLinkingEnabled);
    }

    protected void persistSpecialReviewProtocolFundingSourceLink(Long institutionalProposalId, boolean isIPProtocolLinkingEnabled) {
        if (isIPProtocolLinkingEnabled) {
            InstitutionalProposal institutionalProposal = (InstitutionalProposal)this.getLegacyDataAdapter().findBySinglePrimaryKey(InstitutionalProposal.class, (Object)institutionalProposalId);
            institutionalProposal.getSpecialReviews().stream().filter(specialReview -> "1".equals(specialReview.getSpecialReviewTypeCode())).forEach(specialReview -> {
                String protocolNumber = specialReview.getProtocolNumber();
                String fundingSourceNumber = institutionalProposal.getProposalNumber();
                String fundingSourceTypeCode = "5";
                if (!this.getSpecialReviewService().isLinkedToProtocolFundingSource(protocolNumber, fundingSourceNumber, fundingSourceTypeCode)) {
                    String fundingSourceName = institutionalProposal.getSponsorName();
                    String fundingSourceTitle = institutionalProposal.getTitle();
                    this.getSpecialReviewService().addProtocolFundingSourceForSpecialReview(protocolNumber, fundingSourceNumber, fundingSourceTypeCode, fundingSourceName, fundingSourceTitle);
                }
            });
        }
    }

    protected boolean requiresResubmissionPrompt(ProposalDevelopmentDocumentForm proposalDevelopmentForm) {
        ProposalDevelopmentViewHelperService proposalDevelopmentViewHelperService = (ProposalDevelopmentViewHelperService)proposalDevelopmentForm.getViewHelperService();
        if (proposalDevelopmentViewHelperService.isResubmissionPromptDialogEnabled()) {
            return proposalDevelopmentViewHelperService.requiresResubmissionPrompt(proposalDevelopmentForm.getDevelopmentProposal(), proposalDevelopmentForm.getResubmissionOption());
        }
        proposalDevelopmentForm.setResubmissionOption(this.getProposalDevelopmentService().getIPGenerateOption(proposalDevelopmentForm.getDevelopmentProposal()));
        return false;
    }

    protected boolean autogenerateInstitutionalProposal() {
        return this.getProposalDevelopmentService().autogenerateInstitutionalProposal();
    }

    private String createInstitutionalProposalVersion(String proposalNumber, DevelopmentProposal developmentProposal, Budget budget) {
        InstitutionalProposal institutionalProposal = this.getInstitutionalProposalService().createInstitutionalProposalVersion(proposalNumber, developmentProposal, budget);
        return institutionalProposal.getSequenceNumber().toString();
    }

    protected String createInstitutionalProposal(DevelopmentProposal developmentProposal, Budget budget) {
        InstitutionalProposal institutionalProposal = this.getInstitutionalProposalService().createInstitutionalProposal(developmentProposal, budget);
        String proposalNumber = institutionalProposal.getProposalNumber();
        Long institutionalProposalId = this.getActiveProposalId(proposalNumber);
        this.updateProposalAdminDetailsAfterInstPropCreation(developmentProposal, institutionalProposalId);
        return proposalNumber;
    }

    private Long getActiveProposalId(String proposalNumber) {
        Collection ips = this.getLegacyDataAdapter().findMatching(InstitutionalProposal.class, Collections.singletonMap(PROPOSAL_NUMBER, proposalNumber));
        return ((InstitutionalProposal)ips.toArray()[0]).getProposalId();
    }

    protected ProposalAdminDetails getProposalAdminDetailsForProposal(DevelopmentProposal proposal) {
        ProposalAdminDetails adminDetails = this.getLegacyDataAdapter().findMatching(ProposalAdminDetails.class, Collections.singletonMap("devProposalNumber", proposal.getProposalNumber())).stream().findFirst().orElse(null);
        if (adminDetails == null) {
            adminDetails = new ProposalAdminDetails();
            adminDetails.setDevelopmentProposal(proposal);
            adminDetails.setDevProposalNumber(proposal.getProposalNumber());
        }
        return adminDetails;
    }

    protected void updateProposalAdminDetailsForSubmit(DevelopmentProposal proposal) {
        ProposalAdminDetails proposalAdminDetails = this.getProposalAdminDetailsForProposal(proposal);
        proposalAdminDetails.setDateSubmittedByDept(new Timestamp(System.currentTimeMillis()));
        this.save(proposalAdminDetails);
    }

    protected void updateProposalAdminDetailsForReject(DevelopmentProposal proposal) {
        ProposalAdminDetails proposalAdminDetails = this.getProposalAdminDetailsForProposal(proposal);
        proposalAdminDetails.setDateReturnedToDept(new Timestamp(System.currentTimeMillis()));
        this.save(proposalAdminDetails);
    }

    protected void updateProposalAdminDetailsForFinalApproval(DevelopmentProposal proposal) {
        ProposalAdminDetails proposalAdminDetails = this.getProposalAdminDetailsForProposal(proposal);
        proposalAdminDetails.setDateApprovedByOsp(new Timestamp(System.currentTimeMillis()));
        this.save(proposalAdminDetails);
    }

    protected void updateProposalAdminDetailsForSubmitToSponsor(DevelopmentProposal proposal) {
        ProposalAdminDetails proposalAdminDetails = this.getProposalAdminDetailsForProposal(proposal);
        proposalAdminDetails.setDateSubmittedToAgency(new Timestamp(System.currentTimeMillis()));
        this.save(proposalAdminDetails);
    }

    protected void updateProposalAdminDetailsAfterInstPropCreation(DevelopmentProposal proposal, Long instProposalId) {
        ProposalAdminDetails proposalAdminDetails = this.getProposalAdminDetailsForProposal(proposal);
        this.addCreateInstPropDetails(proposalAdminDetails);
        proposalAdminDetails.setInstProposalId(instProposalId);
        String loggedInUser = this.getGlobalVariableService().getUserSession().getPrincipalName();
        proposalAdminDetails.setSignedBy(loggedInUser);
        this.save(proposalAdminDetails);
    }

    protected void updateProposalAdminDetailsForBlanketApprove(DevelopmentProposal proposal) {
        ProposalAdminDetails proposalAdminDetails = this.getProposalAdminDetailsForProposal(proposal);
        if (proposalAdminDetails.getDateSubmittedByDept() == null) {
            proposalAdminDetails.setDateSubmittedByDept(new Timestamp(System.currentTimeMillis()));
        }
        if (proposalAdminDetails.getDateApprovedByOsp() == null) {
            proposalAdminDetails.setDateApprovedByOsp(new Timestamp(System.currentTimeMillis()));
        }
        this.save(proposalAdminDetails);
    }

    protected void save(ProposalAdminDetails proposalAdminDetails) {
        this.getLegacyDataAdapter().save((Object)proposalAdminDetails);
    }

    protected void addCreateInstPropDetails(ProposalAdminDetails proposalAdminDetails) {
        proposalAdminDetails.setInstPropCreateDate(new Timestamp(System.currentTimeMillis()));
        proposalAdminDetails.setInstPropCreateUser(this.getGlobalVariableService().getUserSession().getPrincipalName());
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=approveCheck"})
    public ModelAndView approveCheck(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        Boolean featureFlag = this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "proposal.approval.dialog.enabled");
        if (!featureFlag.booleanValue()) {
            return this.approve(form);
        }
        AuditHelper.ValidationState severityLevel = this.getValidationState(form);
        if (severityLevel.equals((Object)AuditHelper.ValidationState.ERROR)) {
            return this.getModelAndViewService().showDialog("DataValidationSection", true, (UifFormBase)form);
        }
        if (severityLevel.equals((Object)AuditHelper.ValidationState.WARNING)) {
            return this.getModelAndViewService().showDialog("DataValidationSection-WithApprove", true, (UifFormBase)form);
        }
        return this.approve(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=approve"})
    public ModelAndView approve(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        Document document = this.getDocumentService().getByDocumentHeaderId(form.getDocId());
        if (!this.canApproveDocument(document)) {
            this.getGlobalVariableService().getMessageMap().putError("GLOBAL_ERRORS", "error.proposalDevelopment.approve.unauthorized", new String[0]);
            return this.getTransactionalDocumentControllerService().reload((DocumentFormBase)form);
        }
        WorkflowDocument workflowDoc = form.getProposalDevelopmentDocument().getDocumentHeader().getWorkflowDocument();
        if (this.canGenerateRequestsInFuture(workflowDoc, this.getGlobalVariableService().getUserSession().getPrincipalId())) {
            DialogResponse frDialogResponse = form.getDialogResponse("PropDev-SubmitPage-ReceiveFutureRequests");
            if (frDialogResponse == null) {
                return this.getModelAndViewService().showDialog("PropDev-SubmitPage-ReceiveFutureRequests", false, (UifFormBase)form);
            }
            if (frDialogResponse.getResponseAsBoolean()) {
                form.getWorkflowDocument().setReceiveFutureRequests();
            } else {
                form.getWorkflowDocument().setDoNotReceiveFutureRequests();
            }
        }
        if (this.getValidationState(form).equals((Object)AuditHelper.ValidationState.ERROR)) {
            this.getGlobalVariableService().getMessageMap().putError(DATAVALIDATION, "error.workflow.submission", new String[0]);
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        form.setAuditActivated(false);
        boolean approvalComments = this.getParameterService().getParameterValueAsBoolean("KC-PD", "All", ENABLE_PD_WORKFLOW_APPROVAL_COMMENTS);
        if (approvalComments && (APPROVE_CHECK.equals(form.getMethodToCall()) || APPROVE.equals(form.getMethodToCall()))) {
            return this.getModelAndViewService().showDialog("PropDev-SubmitPage-ApproveDialog", false, (UifFormBase)form);
        }
        List<NotificationTypeRecipient> recipients = this.getRelatedApproversFromActionRequest(form.getProposalDevelopmentDocument().getDocumentNumber(), this.getGlobalVariableService().getUserSession().getPrincipalId()).stream().map(this::createRecipientFromPerson).collect(Collectors.toList());
        this.getTransactionalDocumentControllerService().performWorkflowAction((DocumentFormBase)form, UifConstants.WorkflowAction.APPROVE);
        if (approvalComments) {
            String narrativeTypeCode = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "approveNarrativeTypeCode");
            DevelopmentProposal pbo = this.getProposalHierarchyService().getDevelopmentProposal(form.getDevelopmentProposal().getProposalNumber());
            ProposalDevelopmentDocument pDoc = (ProposalDevelopmentDocument)this.getDocumentService().getByDocumentHeaderId(pbo.getProposalDocument().getDocumentNumber());
            this.getProposalHierarchyService().createAndSaveActionNarrative(form.getProposalDevelopmentApprovalBean().getActionReason(), PROPOSAL_APPROVAL_ATTACHMENT, form.getProposalDevelopmentApprovalBean().getActionFile(), narrativeTypeCode, pDoc);
        }
        if (recipients.size() != 0) {
            this.sendAnotherUserApprovedNotification(form, recipients);
        }
        this.getProposalLockService().releaseWorkflowPessimisticLocking((Document)form.getProposalDevelopmentDocument());
        if (this.getKcWorkflowService().isFinalApproval(workflowDoc)) {
            this.updateProposalAdminDetailsForFinalApproval(form.getDevelopmentProposal());
            if (form.getActionFlags().containsKey(SUBMIT_TO_SPONSOR) && this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, AUTO_SUBMIT_TO_SPONSOR_ON_FINAL_APPROVAL).booleanValue()) {
                return this.submitToSponsor(form);
            }
        }
        form.setCanEditView(null);
        form.setEvaluateFlagsAndModes(true);
        return this.updateProposalState(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=confirmApproval"})
    public ModelAndView confirmApproval(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        if (form.getProposalDevelopmentApprovalBean().getActionReason() != null) {
            form.setAnnotation(StringUtils.defaultString((String)form.getProposalDevelopmentApprovalBean().getActionReason()));
        }
        return this.approve(form);
    }

    protected void sendAnotherUserApprovedNotification(ProposalDevelopmentDocumentForm form, List<NotificationTypeRecipient> recipients) {
        this.prepareNotification(form.getDevelopmentProposal());
        ProposalDevelopmentNotificationContext notificationContext = new ProposalDevelopmentNotificationContext(form.getDevelopmentProposal(), ANOTHER_USER_APPROVED_ACTION_TYPE_CODE, ANOTHER_USER_APPROVED_NOTIFICATION, this.getRenderer());
        form.getNotificationHelper().initializeDefaultValues(notificationContext);
        if (this.getKcNotificationService().getNotificationType(notificationContext) != null) {
            ProposalDevelopmentNotification notification = new ProposalDevelopmentNotification();
            notification.setSubject(form.getNotificationHelper().getNotification().getSubject());
            notification.setMessage(form.getNotificationHelper().getNotification().getMessage());
            this.getKcNotificationService().sendNotificationAndPersist(notificationContext, notification, recipients, form.getDevelopmentProposal());
        }
    }

    private boolean canGenerateRequestsInFuture(WorkflowDocument workflowDoc, String principalId) {
        RoutingReportCriteria.Builder reportCriteriaBuilder = RoutingReportCriteria.Builder.createByDocumentId((String)workflowDoc.getDocumentId());
        reportCriteriaBuilder.setTargetPrincipalIds(Collections.singletonList(principalId));
        String currentRouteNodeNames = this.getKradWorkflowDocumentService().getCurrentRouteNodeNames(workflowDoc);
        return this.hasAskedToNotReceiveFutureRequests(workflowDoc, principalId) && this.canGenerateMultipleApprovalRequests(reportCriteriaBuilder.build(), principalId, currentRouteNodeNames);
    }

    private boolean hasAskedToNotReceiveFutureRequests(WorkflowDocument workflowDoc, String principalId) {
        boolean receiveFutureRequests = false;
        boolean doNotReceiveFutureRequests = false;
        Map variables = workflowDoc.getVariables();
        for (Map.Entry entry : variables.entrySet()) {
            String variableKey = (String)entry.getKey();
            String variableValue = (String)entry.getValue();
            if (variableKey.startsWith("_receive_future_requests") && variableValue.toUpperCase().equals("YES") && variableKey.contains(principalId)) {
                receiveFutureRequests = true;
                break;
            }
            if (!variableKey.startsWith("_receive_future_requests") || !variableValue.toUpperCase().equals("NO") || !variableKey.contains(principalId)) continue;
            doNotReceiveFutureRequests = true;
            break;
        }
        return !receiveFutureRequests && !doNotReceiveFutureRequests;
    }

    protected boolean canGenerateMultipleApprovalRequests(RoutingReportCriteria reportCriteria, String loggedInPrincipalId, String currentRouteNodeNames) {
        int approvalRequestsCount = 0;
        DocumentDetail documentDetail = this.getWorkflowDocumentActionsService().executeSimulation(reportCriteria);
        for (ActionRequest actionRequest : documentDetail.getActionRequests()) {
            if (!actionRequest.isPending() || !actionRequest.getActionRequested().getCode().equalsIgnoreCase("A") || !this.recipientMatchesUser(actionRequest, loggedInPrincipalId) || StringUtils.contains((CharSequence)currentRouteNodeNames, (CharSequence)actionRequest.getNodeName())) continue;
            ++approvalRequestsCount;
        }
        return approvalRequestsCount > 0;
    }

    protected boolean recipientMatchesUser(ActionRequest actionRequest, String loggedInPrincipalId) {
        if (actionRequest != null && loggedInPrincipalId != null) {
            List actionRequests = Collections.singletonList(actionRequest);
            if (actionRequest.isRoleRequest()) {
                actionRequests = actionRequest.getChildRequests();
            }
            for (ActionRequest cActionRequest : actionRequests) {
                String recipientUser = cActionRequest.getPrincipalId();
                if ((recipientUser == null || !recipientUser.equals(loggedInPrincipalId)) && (!StringUtils.isNotBlank((CharSequence)cActionRequest.getGroupId()) || !this.getGroupService().isMemberOfGroup(loggedInPrincipalId, cActionRequest.getGroupId()))) continue;
                return true;
            }
        }
        return false;
    }

    protected ModelAndView updateProposalState(ProposalDevelopmentDocumentForm form) {
        if (this.getKcWorkflowService().isFinalApproval(form.getWorkflowDocument())) {
            this.getGlobalVariableService().getMessageMap().getInfoMessages().clear();
            this.getGlobalVariableService().getMessageMap().putInfoForSectionId("PropDev-SubmitPage", "info.proposal.approval.final", new String[0]);
        }
        form.getDevelopmentProposal().setProposalStateTypeCode(this.getProposalStateService().getProposalStateTypeCode(form.getProposalDevelopmentDocument(), false));
        this.getDataObjectService().wrap((Object)form.getDevelopmentProposal()).fetchRelationship(PROPOSAL_STATE);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=reject"})
    public ModelAndView reject(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        ProposalDevelopmentActionBean bean = form.getProposalDevelopmentRejectionBean();
        if (new ProposalDevelopmentRejectionRule().proccessProposalDevelopmentRejection(bean)) {
            List<NotificationTypeRecipient> recipients = this.getAllCurrentApprovers(form.getProposalDevelopmentDocument().getDocumentNumber(), this.getGlobalVariableService().getUserSession().getPrincipalId()).stream().map(this::createRecipientFromPerson).collect(Collectors.toList());
            this.getProposalHierarchyService().rejectProposalDevelopmentDocument(form.getDevelopmentProposal().getProposalNumber(), bean.getActionReason(), this.getGlobalVariableService().getUserSession().getPrincipalId(), bean.getActionFile());
            this.updateProposalAdminDetailsForReject(form.getDevelopmentProposal());
            this.sendRejectNotification(form, recipients);
        }
        if (this.canOpenDocument(form.getDocument())) {
            form.setCanEditView(null);
            form.setEvaluateFlagsAndModes(true);
            return this.getTransactionalDocumentControllerService().reload((DocumentFormBase)form);
        }
        return this.getKcCommonControllerService().returnHome((UifFormBase)form);
    }

    public boolean canOpenDocument(Document document) {
        return this.getDocumentDictionaryService().getDocumentAuthorizer(document).canOpen(document, this.getGlobalVariableService().getUserSession().getPerson());
    }

    public boolean canApproveDocument(Document document) {
        return this.getDocumentDictionaryService().getDocumentAuthorizer(document).canApprove(document, this.getGlobalVariableService().getUserSession().getPerson());
    }

    protected void sendRejectNotification(ProposalDevelopmentDocumentForm form, List<NotificationTypeRecipient> recipients) {
        this.prepareNotification(form.getDevelopmentProposal());
        ProposalDevelopmentNotificationContext notificationContext = new ProposalDevelopmentNotificationContext(form.getDevelopmentProposal(), RETURN_ACTION_TYPE_CODE, RETURN_NOTIFICATION, this.getRenderer());
        form.getNotificationHelper().initializeDefaultValues(notificationContext);
        recipients.addAll(form.getNotificationHelper().getNotificationRecipients());
        if (!recipients.isEmpty() && this.getKcNotificationService().getNotificationType(notificationContext) != null) {
            this.getKcNotificationService().sendNotificationAndPersist(notificationContext, new ProposalDevelopmentNotification(form.getNotificationHelper().getNotification()), recipients, form.getDevelopmentProposal());
        }
    }

    protected void prepareNotification(DevelopmentProposal developmentProposal) {
        this.getRenderer().setDevelopmentProposal(developmentProposal);
        this.getRenderer().setProposalPerson(developmentProposal.getPrincipalInvestigator());
    }

    protected HashSet<String> getRelatedApproversFromActionRequest(String documentNumber, String loggedInUser) {
        List<ActionRequestValue> allActionRequestsByDocumentId = this.getAllActionRequestsByDocumentId(documentNumber);
        return allActionRequestsByDocumentId.stream().filter(request -> loggedInUser.equals(request.getPrincipalId())).flatMap(this::getRelatedActionRequests).flatMap(request -> this.getRequestedPrincipalIds(List.of(request))).filter(principalId -> principalId != null && !principalId.equals(loggedInUser)).collect(Collectors.toCollection(HashSet::new));
    }

    protected Set<String> getAllCurrentApprovers(String documentNumber, String loggedInUser) {
        List<ActionRequestValue> allActionRequestsByDocumentId = this.getAllActionRequestsByDocumentId(documentNumber);
        return allActionRequestsByDocumentId.stream().filter(ActionRequestValue::isActive).flatMap(actionRequestValue -> {
            if (actionRequestValue.getPrincipalId() != null) {
                return Stream.of(actionRequestValue.getPrincipalId());
            }
            if (actionRequestValue.getGroupId() != null) {
                return this.getGroupService().getMemberPrincipalIds(actionRequestValue.getGroupId()).stream();
            }
            return Stream.empty();
        }).filter(principalId -> !principalId.equals(loggedInUser)).collect(Collectors.toSet());
    }

    protected Stream<String> getRequestedPrincipalIds(List<ActionRequestValue> actionRequests) {
        return actionRequests.stream().filter(ActionRequestValue::isActive).flatMap(actionRequest -> Stream.concat(this.getDirectPrincipalIds((ActionRequestValue)actionRequest), CollectionUtils.isEmpty((Collection)actionRequest.getChildrenRequests()) ? Stream.empty() : this.getRequestedPrincipalIds(actionRequest.getChildrenRequests())));
    }

    protected Stream<String> getDirectPrincipalIds(ActionRequestValue actionRequest) {
        if (actionRequest.isUserRequest()) {
            return Stream.of(actionRequest.getPrincipalId());
        }
        if (actionRequest.isGroupRequest()) {
            return this.getGroupService().getMemberPrincipalIds(actionRequest.getGroupId()).stream();
        }
        return Stream.empty();
    }

    protected Stream<ActionRequestValue> getRelatedActionRequests(ActionRequestValue actionRequestValue) {
        ArrayList<ActionRequestValue> relatedActionRequests = new ArrayList<ActionRequestValue>();
        if (ActionRequestPolicy.FIRST.getCode().equalsIgnoreCase(actionRequestValue.getApprovePolicy()) && actionRequestValue.getParentActionRequest() != null) {
            relatedActionRequests.addAll(this.getRelatedActionRequests(actionRequestValue.getParentActionRequest()).collect(Collectors.toList()));
            relatedActionRequests.addAll(actionRequestValue.getParentActionRequest().getChildrenRequests());
        } else {
            relatedActionRequests.add(actionRequestValue);
        }
        return relatedActionRequests.stream();
    }

    public List<ActionRequestValue> getAllActionRequestsByDocumentId(String documentNumber) {
        return this.actionRequestService.findAllActionRequestsByDocumentId(documentNumber);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=cancelReject"})
    public ModelAndView cancelReject(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        form.setProposalDevelopmentRejectionBean(new ProposalDevelopmentActionBean());
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=cancelApprove"})
    public ModelAndView cancelApprove(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        form.setProposalDevelopmentApprovalBean(new ProposalDevelopmentActionBean());
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=sendAdHocRequests"})
    public ModelAndView sendAdHocRequests(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        form.setCanEditView(null);
        form.setEvaluateFlagsAndModes(true);
        return this.getTransactionalDocumentControllerService().sendAdHocRequests((DocumentFormBase)form);
    }

    private boolean submitS2sApplication(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        return this.getS2sSubmissionService().submitApplication(proposalDevelopmentDocument);
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    public WorkflowDocumentService getKradWorkflowDocumentService() {
        return this.kradWorkflowDocumentService;
    }

    public void setKradWorkflowDocumentService(WorkflowDocumentService kradWorkflowDocumentService) {
        this.kradWorkflowDocumentService = kradWorkflowDocumentService;
    }

    public WorkflowDocumentActionsService getWorkflowDocumentActionsService() {
        return this.workflowDocumentActionsService;
    }

    public void setWorkflowDocumentActionsService(WorkflowDocumentActionsService workflowDocumentActionsService) {
        this.workflowDocumentActionsService = workflowDocumentActionsService;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public ProposalHierarchyService getProposalHierarchyService() {
        return this.proposalHierarchyService;
    }

    @Override
    public void setProposalHierarchyService(ProposalHierarchyService proposalHierarchyService) {
        this.proposalHierarchyService = proposalHierarchyService;
    }

    public ProposalDevelopmentNotificationRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(ProposalDevelopmentNotificationRenderer renderer) {
        this.renderer = renderer;
    }

    public KcBusinessRulesEngine getKcBusinessRulesEngine() {
        return this.kcBusinessRulesEngine;
    }

    public void setKcBusinessRulesEngine(KcBusinessRulesEngine kcBusinessRulesEngine) {
        this.kcBusinessRulesEngine = kcBusinessRulesEngine;
    }

    public ProposalStateService getProposalStateService() {
        return this.proposalStateService;
    }

    public void setProposalStateService(ProposalStateService proposalStateService) {
        this.proposalStateService = proposalStateService;
    }

    public SpecialReviewService getSpecialReviewService() {
        return this.specialReviewService;
    }

    public void setSpecialReviewService(SpecialReviewService specialReviewService) {
        this.specialReviewService = specialReviewService;
    }

    public KcWorkflowService getKcWorkflowService() {
        return this.kcWorkflowService;
    }

    public void setKcWorkflowService(KcWorkflowService kcWorkflowService) {
        this.kcWorkflowService = kcWorkflowService;
    }

    public ActionRequestService getActionRequestService() {
        return this.actionRequestService;
    }

    public void setActionRequestService(ActionRequestService actionRequestService) {
        this.actionRequestService = actionRequestService;
    }

    public NotificationControllerService getNotificationControllerService() {
        return this.notificationControllerService;
    }

    public void setNotificationControllerService(NotificationControllerService notificationControllerService) {
        this.notificationControllerService = notificationControllerService;
    }

    public CollectionControllerService getCollectionControllerService() {
        return this.collectionControllerService;
    }

    public void setCollectionControllerService(CollectionControllerService collectionControllerService) {
        this.collectionControllerService = collectionControllerService;
    }

    public ActionListService getActionListService() {
        return this.actionListService;
    }

    public void setActionListService(ActionListService actionListService) {
        this.actionListService = actionListService;
    }
}

