/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.coeus.common.framework.auth.task.ApplicationTask;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.Printable;
import org.kuali.coeus.common.framework.print.PrintableAttachment;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.util.PrintingUtils;
import org.kuali.coeus.common.framework.print.watermark.WatermarkService;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolAction;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.actions.IacucActionHelper;
import org.kuali.kra.iacuc.actions.IacucProtocolActionBean;
import org.kuali.kra.iacuc.actions.IacucProtocolRequestAction;
import org.kuali.kra.iacuc.actions.IacucProtocolSubmissionDoc;
import org.kuali.kra.iacuc.actions.amendrenew.IacucProtocolAmendRenewService;
import org.kuali.kra.iacuc.actions.amendrenew.ModifyIacucAmendmentSectionsEvent;
import org.kuali.kra.iacuc.actions.copy.IacucProtocolCopyService;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecision;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecisionAbstainerEvent;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecisionRecuserEvent;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteePerson;
import org.kuali.kra.iacuc.actions.delete.IacucProtocolDeleteService;
import org.kuali.kra.iacuc.actions.followup.IacucFollowupActionService;
import org.kuali.kra.iacuc.actions.genericactions.IacucProtocolGenericActionBean;
import org.kuali.kra.iacuc.actions.print.IacucProtocolPrintingService;
import org.kuali.kra.iacuc.actions.request.IacucProtocolRequestBean;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucProtocolAddReviewAttachmentEvent;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucProtocolAddReviewCommentEvent;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucProtocolManageReviewAttachmentEvent;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucReviewAttachmentsBean;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucReviewCommentsBean;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucReviewCommentsService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewerBean;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionBuilder;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmitAction;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmitActionEvent;
import org.kuali.kra.iacuc.actions.submit.IacucValidProtocolActionAction;
import org.kuali.kra.iacuc.actions.undo.IacucProtocolUndoLastActionService;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.iacuc.committee.meeting.IacucCommitteeScheduleMinute;
import org.kuali.kra.iacuc.correspondence.IacucProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.iacuc.correspondence.IacucProtocolActionsCorrespondence;
import org.kuali.kra.iacuc.correspondence.IacucProtocolCorrespondence;
import org.kuali.kra.iacuc.noteattachment.IacucProtocolAttachmentPersonnel;
import org.kuali.kra.iacuc.noteattachment.IacucProtocolAttachmentProtocol;
import org.kuali.kra.iacuc.noteattachment.IacucProtocolAttachmentService;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationContext;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationRequestBean;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolReviewAttachment;
import org.kuali.kra.iacuc.questionnaire.print.IacucCorrespondencePrintingService;
import org.kuali.kra.iacuc.questionnaire.print.IacucQuestionnairePrintingService;
import org.kuali.kra.irb.actions.history.ProtocolHistoryFilterDatesEvent;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.ProtocolOnlineReviewCommentable;
import org.kuali.kra.protocol.actions.ProtocolSubmissionDocBase;
import org.kuali.kra.protocol.actions.notify.ProtocolActionAttachment;
import org.kuali.kra.protocol.actions.print.ProtocolActionPrintEvent;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.actions.undo.UndoLastActionBean;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.summary.AttachmentSummary;
import org.kuali.kra.protocol.summary.ProtocolSummary;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class IacucProtocolActionsAction
extends IacucProtocolAction {
    private static final Logger LOG = LogManager.getLogger(IacucProtocolActionsAction.class);
    private static final String CONFIRM_NO_ACTION = "";
    private static final String CONFIRM_DELETE_ACTION_ATT = "confirmDeleteActionAttachment";
    private static final String CONFIRM_FOLLOWUP_ACTION = "confirmAddFollowupAction";
    private static final String CONFIRM_SUBMIT_FOR_REVIEW_KEY = "confirmSubmitForReview";
    private static final String NOT_FOUND_SELECTION = "The attachment was not found for selection ";
    private static final String CONFIRM_DELETE_PROTOCOL_KEY = "confirmDeleteProtocol";
    private static final String INVALID_ATTACHMENT = "this attachment version is invalid ";
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private static final String SUBMISSION_ID = "submissionId";
    private static final String CORRESPONDENCE = "correspondence";
    public static final String ACTION_HELPER = "actionHelper.";
    public static final String REVIEWER_ATTRIBUTE = ".reviewer[";
    public static final String NUMBER_OF_REVIEWERS_ATTRIBUTE = ".numberOfReviewers";
    public static final String REVIEWER_TYPE_CODE_ATTRIBUTE = "].reviewerTypeCode";
    public static final String PERSON_ID_ATTRIBUTE = "].personId";
    public static final String FULL_NAME_ATTRIBUTE = "].fullName";
    public static final String NON_EMPLOYEE_FLAG_ATTRIBUTE = "].nonEmployeeFlag";
    public static final String TRUE_FLAG = "Y";

    public ActionForward assignCommitteeSchedule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
        String callerString = "assignCommitteeSchedule";
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String currentTaskName;
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (request.getParameterMap().containsKey("doCopy")) {
            String docId = request.getParameter("docId");
            IacucProtocolDocument ipd = (IacucProtocolDocument)this.getDocumentService().getByDocumentHeaderId(docId);
            protocolForm.setDocument((Document)ipd);
            protocolForm.setDefaultOpenCopyTab(true);
        }
        if ((currentTaskName = this.getTaskName(request)) != null) {
            protocolForm.getActionHelper().setCurrentTask(currentTaskName);
        } else {
            protocolForm.getActionHelper().setCurrentTask(CONFIRM_NO_ACTION);
        }
        ActionForward actionForward = super.execute(mapping, form, request, response);
        if ("close".equals(protocolForm.getMethodToCall()) || protocolForm.getMethodToCall() == null) {
            return mapping.findForward("portal");
        }
        protocolForm.getActionHelper().prepareView();
        protocolForm.getActionHelper().initFilterDatesView();
        ((IacucActionHelper)protocolForm.getActionHelper()).initSubmissionDetails();
        return actionForward;
    }

    public ActionForward copyProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        ApplicationTask task = new ApplicationTask("createIacucProtocol");
        if (this.isAuthorized(task)) {
            IacucProtocolDocument copy = (IacucProtocolDocument)this.getDocumentService().saveDocument((Document)this.getIacucProtocolCopyService().copyProtocol(protocolForm.getIacucProtocolDocument()));
            protocolForm.setDocId(copy.getDocumentNumber());
            protocolForm.setViewOnly(false);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getIacucProtocolDocument().setViewOnly(protocolForm.isViewOnly());
            protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
            protocolForm.getProtocolHelper().prepareView();
            return mapping.findForward("iacucProtocol");
        }
        return mapping.findForward("basic");
    }

    public ActionForward activate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return KcServiceLocator.getService(AuditHelper.class).setAuditMode(mapping, (ProtocolFormBase)form, true);
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return KcServiceLocator.getService(AuditHelper.class).setAuditMode(mapping, (ProtocolFormBase)form, false);
    }

    public ActionForward refreshPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward submitForReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolSubmitAction submitAction;
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument protocolDocument = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        protocolForm.setAuditActivated(true);
        IacucProtocolTask task = new IacucProtocolTask("submitIacucProtocol", protocolDocument.getIacucProtocol());
        if (this.isAuthorized(task) && this.applyRules(protocolForm, (DocumentEvent)new IacucProtocolSubmitActionEvent(protocolDocument, submitAction = (IacucProtocolSubmitAction)protocolForm.getActionHelper().getProtocolSubmitAction()))) {
            AuditHelper auditHelper = KcServiceLocator.getService(AuditHelper.class);
            if (auditHelper.auditUnconditionally((Document)protocolDocument)) {
                forward = this.isCommitteeMeetingAssignedMaxProtocols(submitAction.getNewCommitteeId(), submitAction.getNewScheduleId()) ? this.confirm(this.buildSubmitForReviewConfirmationQuestion(mapping, form, request, response), CONFIRM_SUBMIT_FOR_REVIEW_KEY, CONFIRM_NO_ACTION) : this.submitForReviewAndRedirect(mapping, form, request, response);
            } else {
                GlobalVariables.getMessageMap().clearErrorMessages();
                GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
            }
        }
        return forward;
    }

    public ActionForward assignCommittee(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isAssignCommitteeAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().assignCommittee(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    private boolean isCommitteeMeetingAssignedMaxProtocols(String committeeId, String scheduleId) {
        boolean isMax = false;
        return isMax;
    }

    private StrutsConfirmation buildSubmitForReviewConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SUBMIT_FOR_REVIEW_KEY, "question.protocol.confirmExceedMaxProtocols", new String[0]);
    }

    public ActionForward confirmSubmitForReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        String question = request.getParameter("questionIndex");
        if (CONFIRM_SUBMIT_FOR_REVIEW_KEY.equals(question)) {
            forward = this.submitForReviewAndRedirect(mapping, form, request, response);
        }
        return forward;
    }

    private ActionForward submitForReviewAndRedirect(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        List<ProtocolReviewerBeanBase> reviewers = this.getReviewers(request, "iacucProtocolSubmitAction");
        super.route(mapping, (ActionForm)protocolForm, request, response);
        this.getProtocolActionRequestService().submitForReview(protocolForm, reviewers);
        return this.routeProtocolToHoldingPage(mapping, protocolForm);
    }

    private ActionForward routeProtocolToHoldingPage(ActionMapping mapping, ProtocolFormBase protocolForm) {
        String routeHeaderId = protocolForm.getProtocolDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "protocolActions", "IacucProtocolDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionRedirect holdingPageForward = new ActionRedirect((ForwardConfig)mapping.findForward("kraHoldingPage"));
        holdingPageForward.addParameter("holdingPageDocumentId", (Object)routeHeaderId);
        return this.routeToHoldingPage(basicForward, basicForward, holdingPageForward, returnLocation, routeHeaderId);
    }

    public ActionForward administrativelyMarkIncompleteProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isAdministrativelyMarkIncompleteProtocolAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().administrativelyMarkIncompleteProtocol(protocolForm);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward administrativelyWithdrawProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isAdministrativelyWithdrawProtocolAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().administrativelyWithdrawProtocol(protocolForm);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward withdrawProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isWithdrawProtocolAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().withdrawProtocol(protocolForm);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward notifyIacucProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        String forwardTo = this.getProtocolActionRequestService().notifyProtocol(protocolForm);
        forward = mapping.findForward(forwardTo);
        this.loadDocument((KualiDocumentFormBase)protocolForm);
        protocolForm.getProtocolHelper().prepareView();
        return forward;
    }

    public ActionForward addSubmissionDoc(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        ProtocolBase protocol = protocolForm.getActionHelper().getProtocol();
        int actionIndex = this.getSelectedLine(request);
        if (((IacucActionHelper)protocolForm.getActionHelper()).validFile(protocol.getProtocolActions().get(actionIndex).getNewActionAttachment(), "protocolNotifyIrbBean")) {
            IacucProtocolSubmissionDoc fyiAttachment = null;
            ProtocolActionAttachment newAttachment = protocol.getProtocolActions().get(actionIndex).getNewActionAttachment();
            Long submissionId = protocol.getProtocolActions().get(actionIndex).getSubmissionIdFk();
            for (ProtocolSubmissionBase fyiSubmission : protocol.getProtocolSubmissions()) {
                if (fyiSubmission.getSubmissionId().longValue() != submissionId.longValue()) continue;
                fyiAttachment = IacucProtocolSubmissionBuilder.createProtocolSubmissionDoc((IacucProtocolSubmission)fyiSubmission, newAttachment.getFile().getFileName(), newAttachment.getFile().getContentType(), newAttachment.getFile().getFileData(), newAttachment.getDescription());
                break;
            }
            if (fyiAttachment != null) {
                this.getBusinessObjectService().save(fyiAttachment);
                ((IacucActionHelper)((IacucProtocolForm)form).getActionHelper()).getIacucProtocolNotifyIacucBean().setNewActionAttachment(new ProtocolActionAttachment());
            }
        }
        return mapping.findForward(this.getProtocolHistoryForwardNameHook());
    }

    public ActionForward deleteSubmissionDoc(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        ProtocolActionBase protocolAction = protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        ProtocolSubmissionDocBase attachment = protocolAction.getProtocolSubmissionDocs().get(attachmentIndex);
        if (attachment == null) {
            LOG.info("The attachment was not found for protocolAction: " + actionIndex + ", protocolSubmissionDoc: " + attachmentIndex);
            return mapping.findForward(this.getProtocolHistoryForwardNameHook());
        }
        this.getBusinessObjectService().delete((Object)attachment);
        return mapping.findForward(this.getProtocolHistoryForwardNameHook());
    }

    public ActionForward createAmendment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isCreateAmendmentAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().createAmendment(protocolForm);
            forward = mapping.findForward(forwardTo);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
        }
        return forward;
    }

    public ActionForward modifyAmendmentSections(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument protocolDocument = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = protocolDocument.getIacucProtocol();
        protocolForm.getActionHelper().setCurrentTask("modifyAmendmentSections");
        IacucProtocolTask task = new IacucProtocolTask("modifyAmendmentSections", protocol);
        if (this.isAuthorized(task)) {
            if (!this.applyRules((DocumentEvent)new ModifyIacucAmendmentSectionsEvent(protocolDocument, "actionHelper.protocolModifyAmendment", protocolForm.getActionHelper().getProtocolAmendmentBean()))) {
                return mapping.findForward("basic");
            }
            this.getProtocolAmendRenewService().updateAmendmentRenewal(protocolForm.getProtocolDocument(), protocolForm.getActionHelper().getProtocolAmendmentBean());
            return this.save(mapping, (ActionForm)protocolForm, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward createRenewal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isCreateRenewalAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().createRenewal(protocolForm);
            forward = mapping.findForward(forwardTo);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
        }
        return forward;
    }

    public ActionForward createRenewalWithAmendment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isCreateRenewalWithAmendmentAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().createRenewalWithAmendment(protocolForm);
            forward = mapping.findForward(forwardTo);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
        }
        return forward;
    }

    public ActionForward createContinuation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isCreateContinuationAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().createContinuation(protocolForm);
            forward = mapping.findForward(forwardTo);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
        }
        return forward;
    }

    public ActionForward createContinuationWithAmendment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isCreateContinuationWithAmendmentAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().createContinuationWithAmendment(protocolForm);
            forward = mapping.findForward(forwardTo);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
        }
        return forward;
    }

    public ActionForward deleteProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        IacucProtocolTask task = new IacucProtocolTask("protocolAmendRenewDelete", (IacucProtocol)protocolForm.getProtocolDocument().getProtocol());
        if (this.isAuthorized(task)) {
            return this.confirm(this.buildDeleteProtocolConfirmationQuestion(mapping, form, request, response), CONFIRM_DELETE_PROTOCOL_KEY, CONFIRM_NO_ACTION);
        }
        return mapping.findForward("basic");
    }

    public ActionForward confirmDeleteProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_PROTOCOL_KEY.equals(question)) {
            ProtocolFormBase protocolForm = (ProtocolFormBase)form;
            IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
            this.getProtocolDeleteService().delete(protocolForm.getProtocolDocument());
            IacucProtocolNotificationRequestBean newNotificationBean = new IacucProtocolNotificationRequestBean(protocol, "906", "Deleted");
            IacucProtocolCorrespondence newProtocolCorrespondence = this.getProtocolCorrespondence(protocolForm, "iacucProtocolActions", newNotificationBean, false);
            protocolForm.getActionHelper().setProtocolCorrespondence(newProtocolCorrespondence);
            this.recordProtocolActionSuccess("Delete ProtocolBase, Amendment, or Renewal");
            if (newProtocolCorrespondence != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, "iacucProtocol", (IacucProtocolForm)protocolForm, newNotificationBean);
        }
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildDeleteProtocolConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolDocumentBase doc = ((ProtocolFormBase)form).getProtocolDocument();
        String protocolNumber = doc.getProtocol().getProtocolNumber();
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_PROTOCOL_KEY, "document.question.deleteProtocol.text", protocolNumber);
    }

    public ActionForward viewProtocolAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        int selected = this.getSelectedLine(request);
        IacucProtocolAttachmentProtocol attachment = (IacucProtocolAttachmentProtocol)protocol.getActiveAttachmentProtocolsNoDelete().get(selected);
        return this.printAttachmentProtocol(mapping, response, attachment, protocolForm);
    }

    public ActionForward viewProtocolPersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        int selected = this.getSelectedLine(request);
        IacucProtocolAttachmentPersonnel personAttach = (IacucProtocolAttachmentPersonnel)protocolForm.getProtocolDocument().getProtocol().getAttachmentPersonnels().get(selected);
        return this.printPersonnelAttachmentProtocol(mapping, response, personAttach, protocolForm);
    }

    public ActionForward printProtocolQuestionnaires(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        ActionForward forward = mapping.findForward("basic");
        String fileName = "Protocol_questionnaire_Report.pdf";
        String reportName = protocol.getProtocolNumber() + "-ProtocolQuestionnaires";
        AttachmentDataSource dataStream = this.getProtocolPrintingService().print(reportName, this.getIacucQuestionnairePrintingService().getQuestionnairePrintable(protocol, protocolForm.getActionHelper().getQuestionnairesToPrints()));
        if (dataStream.getData() != null) {
            dataStream.setName(fileName.toString());
            PrintingUtils.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    public ActionForward printProtocolCorrespondences(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        ActionForward forward = mapping.findForward("basic");
        String fileName = "IACUC_Protocol_Correspondence_Report.pdf";
        String reportName = protocol.getProtocolNumber() + "-ProtocolCorrespondences";
        AttachmentDataSource dataStream = this.getProtocolPrintingService().print(reportName, this.getIacucCorrespondencePrintingService().getCorrespondencePrintable(protocol, protocolForm.getActionHelper().getCorrespondencesToPrint()));
        if (dataStream.getData() != null) {
            dataStream.setName(fileName.toString());
            PrintingUtils.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    private IacucCorrespondencePrintingService getIacucCorrespondencePrintingService() {
        return KcServiceLocator.getService(IacucCorrespondencePrintingService.class);
    }

    protected IacucQuestionnairePrintingService getIacucQuestionnairePrintingService() {
        return KcServiceLocator.getService(IacucQuestionnairePrintingService.class);
    }

    private ActionForward printAttachmentProtocol(ActionMapping mapping, HttpServletResponse response, IacucProtocolAttachmentProtocol attachment, ProtocolFormBase form) throws Exception {
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        byte[] attachmentFile = null;
        String attachmentFileType = file.getType().replace("\"", CONFIRM_NO_ACTION);
        if ((attachmentFileType = attachmentFileType.replace("\\", CONFIRM_NO_ACTION)).equalsIgnoreCase("application/pdf")) {
            attachmentFile = this.getProtocolAttachmentFile(form, attachment);
            if (attachmentFile != null) {
                this.streamToResponse(attachmentFile, IacucProtocolActionsAction.getValidHeaderString(file.getName()), IacucProtocolActionsAction.getValidHeaderString(file.getType()), response);
            } else {
                this.streamToResponse(file.getData(), IacucProtocolActionsAction.getValidHeaderString(file.getName()), IacucProtocolActionsAction.getValidHeaderString(file.getType()), response);
            }
            return RESPONSE_ALREADY_HANDLED;
        }
        this.streamToResponse(file.getData(), IacucProtocolActionsAction.getValidHeaderString(file.getName()), IacucProtocolActionsAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private ActionForward printPersonnelAttachmentProtocol(ActionMapping mapping, HttpServletResponse response, ProtocolAttachmentBase attachment, IacucProtocolForm form) throws Exception {
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), IacucProtocolActionsAction.getValidHeaderString(file.getName()), IacucProtocolActionsAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private byte[] getProtocolAttachmentFile(ProtocolFormBase form, ProtocolAttachmentProtocolBase attachment) {
        byte[] attachmentFile = null;
        AttachmentFile file = attachment.getFile();
        Printable printableArtifacts = this.getProtocolPrintingService().getProtocolPrintArtifacts(form.getProtocolDocument().getProtocol());
        ProtocolBase protocolCurrent = form.getProtocolDocument().getProtocol();
        int currentProtoSeqNumber = protocolCurrent.getSequenceNumber();
        try {
            if (printableArtifacts.isWatermarkEnabled()) {
                int currentAttachmentSequence = attachment.getSequenceNumber();
                String docStatusCode = attachment.getDocumentStatusCode();
                String statusCode = attachment.getStatusCode();
                if (this.getProtocolAttachmentService().isAttachmentActive(attachment) && currentProtoSeqNumber == currentAttachmentSequence || docStatusCode.equals("1")) {
                    if ("1".equals(statusCode)) {
                        attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getWatermark());
                    }
                } else {
                    attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getInvalidWatermark());
                    LOG.info(INVALID_ATTACHMENT + attachment.getDocumentId());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception Occurred in ProtocolNoteAndAttachmentAction. : ", (Throwable)e);
        }
        return attachmentFile;
    }

    public ActionForward filterHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        Date startDate = protocolForm.getActionHelper().getFilteredHistoryStartDate();
        Date endDate = protocolForm.getActionHelper().getFilteredHistoryEndDate();
        if (this.applyRules((DocumentEvent)new ProtocolHistoryFilterDatesEvent((Document)protocolForm.getProtocolDocument(), startDate, endDate))) {
            protocolForm.getActionHelper().initFilterDatesView();
        }
        return mapping.findForward("basic");
    }

    public ActionForward resetHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getActionHelper().setFilteredHistoryStartDate(null);
        protocolForm.getActionHelper().setFilteredHistoryEndDate(null);
        protocolForm.getActionHelper().initFilterDatesView();
        return mapping.findForward("basic");
    }

    public ActionForward loadProtocolSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        org.kuali.kra.iacuc.actions.IacucProtocolAction action = (org.kuali.kra.iacuc.actions.IacucProtocolAction)protocolForm.getActionHelper().getSelectedProtocolAction();
        if (action != null) {
            protocolForm.getActionHelper().setCurrentSequenceNumber(action.getSequenceNumber());
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewAttachmentProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.viewAttachment(mapping, (ProtocolFormBase)form, request, response);
    }

    private ActionForward viewAttachment(ActionMapping mapping, ProtocolFormBase form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        ProtocolSummary protocolSummary = form.getActionHelper().getProtocolSummary();
        int selectedIndex = this.getSelectedLine(request);
        AttachmentSummary attachmentSummary = protocolSummary.getAttachments().get(selectedIndex);
        if (attachmentSummary.getAttachmentType().startsWith("Protocol: ")) {
            IacucProtocolAttachmentProtocol attachment = this.getProtocolAttachmentService().getAttachment(IacucProtocolAttachmentProtocol.class, attachmentSummary.getAttachmentId());
            return this.printAttachmentProtocol(mapping, response, attachment, form);
        }
        IacucProtocolAttachmentPersonnel personnelAttachment = this.getProtocolAttachmentService().getAttachment(IacucProtocolAttachmentPersonnel.class, attachmentSummary.getAttachmentId());
        return this.printPersonnelAttachmentProtocol(mapping, response, personnelAttachment, (IacucProtocolForm)form);
    }

    public ActionForward viewPreviousProtocolSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        actionHelper.setCurrentSequenceNumber(actionHelper.getCurrentSequenceNumber() - 1);
        ((ProtocolFormBase)form).getActionHelper().initSummaryDetails();
        return mapping.findForward("basic");
    }

    public ActionForward viewNextProtocolSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        actionHelper.setCurrentSequenceNumber(actionHelper.getCurrentSequenceNumber() + 1);
        ((ProtocolFormBase)form).getActionHelper().initSummaryDetails();
        return mapping.findForward("basic");
    }

    public ActionForward viewPreviousSubmission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        actionHelper.setCurrentSubmissionNumber(actionHelper.getPrevSubmissionNumber());
        actionHelper.setAmendmentDetails();
        protocolForm.getActionHelper().initSubmissionDetails();
        return mapping.findForward("iacucProtocolHistory");
    }

    public ActionForward viewNextSubmission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        actionHelper.setCurrentSubmissionNumber(actionHelper.getNextSubmissionNumber());
        actionHelper.setAmendmentDetails();
        protocolForm.getActionHelper().initSubmissionDetails();
        return mapping.findForward("iacucProtocolHistory");
    }

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SUBMISSION_ID, request.getParameter(SUBMISSION_ID));
        IacucProtocolSubmission protocolSubmission = (IacucProtocolSubmission)this.getBusinessObjectService().findByPrimaryKey(IacucProtocolSubmission.class, fieldValues);
        protocolSubmission.getProtocol().setProtocolSubmission(protocolSubmission);
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        protocolForm.setDocId(protocolSubmission.getProtocol().getProtocolDocument().getDocumentNumber());
        this.loadDocument((KualiDocumentFormBase)protocolForm);
        protocolForm.initialize();
        return mapping.findForward("basic");
    }

    public ActionForward assignToAgenda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isAssignToAgendaAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().assignToAgenda(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward removeFromAgenda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isRemoveFromAgendaAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().removeFromAgenda(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward protocolReviewNotRequired(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isProtocolReviewNotRequiredAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().protocolReviewNotRequired(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward grantFullApproval(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isFullApprovalAuthorized(protocolForm)) {
            forward = super.approve(mapping, (ActionForm)protocolForm, request, response);
            this.getProtocolActionRequestService().grantFullApproval(protocolForm);
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            forward = this.routeProtocolToHoldingPage(mapping, protocolForm);
        }
        return forward;
    }

    public ActionForward grantAdminApproval(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isGrantAdminApprovalAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().grantAdminApproval(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward requestAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        String taskName = this.getTaskName(request);
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isRequestActionAuthorized(protocolForm, taskName)) {
            String forwardTo = this.getProtocolActionRequestService().performRequestAction(protocolForm, taskName);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward withdrawRequestAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isWithdrawRequestActionAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().withdrawRequestAction(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward addRequestAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = document.getIacucProtocol();
        String taskName = this.getTaskName(request);
        if (StringUtils.isNotBlank((CharSequence)taskName) && this.isAuthorized(new IacucProtocolTask(taskName, protocol))) {
            IacucProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
            if (requestBean.getNewActionAttachment().getFile() != null && requestBean.getNewActionAttachment().getFile().getFileData().length > 0) {
                requestBean.getNewActionAttachment().setFileName(requestBean.getNewActionAttachment().getFile().getFileName());
                requestBean.getActionAttachments().add(requestBean.getNewActionAttachment());
                requestBean.setNewActionAttachment(new ProtocolActionAttachment());
            } else {
                GlobalVariables.getMessageMap().putError("actionHelper.iacucProtocolSuspendRequestBean.newActionAttachment.file", "error.awardNotesAndAttachments.attachment.fileRequired", new String[0]);
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewRequestAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = document.getIacucProtocol();
        String taskName = this.getTaskName(request);
        if (StringUtils.isNotBlank((CharSequence)taskName) && this.isAuthorized(new IacucProtocolTask(taskName, protocol))) {
            IacucProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
            int lineNumber = this.getSelectedLine(request);
            ProtocolActionAttachment actionAttachment = requestBean.getActionAttachments().get(lineNumber);
            if (actionAttachment.getFile() != null) {
                this.streamToResponse(actionAttachment.getFile().getFileData(), actionAttachment.getFileName(), actionAttachment.getFile().getContentType(), response);
                return RESPONSE_ALREADY_HANDLED;
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteRequestAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = document.getIacucProtocol();
        String taskName = this.getTaskName(request);
        if (StringUtils.isNotBlank((CharSequence)taskName) && this.isAuthorized(new IacucProtocolTask(taskName, protocol))) {
            IacucProtocolRequestAction requestAction = IacucProtocolRequestAction.valueOfTaskName(taskName);
            IacucProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
            int lineNumber = this.getSelectedLine(request);
            requestBean.getActionAttachments().remove(lineNumber);
        }
        return mapping.findForward("basic");
    }

    private IacucProtocolRequestBean getProtocolRequestBean(ActionForm form, HttpServletRequest request) {
        IacucProtocolRequestBean protocolRequestBean = null;
        IacucProtocolActionBean protocolActionBean = this.getActionBean(form, request);
        if (protocolActionBean != null && protocolActionBean instanceof IacucProtocolRequestBean) {
            protocolRequestBean = (IacucProtocolRequestBean)protocolActionBean;
        }
        return protocolRequestBean;
    }

    public ActionForward disapproveProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isDisapproveProtocolAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().disapproveProtocol(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward expire(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isExpireProtocolAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().expireProtocol(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward terminate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isTerminateProtocolAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().terminateProtocol(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward suspend(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isSuspendProtocolAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().suspendProtocol(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward iacucAcknowledgement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isAcknowledgementAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().acknowledgement(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward iacucHold(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isHoldAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().hold(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward iacucLiftHold(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isLiftHoldAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().liftHold(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward returnForSMR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isReturnForSMRAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().returnForSMR(protocolForm);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward returnForSRR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isReturnForSRRAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().returnForSRR(protocolForm);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward returnToPI(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isReturnToPIAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().returnToPI(protocolForm);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward iacucDeactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isDeactivateAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().deactivate(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward manageComments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("protocolManageReviewComments", (IacucProtocol)protocolForm.getProtocolDocument().getProtocol())) {
                IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolManageReviewCommentsBean();
                this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
                this.recordProtocolActionSuccess("Manage Review Comments");
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward openProtocolForAdminCorrection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isOpenProtocolForAdminCorrectionAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().openProtocolForAdminCorrection(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward submitCommitteeDecision(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isSubmitCommitteeDecisionAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().submitCommitteeDecision(protocolForm);
            this.confirmFollowupAction(mapping, form, request, response, "basic");
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward addAbstainer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucCommitteeDecision decision = (IacucCommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        if (this.applyRules((DocumentEvent)new IacucCommitteeDecisionAbstainerEvent((IacucProtocolDocument)protocolForm.getProtocolDocument(), decision))) {
            decision.getAbstainers().add(decision.getNewAbstainer());
            decision.setNewAbstainer(new IacucCommitteePerson());
            decision.setAbstainCount(decision.getAbstainCount() + 1);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteAbstainer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucCommitteeDecision decision = (IacucCommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        IacucCommitteePerson person = decision.getAbstainers().get(this.getLineToDelete(request));
        if (person != null) {
            decision.getAbstainersToDelete().add(person);
            decision.getAbstainers().remove(this.getLineToDelete(request));
            decision.setAbstainCount(decision.getAbstainCount() - 1);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addRecused(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucCommitteeDecision decision = (IacucCommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        if (this.applyRules((DocumentEvent)new IacucCommitteeDecisionRecuserEvent((IacucProtocolDocument)protocolForm.getProtocolDocument(), decision))) {
            decision.getRecused().add(decision.getNewRecused());
            decision.setNewRecused(new IacucCommitteePerson());
            decision.setRecusedCount(decision.getRecusedCount() + 1);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteRecused(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucCommitteeDecision decision = (IacucCommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        IacucCommitteePerson person = decision.getRecused().get(this.getLineToDelete(request));
        if (person != null) {
            decision.getRecusedToDelete().add(person);
            decision.getRecused().remove(this.getLineToDelete(request));
            decision.setRecusedCount(decision.getRecusedCount() - 1);
        }
        return mapping.findForward("basic");
    }

    private IacucProtocolPrintingService getProtocolPrintingService() {
        return KcServiceLocator.getService(IacucProtocolPrintingService.class);
    }

    public ActionForward addReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase document = protocolForm.getProtocolDocument();
        IacucReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            String errorPropertyName = reviewCommentsBean.getErrorPropertyName();
            CommitteeScheduleMinuteBase newReviewComment = reviewCommentsBean.getNewReviewComment();
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            IacucProtocol protocol = (IacucProtocol)document.getProtocol();
            if (this.applyRules((DocumentEvent)new IacucProtocolAddReviewCommentEvent((IacucProtocolDocument)document, errorPropertyName, newReviewComment))) {
                this.getReviewCommentsService().addReviewComment(newReviewComment, reviewComments, protocol);
                reviewCommentsBean.setNewReviewComment(new IacucCommitteeScheduleMinute("3"));
            }
            reviewCommentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewCommentsBean.getReviewComments()));
        }
        return mapping.findForward("basic");
    }

    public ActionForward moveUpReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase document = protocolForm.getProtocolDocument();
        IacucReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            int lineNumber = this.getSelectedLine(request);
            this.getReviewCommentsService().moveUpReviewComment(reviewComments, document.getProtocol(), lineNumber);
        }
        return mapping.findForward("basic");
    }

    public ActionForward moveDownReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase document = protocolForm.getProtocolDocument();
        IacucReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            int lineNumber = this.getSelectedLine(request);
            this.getReviewCommentsService().moveDownReviewComment(reviewComments, document.getProtocol(), lineNumber);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IacucReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            int lineNumber = this.getLineToDelete(request);
            List<CommitteeScheduleMinuteBase> deletedReviewComments = reviewCommentsBean.getDeletedReviewComments();
            this.getReviewCommentsService().deleteReviewComment(reviewComments, lineNumber, deletedReviewComments);
            if (reviewComments.isEmpty()) {
                reviewCommentsBean.setHideReviewerName(true);
            } else {
                reviewCommentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewCommentsBean.getReviewComments()));
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward abandon(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isAbandonAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().abandon(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    private void saveReviewComments(IacucProtocolForm protocolForm, IacucReviewCommentsBean actionBean) throws Exception {
        this.getReviewCommentsService().saveReviewComments(actionBean.getReviewComments(), actionBean.getDeletedReviewComments());
        actionBean.setDeletedReviewComments(new ArrayList<CommitteeScheduleMinuteBase>());
        protocolForm.getActionHelper().prepareCommentsView();
    }

    private IacucReviewCommentsBean getReviewCommentsBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IacucReviewCommentsBean reviewCommentsBean = null;
        IacucProtocolActionBean protocolActionBean = this.getActionBean(form, request);
        if (protocolActionBean != null && protocolActionBean instanceof ProtocolOnlineReviewCommentable) {
            reviewCommentsBean = (IacucReviewCommentsBean)((ProtocolOnlineReviewCommentable)((Object)protocolActionBean)).getReviewCommentsBean();
        }
        return reviewCommentsBean;
    }

    private IacucProtocolActionBean getActionBean(ActionForm form, HttpServletRequest request) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        String taskName = this.getTaskName(request);
        IacucProtocolActionBean protocolActionBean = null;
        if (StringUtils.isNotBlank((CharSequence)taskName)) {
            protocolActionBean = (IacucProtocolActionBean)protocolForm.getActionHelper().getActionBean(taskName);
        }
        return protocolActionBean;
    }

    private String getTaskName(HttpServletRequest request) {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String taskName = CONFIRM_NO_ACTION;
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            taskName = StringUtils.substringBetween((String)parameterName, (String)".taskName", (String)".");
        }
        return taskName;
    }

    private boolean hasPermission(String taskName, IacucProtocol protocol) {
        IacucProtocolTask task = new IacucProtocolTask(taskName, protocol);
        return this.getTaskAuthorizationService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task);
    }

    private IacucProtocolAttachmentService getProtocolAttachmentService() {
        return KcServiceLocator.getService(IacucProtocolAttachmentService.class);
    }

    private TaskAuthorizationService getTaskAuthorizationService() {
        return KcServiceLocator.getService(TaskAuthorizationService.class);
    }

    public IacucProtocolCopyService getIacucProtocolCopyService() {
        return KcServiceLocator.getService(IacucProtocolCopyService.class);
    }

    private IacucProtocolAmendRenewService getProtocolAmendRenewService() {
        return KcServiceLocator.getService(IacucProtocolAmendRenewService.class);
    }

    private IacucProtocolDeleteService getProtocolDeleteService() {
        return KcServiceLocator.getService(IacucProtocolDeleteService.class);
    }

    private IacucReviewCommentsService getReviewCommentsService() {
        return KcServiceLocator.getService(IacucReviewCommentsService.class);
    }

    public ActionForward addNotifyIacucAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        if (actionHelper.validFile(actionHelper.getIacucProtocolNotifyIacucBean().getNewActionAttachment(), "iacucProtocolNotifyIacucBean")) {
            LOG.info("addNotifyIacucAttachment " + actionHelper.getIacucProtocolNotifyIacucBean().getNewActionAttachment().getFile().getFileName() + ((ProtocolFormBase)form).getProtocolDocument().getDocumentNumber());
            actionHelper.addNotifyIacucAttachment();
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewNotifyIacucAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.viewAttachment(mapping, (IacucProtocolForm)form, request, response);
    }

    private ActionForward viewAttachment(ActionMapping mapping, IacucProtocolForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        IacucActionHelper actionHelper = (IacucActionHelper)form.getActionHelper();
        ProtocolActionAttachment attachment = actionHelper.getIacucProtocolNotifyIacucBean().getActionAttachments().get(selection);
        if (attachment == null) {
            LOG.info(NOT_FOUND_SELECTION + selection);
            return mapping.findForward("basic");
        }
        this.streamToResponse(attachment.getFile().getFileData(), IacucProtocolActionsAction.getValidHeaderString(attachment.getFile().getFileName()), IacucProtocolActionsAction.getValidHeaderString(attachment.getFile().getContentType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deleteNotifyIacucAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        return this.confirmDeleteAttachment(mapping, protocolForm, request, response, actionHelper.getIacucProtocolNotifyIacucBean().getActionAttachments());
    }

    private ActionForward confirmDeleteAttachment(ActionMapping mapping, ProtocolFormBase form, HttpServletRequest request, HttpServletResponse response, List<ProtocolActionAttachment> attachments) throws Exception {
        int selection = this.getSelectedLine(request);
        ProtocolActionAttachment attachment = attachments.get(selection);
        if (attachment == null) {
            LOG.info(NOT_FOUND_SELECTION + selection);
            return mapping.findForward("basic");
        }
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, (ActionForm)form, request, response, CONFIRM_DELETE_ACTION_ATT, "document.question.deleteAttachment.text", CONFIRM_NO_ACTION, attachment.getFile().getFileName());
        return this.confirm(confirm, CONFIRM_DELETE_ACTION_ATT, CONFIRM_NO_ACTION);
    }

    public ActionForward confirmDeleteActionAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String taskName = this.getTaskName(request);
        int selection = this.getSelectedLine(request);
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        if (StringUtils.isBlank((CharSequence)taskName)) {
            actionHelper.getIacucProtocolNotifyIacucBean().getActionAttachments().remove(selection);
        } else {
            IacucProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
            requestBean.getActionAttachments().remove(selection);
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewSubmissionDoc(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        ProtocolActionBase protocolAction = protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        ProtocolSubmissionDocBase attachment = protocolAction.getProtocolSubmissionDocs().get(attachmentIndex);
        if (attachment == null) {
            LOG.info("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolSubmissionDoc: " + attachmentIndex);
            return mapping.findForward("basic");
        }
        this.streamToResponse(attachment.getDocument(), IacucProtocolActionsAction.getValidHeaderString(attachment.getFileName()), IacucProtocolActionsAction.getValidHeaderString(attachment.getContentType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward viewActionCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        ProtocolActionBase protocolAction = protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        ProtocolCorrespondence attachment = protocolAction.getProtocolCorrespondences().get(attachmentIndex);
        if (attachment == null) {
            LOG.info("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolCorrespondence: " + attachmentIndex);
            return mapping.findForward("basic");
        }
        this.streamToResponse(attachment.getCorrespondence(), StringUtils.replace((String)attachment.getProtocolCorrespondenceType().getDescription(), (String)" ", (String)CONFIRM_NO_ACTION) + ".pdf", "application/pdf", response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private int getSelectedAttachment(HttpServletRequest request) {
        int selectedAttachment = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            String attachmentNumber = StringUtils.substringBetween((String)parameterName, (String)".attachment", (String)".");
            selectedAttachment = Integer.parseInt(attachmentNumber);
        }
        return selectedAttachment;
    }

    private void recordProtocolActionSuccess(String protocolActionName) {
        KNSGlobalVariables.getMessageList().add("message.protocol.action.successfully.completed", new String[]{protocolActionName});
    }

    private ActionForward confirmFollowupAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String forward) throws Exception {
        List validFollowupActions = this.getFollowupActionService().getFollowupsForProtocol(((ProtocolFormBase)form).getProtocolDocument().getProtocol());
        if (validFollowupActions.isEmpty()) {
            LOG.info("No followup action");
            return mapping.findForward(forward);
        }
        if (!((IacucValidProtocolActionAction)validFollowupActions.get(0)).getUserPromptFlag()) {
            this.addFollowupAction(((ProtocolFormBase)form).getProtocolDocument().getProtocol());
            return mapping.findForward(forward);
        }
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_FOLLOWUP_ACTION, "question.protocol.confirmFollowupAction", ((IacucValidProtocolActionAction)validFollowupActions.get(0)).getUserPrompt());
        LOG.info("followup action " + ((IacucValidProtocolActionAction)validFollowupActions.get(0)).getUserPrompt());
        return this.confirm(confirm, CONFIRM_FOLLOWUP_ACTION, CONFIRM_NO_ACTION);
    }

    public ActionForward confirmAddFollowupAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addFollowupAction(((ProtocolFormBase)form).getProtocolDocument().getProtocol());
        return mapping.findForward("basic");
    }

    private void addFollowupAction(ProtocolBase protocol) throws Exception {
        List validFollowupActions = this.getFollowupActionService().getFollowupsForProtocol(protocol);
        protocol.getLastProtocolAction().setFollowupActionCode(((IacucValidProtocolActionAction)validFollowupActions.get(0)).getFollowupActionCode());
        this.getBusinessObjectService().save((PersistableBusinessObject)protocol.getLastProtocolAction());
    }

    private IacucFollowupActionService getFollowupActionService() {
        return KcServiceLocator.getService(IacucFollowupActionService.class);
    }

    private WatermarkService getWatermarkService() {
        return KcServiceLocator.getService(WatermarkService.class);
    }

    public ActionForward viewReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucReviewAttachmentsBean reviewAttachmentsBean = this.getReviewAttachmentsBean(mapping, form, request, response);
        if (reviewAttachmentsBean != null) {
            return this.streamReviewAttachment(mapping, request, response, reviewAttachmentsBean.getReviewAttachments());
        }
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward viewSubmissionReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.streamReviewAttachment(mapping, request, response, ((IacucProtocolForm)form).getActionHelper().getReviewAttachments());
    }

    private ActionForward streamReviewAttachment(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, List<IacucProtocolReviewAttachment> reviewAttachments) throws Exception {
        int lineNumber = this.getLineToDelete(request);
        IacucProtocolReviewAttachment attachment = reviewAttachments.get(lineNumber);
        if (attachment == null) {
            LOG.info(NOT_FOUND_SELECTION + lineNumber);
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), IacucProtocolActionsAction.getValidHeaderString(file.getName()), IacucProtocolActionsAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deleteReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IacucReviewAttachmentsBean reviewAttachmentsBean = this.getReviewAttachmentsBean(mapping, form, request, response);
        if (reviewAttachmentsBean != null) {
            List reviewAttachments = reviewAttachmentsBean.getReviewAttachments();
            int lineNumber = this.getLineToDelete(request);
            List deletedReviewAttachments = reviewAttachmentsBean.getDeletedReviewAttachments();
            this.getReviewCommentsService().deleteReviewAttachment(reviewAttachments, lineNumber, deletedReviewAttachments);
            if (reviewAttachments.isEmpty()) {
                reviewAttachmentsBean.setHideReviewerName(true);
            } else {
                reviewAttachmentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewAttachmentsBean.getReviewAttachments()));
            }
        }
        return mapping.findForward("basic");
    }

    private IacucReviewAttachmentsBean getReviewAttachmentsBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IacucReviewAttachmentsBean reviewAttachmentsBean = null;
        IacucProtocolActionBean protocolActionBean = this.getActionBean(form, request);
        if (protocolActionBean != null && protocolActionBean instanceof ProtocolOnlineReviewCommentable) {
            reviewAttachmentsBean = (IacucReviewAttachmentsBean)((ProtocolOnlineReviewCommentable)((Object)protocolActionBean)).getReviewAttachmentsBean();
        }
        return reviewAttachmentsBean;
    }

    public ActionForward manageAttachments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("protocolManageReviewComments", (IacucProtocol)protocolForm.getProtocolDocument().getProtocol()) && this.applyRules((DocumentEvent)new IacucProtocolManageReviewAttachmentEvent((IacucProtocolDocument)protocolForm.getProtocolDocument(), "actionHelper.protocolManageReviewCommentsBean.reviewAttachmentsBean.", ((IacucReviewAttachmentsBean)protocolForm.getActionHelper().getProtocolManageReviewCommentsBean().getReviewAttachmentsBean()).getReviewAttachments()))) {
                IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolManageReviewCommentsBean();
                this.saveReviewAttachments(protocolForm, (IacucReviewAttachmentsBean)actionBean.getReviewAttachmentsBean());
                this.recordProtocolActionSuccess("Manage Review Attachments");
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    private void saveReviewAttachments(IacucProtocolForm protocolForm, IacucReviewAttachmentsBean actionBean) throws Exception {
        this.getReviewCommentsService().saveReviewAttachments(actionBean.getReviewAttachments(), actionBean.getDeletedReviewAttachments());
        actionBean.setDeletedReviewAttachments(new ArrayList());
        protocolForm.getActionHelper().prepareCommentsView();
    }

    public ActionForward addReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase document = protocolForm.getProtocolDocument();
        IacucReviewAttachmentsBean reviewAttachmentsBean = this.getReviewAttachmentsBean(mapping, form, request, response);
        if (reviewAttachmentsBean != null) {
            String errorPropertyName = reviewAttachmentsBean.getErrorPropertyName();
            IacucProtocolReviewAttachment newReviewAttachment = (IacucProtocolReviewAttachment)reviewAttachmentsBean.getNewReviewAttachment();
            List reviewAttachments = reviewAttachmentsBean.getReviewAttachments();
            ProtocolBase protocol = document.getProtocol();
            if (this.applyRules((DocumentEvent)new IacucProtocolAddReviewAttachmentEvent((IacucProtocolDocument)document, errorPropertyName, newReviewAttachment))) {
                this.getReviewCommentsService().addReviewAttachment(newReviewAttachment, reviewAttachments, protocol);
                reviewAttachmentsBean.setNewReviewAttachment(new IacucProtocolReviewAttachment());
            }
            reviewAttachmentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewAttachmentsBean.getReviewAttachments()));
        }
        return mapping.findForward("basic");
    }

    private boolean hasDocumentStateChanged(IacucProtocolForm protocolForm) {
        return this.getProtocolActionRequestService().hasDocumentStateChanged(protocolForm);
    }

    private ActionForward checkToSendNotification(ActionMapping mapping, String forwardName, IacucProtocolForm protocolForm, IacucProtocolNotificationRequestBean notificationRequestBean) {
        boolean sendNotification = this.getProtocolActionRequestService().checkToSendNotification(protocolForm, notificationRequestBean, forwardName);
        return sendNotification ? mapping.findForward("iacucProtocolNotificationEditor") : mapping.findForward(forwardName);
    }

    public ActionForward sendNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
        IacucProtocolNotificationRenderer renderer = new IacucProtocolNotificationRenderer(protocol);
        IacucProtocolNotificationContext context = new IacucProtocolNotificationContext(protocol, "999", "Ad-Hoc Notification", renderer);
        protocolForm.getNotificationHelper().initializeDefaultValues(context);
        return mapping.findForward("iacucProtocolNotificationEditor");
    }

    @Override
    protected KcNotificationService getNotificationService() {
        return KcServiceLocator.getService(KcNotificationService.class);
    }

    public ActionForward viewCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucActionHelper actionHelper = (IacucActionHelper)((ProtocolFormBase)form).getActionHelper();
        PrintableAttachment source = new PrintableAttachment();
        ProtocolCorrespondence correspondence = actionHelper.getProtocolCorrespondence();
        source.setData(correspondence.getCorrespondence());
        source.setType("application/pdf");
        source.setName("Correspondence-" + correspondence.getProtocolCorrespondenceType().getDescription() + ".pdf");
        PrintingUtils.streamToResponse(source, response);
        return null;
    }

    public ActionForward saveCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.correspondenceAction(mapping, form, true);
    }

    public ActionForward closeCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.correspondenceAction(mapping, form, false);
    }

    private ActionForward correspondenceAction(ActionMapping mapping, ActionForm form, boolean saveAction) {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        ProtocolCorrespondence correspondence = actionHelper.getProtocolCorrespondence();
        if (saveAction) {
            if (correspondence.getFinalFlag()) {
                correspondence.setFinalFlagTimestamp(KcServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)correspondence);
        }
        if (GlobalVariables.getUserSession().retrieveObject("approvalComplCorrespondence") != null) {
            GlobalVariables.getUserSession().addObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY", GlobalVariables.getUserSession().retrieveObject("approvalComplCorrespondence"));
            GlobalVariables.getUserSession().removeObject("approvalComplCorrespondence");
        }
        if (correspondence.getNotificationRequestBean() != null) {
            return this.checkToSendNotification(mapping, correspondence.getForwardName(), protocolForm, (IacucProtocolNotificationRequestBean)correspondence.getNotificationRequestBean());
        }
        if (correspondence.isHoldingPage()) {
            return this.routeProtocolToHoldingPage(mapping, protocolForm);
        }
        return mapping.findForward(correspondence.getForwardName());
    }

    public ActionForward regenerateCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        ProtocolBase protocol = protocolForm.getActionHelper().getProtocol();
        ProtocolActionBase protocolAction = protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        ProtocolCorrespondence protocolCorrespondence = protocolAction.getProtocolCorrespondences().get(attachmentIndex);
        if (protocolCorrespondence == null) {
            LOG.info("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolCorrespondence: " + attachmentIndex);
            return mapping.findForward("basic");
        }
        AttachmentDataSource dataSource = this.generateCorrespondenceDocument(protocol, protocolCorrespondence);
        PrintableAttachment source = new PrintableAttachment();
        if (dataSource != null) {
            protocolCorrespondence.setCorrespondence(dataSource.getData());
            protocolCorrespondence.setFinalFlag(false);
            protocolCorrespondence.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
            protocolCorrespondence.setCreateTimestamp(KcServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
            protocolCorrespondence.setForwardName("iacucProtocolActions");
            protocolForm.getActionHelper().setProtocolCorrespondence(protocolCorrespondence);
            this.getBusinessObjectService().save((PersistableBusinessObject)protocolCorrespondence);
            return mapping.findForward(CORRESPONDENCE);
        }
        return mapping.findForward("basic");
    }

    protected AttachmentDataSource generateCorrespondenceDocument(ProtocolBase protocol, ProtocolCorrespondence oldCorrespondence) throws PrintingException {
        IacucProtocolActionsCorrespondence correspondence = new IacucProtocolActionsCorrespondence(oldCorrespondence.getProtocolAction().getProtocolActionTypeCode());
        correspondence.setProtocol(protocol);
        return this.getProtocolActionCorrespondenceGenerationService().reGenerateCorrespondenceDocument(correspondence);
    }

    private IacucProtocolActionCorrespondenceGenerationService getProtocolActionCorrespondenceGenerationService() {
        return KcServiceLocator.getService(IacucProtocolActionCorrespondenceGenerationService.class);
    }

    public ActionForward updateCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        ProtocolActionBase protocolAction = protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        protocolAction.refreshReferenceObject("protocolCorrespondences");
        ProtocolCorrespondence protocolCorrespondence = protocolAction.getProtocolCorrespondences().get(attachmentIndex);
        if (protocolCorrespondence == null) {
            LOG.info("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolCorrespondence: " + attachmentIndex);
            return mapping.findForward("basic");
        }
        protocolCorrespondence.setForwardName("iacucProtocolActions");
        protocolForm.getActionHelper().setProtocolCorrespondence(protocolCorrespondence);
        return mapping.findForward(CORRESPONDENCE);
    }

    public ActionForward printProtocolSelectedItems(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument ipd = (IacucProtocolDocument)this.getDocumentService().getByDocumentHeaderId(protocolForm.getDocId());
        protocolForm.setDocument((Document)ipd);
        ActionForward forward = mapping.findForward("basic");
        AttachmentDataSource dataStream = this.getIacucProtocolPrintingService().printProtocolSelectedItems(protocolForm);
        if (dataStream.getData() != null) {
            PrintingUtils.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    public ActionForward printProtocolDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AttachmentDataSource dataStream;
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        ActionForward forward = mapping.findForward("basic");
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        if (this.applyRules((DocumentEvent)new ProtocolActionPrintEvent(protocolForm.getProtocolDocument(), actionHelper.getSummaryReport(), actionHelper.getFullReport(), actionHelper.getHistoryReport(), actionHelper.getReviewCommentsReport())) && (dataStream = this.getIacucProtocolPrintingService().printProtocolDocument(protocolForm)).getData() != null) {
            PrintingUtils.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    private IacucProtocolPrintingService getIacucProtocolPrintingService() {
        return KcServiceLocator.getService(IacucProtocolPrintingService.class);
    }

    public ActionForward sendReviewDeterminationNotificationAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        String forwardTo = this.getProtocolActionRequestService().sendReviewDeterminationNotificationAction(protocolForm);
        forward = mapping.findForward(forwardTo);
        return forward;
    }

    public ActionForward modifySubmissionAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        List<ProtocolReviewerBeanBase> reviewers = this.getReviewers(request, "iacucProtocolModifySubmissionBean");
        if (this.getProtocolActionRequestService().isModifySubmissionActionAuthorized(protocolForm, reviewers)) {
            String forwardTo = this.getProtocolActionRequestService().modifySubmissionAction(protocolForm, reviewers);
            GlobalVariables.getMessageMap().getWarningMessages().clear();
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    protected List<ProtocolReviewerBeanBase> getReviewers(HttpServletRequest request, String beanName) {
        String reviewerBean = ACTION_HELPER + beanName + REVIEWER_ATTRIBUTE;
        String numberOfReviewersParam = ACTION_HELPER + beanName + NUMBER_OF_REVIEWERS_ATTRIBUTE;
        int number = Integer.parseInt(request.getParameter(numberOfReviewersParam));
        ArrayList<ProtocolReviewerBeanBase> beans = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = 0; i < number; ++i) {
            String reviewerTypeCode = request.getParameter(reviewerBean + i + REVIEWER_TYPE_CODE_ATTRIBUTE);
            String personId = request.getParameter(reviewerBean + i + PERSON_ID_ATTRIBUTE);
            String fullName = request.getParameter(reviewerBean + i + FULL_NAME_ATTRIBUTE);
            String nonEmployeeFlag = request.getParameter(reviewerBean + i + NON_EMPLOYEE_FLAG_ATTRIBUTE);
            if (!ObjectUtils.isNotNull((Object)personId)) continue;
            IacucProtocolReviewerBean bean = new IacucProtocolReviewerBean();
            bean.setFullName(fullName);
            bean.setPersonId(personId);
            bean.setReviewerTypeCode(reviewerTypeCode);
            bean.setActionFlag("create");
            bean.setNonEmployeeFlag(nonEmployeeFlag.equalsIgnoreCase(TRUE_FLAG));
            beans.add(bean);
        }
        return beans;
    }

    public ActionForward tableProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (this.getProtocolActionRequestService().isTableProtocolAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().tableProtocol(protocolForm);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward undoLastAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            IacucProtocolDocument protocolDocument = (IacucProtocolDocument)protocolForm.getProtocolDocument();
            UndoLastActionBean undoLastActionBean = protocolForm.getActionHelper().getUndoLastActionBean();
            String lastActionType = undoLastActionBean.getLastAction().getProtocolActionTypeCode();
            IacucProtocolUndoLastActionService undoLastActionService = KcServiceLocator.getService(IacucProtocolUndoLastActionService.class);
            ProtocolDocumentBase updatedDocument = undoLastActionService.undoLastAction(protocolDocument, undoLastActionBean);
            this.recordProtocolActionSuccess("Undo Last Action");
            if (!updatedDocument.getDocumentNumber().equals(protocolForm.getDocId())) {
                protocolForm.setDocId(updatedDocument.getDocumentNumber());
                this.loadDocument((KualiDocumentFormBase)protocolForm);
                protocolForm.getProtocolHelper().prepareView();
                return mapping.findForward("iacucProtocol");
            }
            if ("211".equals(lastActionType) || "209".equals(lastActionType)) {
                return this.routeProtocolToHoldingPage(mapping, protocolForm);
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }
}

