/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.protocol.funding;

import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.personnel.IacucProtocolPerson;
import org.kuali.kra.iacuc.personnel.IacucProtocolPersonnelService;
import org.kuali.kra.iacuc.protocol.IacucProtocolNumberService;
import org.kuali.kra.iacuc.protocol.funding.IacucProtocolFundingSourceService;
import org.kuali.kra.iacuc.protocol.funding.IacucProtocolProposalDevelopmentProtocolDocumentService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelService;
import org.kuali.kra.protocol.protocol.funding.impl.ProposalDevelopmentProtocolDocumentServiceImplBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.DocumentService;

public class IacucProtocolProposalDevelopmentProtocolDocumentServiceImpl
extends ProposalDevelopmentProtocolDocumentServiceImplBase<IacucProtocolDocument>
implements IacucProtocolProposalDevelopmentProtocolDocumentService {
    public static final String IACUC_PROTOCOL_CREATED = "IACUC ProtocolBase created";
    public static final String IACUC_PROTOCOL_TYPE_CODE_DEFAULT = "iacuc.protocol.type.code.default";
    public static final String IACUC_PROTOCOL_LAY_STATEMENT1_DEFAULT = "iacuc.protocol.lay.statement1.default";
    private ParameterService parameterService;
    private IacucProtocolPersonnelService iacucProtocolPersonnelService;
    private IacucProtocolFundingSourceService iacucProtocolFundingSourceService;
    private IacucProtocolNumberService iacucProtocolNumberService;

    @Override
    protected IacucProtocolDocument getProtocolDocumentNewInstanceHook(DocumentService documentService) throws WorkflowException {
        return (IacucProtocolDocument)documentService.getNewDocument(IacucProtocolDocument.class);
    }

    @Override
    protected IacucProtocolNumberService getProtocolNumberServiceHook() {
        return this.getIacucProtocolNumberService();
    }

    @Override
    protected String getProtocolActionProtocolCreatedCodeHook() {
        return "100";
    }

    @Override
    protected IacucProtocolAction getProtocolActionNewInstanceHook(ProtocolBase protocol, ProtocolSubmissionBase protocolSubmission, String protocolActionTypeCode) {
        return new IacucProtocolAction((IacucProtocol)protocol, (IacucProtocolSubmission)protocolSubmission, protocolActionTypeCode);
    }

    @Override
    protected String getProtocolAggregatorHook() {
        return "IACUC Protocol Aggregator";
    }

    @Override
    protected String getProtocolApproverHook() {
        return "IACUC ProtocolApprover";
    }

    @Override
    protected String getProtocolRoleTypeHook() {
        return "KC-IACUC";
    }

    @Override
    protected String getProtocolNameSpaceHook() {
        return "KC-IACUC";
    }

    @Override
    protected String getProtocolCreatedHook() {
        return IACUC_PROTOCOL_CREATED;
    }

    @Override
    protected String getSequenceNumberNameHook() {
        return "SEQ_IACUC_PROTOCOL_ID";
    }

    @Override
    protected String getCreateProposalPermissionNamespaceHook() {
        return "KC-IACUC";
    }

    @Override
    protected String getCreateProposalPermissionNameHook() {
        return "Create IACUC Protocol";
    }

    @Override
    protected ProtocolPersonBase getProtocolPersonNewInstanceHook() {
        return new IacucProtocolPerson();
    }

    @Override
    protected ProtocolPersonnelService getProtocolPersonnelServiceHook() {
        return this.getIacucProtocolPersonnelService();
    }

    @Override
    protected IacucProtocolFundingSourceService getProtocolFundingSourceServiceHook() {
        return this.getIacucProtocolFundingSourceService();
    }

    @Override
    protected String getProtocolTypeCodeHook() {
        String parameter = this.parameterService.getParameterValueAsString(IacucProtocolDocument.class, IACUC_PROTOCOL_TYPE_CODE_DEFAULT);
        return parameter;
    }

    @Override
    protected void populateProtocolSpecificFieldsHook(ProtocolBase protocol) {
        String parameter = this.parameterService.getParameterValueAsString(IacucProtocolDocument.class, IACUC_PROTOCOL_LAY_STATEMENT1_DEFAULT);
        IacucProtocol iacucProtocol = (IacucProtocol)protocol;
        iacucProtocol.setLayStatement1(parameter);
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected IacucProtocolPersonnelService getIacucProtocolPersonnelService() {
        return this.iacucProtocolPersonnelService;
    }

    public void setIacucProtocolPersonnelService(IacucProtocolPersonnelService iacucProtocolPersonnelService) {
        this.iacucProtocolPersonnelService = iacucProtocolPersonnelService;
    }

    protected IacucProtocolFundingSourceService getIacucProtocolFundingSourceService() {
        if (this.iacucProtocolFundingSourceService == null) {
            this.iacucProtocolFundingSourceService = KcServiceLocator.getService(IacucProtocolFundingSourceService.class);
        }
        return this.iacucProtocolFundingSourceService;
    }

    public void setIacucProtocolFundingSourceService(IacucProtocolFundingSourceService iacucProtocolFundingSourceService) {
        this.iacucProtocolFundingSourceService = iacucProtocolFundingSourceService;
    }

    protected IacucProtocolNumberService getIacucProtocolNumberService() {
        return this.iacucProtocolNumberService;
    }

    public void setIacucProtocolNumberService(IacucProtocolNumberService iacucProtocolNumberService) {
        this.iacucProtocolNumberService = iacucProtocolNumberService;
    }
}

