/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.personnel;

import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.ProtocolPersonRole;
import org.kuali.kra.irb.personnel.ProtocolPersonRoleMapping;
import org.kuali.kra.irb.personnel.ProtocolPersonnelService;
import org.kuali.kra.irb.personnel.ProtocolUnit;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonRoleBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonRoleMappingBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelServiceImplBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;

public class ProtocolPersonnelServiceImpl
extends ProtocolPersonnelServiceImplBase
implements ProtocolPersonnelService {
    @Override
    protected ProtocolUnitBase createNewProtocolUnitInstanceHook() {
        return new ProtocolUnit();
    }

    @Override
    protected String getSequenceNumberNameHook() {
        return "SEQ_PROTOCOL_ID";
    }

    @Override
    public Class<? extends ProtocolPersonRoleMappingBase> getProtocolPersonRoleMappingClassHook() {
        return ProtocolPersonRoleMapping.class;
    }

    @Override
    public Class<? extends ProtocolPersonRoleBase> getProtocolPersonRoleClassHook() {
        return ProtocolPersonRole.class;
    }

    @Override
    public void setPrincipalInvestigator(ProtocolPersonBase newPrincipalInvestigator, ProtocolBase protocol) {
        if (protocol != null) {
            ProtocolPerson currentPrincipalInvestigator = (ProtocolPerson)this.getPrincipalInvestigator(protocol.getProtocolPersons());
            if (newPrincipalInvestigator != null) {
                newPrincipalInvestigator.setProtocolPersonRoleId(this.getPrincipalInvestigatorRole());
                if (currentPrincipalInvestigator == null) {
                    protocol.getProtocolPersons().add(newPrincipalInvestigator);
                } else if (!this.isDuplicatePerson(protocol.getProtocolPersons(), newPrincipalInvestigator)) {
                    protocol.getProtocolPersons().remove(currentPrincipalInvestigator);
                    protocol.getProtocolPersons().add(newPrincipalInvestigator);
                }
                if (newPrincipalInvestigator.getPersonId() != null && this.shouldPrincipalInvestigatorBeAddedToWorkflow()) {
                    this.personEditableService.populateContactFieldsFromPersonId(newPrincipalInvestigator);
                    KcAuthorizationService kraAuthService = KcServiceLocator.getService(KcAuthorizationService.class);
                    kraAuthService.addDocumentLevelRole(newPrincipalInvestigator.getPersonId(), "ProtocolApprover", protocol);
                } else {
                    this.personEditableService.populateContactFieldsFromRolodexId(newPrincipalInvestigator);
                }
            }
        }
    }

    @Override
    public boolean shouldPrincipalInvestigatorBeAddedToWorkflow() {
        return this.getParameterService().getParameterValueAsBoolean(ProtocolDocument.class, "ASSIGN_PRINCIPAL_INVESTIGATOR_TO_WORKFLOW");
    }

    @Override
    protected boolean isDuplicatePersonAllowed() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PROTOCOL", "Document", "irb.protocol.duplicatePerson.enabled");
    }
}

