/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.rules;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.sponsor.SponsorContract;
import org.kuali.coeus.common.api.sponsor.SponsorService;
import org.kuali.coeus.common.framework.custom.SaveCustomDataEvent;
import org.kuali.coeus.sys.framework.rule.KcDocumentEventBaseExtension;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.bo.NegotiationActivityAttachment;
import org.kuali.kra.negotiations.bo.NegotiationUnassociatedDetail;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.rules.NegotiationActivityAttachmentRuleImpl;
import org.kuali.kra.negotiations.rules.NegotiationActivityRuleImpl;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class NegotiationDocumentRule
extends KcTransactionalDocumentRuleBase {
    private static final String NEGOTIATION_ERROR_PATH = "document.negotiationList[0]";
    private static final String END_DATE_PROPERTY = "negotiationEndDate";
    private static final String NEGOTIATOR_USERNAME_PROPERTY = "negotiatorUserName";
    private static final String ASSOCIATED_DOCMENT_ID = "associatedDocumentId";
    private static final String ACTIVITIES_PREFIX = "activities[";
    private static final String ATTACHMENTS_PREFIX = "attachments[";
    private NegotiationService negotiationService;
    private DataDictionaryService dataDictionaryService;
    private SponsorService sponsorService;

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        if (!(document instanceof NegotiationDocument)) {
            return false;
        }
        NegotiationDocument negotiationDocument = (NegotiationDocument)document;
        Negotiation negotiation = negotiationDocument.getNegotiation();
        boolean result = true;
        result &= this.processRules(new SaveCustomDataEvent(negotiationDocument, true));
        GlobalVariables.getMessageMap().addToErrorPath(NEGOTIATION_ERROR_PATH);
        result &= this.validateEndDate(negotiation);
        result &= this.validateNegotiator(negotiation);
        result &= this.validateNegotiationAssociations(negotiation);
        result &= this.validateNegotiationUnassociatedDetails(negotiation);
        GlobalVariables.getMessageMap().removeFromErrorPath(NEGOTIATION_ERROR_PATH);
        return result &= this.validateNegotiationActivities(negotiation);
    }

    public boolean processRules(KcDocumentEventBaseExtension event) {
        boolean retVal = false;
        retVal = event.getRule().processRules(event);
        return retVal;
    }

    public boolean validateEndDate(Negotiation negotiation) {
        boolean result = true;
        if (negotiation.getNegotiationStatus() != null) {
            if (negotiation.getNegotiationEndDate() != null && this.getNegotiationService().getInProgressStatusCodes().contains(negotiation.getNegotiationStatus().getCode())) {
                result = false;
                this.getErrorReporter().reportError(END_DATE_PROPERTY, "negotiation.error.inprogress.end.date", new String[0]);
            }
            if (negotiation.getNegotiationEndDate() == null && this.getNegotiationService().getCompletedStatusCodes().contains(negotiation.getNegotiationStatus().getCode())) {
                result = false;
                this.getErrorReporter().reportError(END_DATE_PROPERTY, "negotiation.error.completed.end.date", new String[0]);
            }
        }
        if (negotiation.getNegotiationEndDate() != null && negotiation.getNegotiationEndDate().compareTo(negotiation.getNegotiationStartDate()) < 0) {
            result = false;
            this.getErrorReporter().reportError(END_DATE_PROPERTY, "negotiation.error.end.date.greater.than.start", new String[0]);
        }
        return result;
    }

    public boolean validateNegotiator(Negotiation negotiation) {
        boolean result = true;
        if (StringUtils.isBlank((CharSequence)negotiation.getNegotiatorPersonId()) || negotiation.getNegotiator() == null) {
            result = false;
            this.getErrorReporter().reportError(NEGOTIATOR_USERNAME_PROPERTY, "negotiation.error.negotiator", new String[0]);
        }
        return result;
    }

    public boolean validateNegotiationAssociations(Negotiation negotiation) {
        boolean valid = true;
        if (negotiation.getNegotiationAssociationType() != null && !StringUtils.equals((CharSequence)negotiation.getNegotiationAssociationType().getCode(), (CharSequence)"NO") && StringUtils.isEmpty((CharSequence)negotiation.getAssociatedDocumentId())) {
            valid = false;
            this.getErrorReporter().reportError(ASSOCIATED_DOCMENT_ID, "negotiation.warning.associatedid.not.set", negotiation.getNegotiationAssociationType().getDescription());
        }
        return valid;
    }

    public boolean validateNegotiationUnassociatedDetails(Negotiation negotiation) {
        boolean valid = true;
        GlobalVariables.getMessageMap().addToErrorPath("unAssociatedDetail");
        if (negotiation.getNegotiationAssociationType() != null && StringUtils.equals((CharSequence)negotiation.getNegotiationAssociationType().getCode(), (CharSequence)"NO") && negotiation.getUnAssociatedDetail() != null) {
            NegotiationUnassociatedDetail detail = negotiation.getUnAssociatedDetail();
            valid &= this.getDictionaryValidationService().isBusinessObjectValid((Object)detail);
            detail.refreshReferenceObject("sponsor");
            if (detail.getSponsorCode() != null && !this.getSponsorService().isValidSponsor((SponsorContract)detail.getSponsor())) {
                valid = false;
                this.getErrorReporter().reportError("sponsorCode", "error.missing", this.getDataDictionaryService().getAttributeErrorLabel(NegotiationUnassociatedDetail.class, "sponsorCode"));
            }
            detail.refreshReferenceObject("leadUnit");
            if (detail.getLeadUnitNumber() != null && detail.getLeadUnit() == null) {
                valid = false;
                this.getErrorReporter().reportError("leadUnitNumber", "error.missing", this.getDataDictionaryService().getAttributeErrorLabel(NegotiationUnassociatedDetail.class, "leadUnitNumber"));
            }
            detail.refreshReferenceObject("primeSponsor");
            if (detail.getPrimeSponsorCode() != null && !this.getSponsorService().isValidSponsor((SponsorContract)detail.getPrimeSponsor())) {
                valid = false;
                this.getErrorReporter().reportError("primeSponsorCode", "error.missing", this.getDataDictionaryService().getAttributeErrorLabel(NegotiationUnassociatedDetail.class, "primeSponsorCode"));
            }
            detail.refreshReferenceObject("subAwardOrganization");
            if (detail.getSubAwardOrganizationId() != null && detail.getSubAwardOrganization() == null) {
                valid = false;
                this.getErrorReporter().reportError("subAwardOrganizationId", "error.missing", this.getDataDictionaryService().getAttributeErrorLabel(NegotiationUnassociatedDetail.class, "subAwardOrganizationId"));
            }
            if (detail.getContactAdminUserName() != null && detail.getContactAdmin() == null) {
                valid = false;
                this.getErrorReporter().reportError("contactAdminUserName", "error.missing", this.getDataDictionaryService().getAttributeErrorLabel(NegotiationUnassociatedDetail.class, "contactAdminPersonId"));
            }
            if (detail.getPiEmployeeUserName() != null && detail.getPIEmployee() == null) {
                valid = false;
                this.getErrorReporter().reportError("piEmployeeUserName", "error.missing", this.getDataDictionaryService().getAttributeErrorLabel(NegotiationUnassociatedDetail.class, "piPersonId"));
            }
            if (detail.getPIEmployee() != null && detail.getPINonEmployee() != null) {
                valid = false;
                this.getErrorReporter().reportError("piEmployeeUserName", "negotiation.error.multiplePi", this.getDataDictionaryService().getAttributeErrorLabel(NegotiationUnassociatedDetail.class, "piPersonId"));
            }
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("unAssociatedDetail");
        return valid;
    }

    public boolean validateNegotiationActivities(Negotiation negotiation) {
        boolean result = true;
        int index = 0;
        NegotiationActivityRuleImpl rule = new NegotiationActivityRuleImpl();
        for (NegotiationActivity activity : negotiation.getActivities()) {
            GlobalVariables.getMessageMap().addToErrorPath(ACTIVITIES_PREFIX + index + "]");
            result &= rule.validateNegotiationActivity(activity, negotiation);
            result &= this.validateActivityAttachments(negotiation, activity);
            GlobalVariables.getMessageMap().removeFromErrorPath(ACTIVITIES_PREFIX + index + "]");
            ++index;
        }
        return result;
    }

    public boolean validateActivityAttachments(Negotiation negotiation, NegotiationActivity activity) {
        boolean result = true;
        int index = 0;
        NegotiationActivityAttachmentRuleImpl rule = new NegotiationActivityAttachmentRuleImpl();
        for (NegotiationActivityAttachment attachment : activity.getAttachments()) {
            GlobalVariables.getMessageMap().addToErrorPath(ATTACHMENTS_PREFIX + index + "]");
            result &= rule.validateAttachmentRule(negotiation, activity, attachment);
            GlobalVariables.getMessageMap().removeFromErrorPath(ATTACHMENTS_PREFIX + index + "]");
            ++index;
        }
        return result;
    }

    protected NegotiationService getNegotiationService() {
        if (this.negotiationService == null) {
            this.negotiationService = KcServiceLocator.getService(NegotiationService.class);
        }
        return this.negotiationService;
    }

    public void setNegotiationService(NegotiationService negotiationService) {
        this.negotiationService = negotiationService;
    }

    public DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KcServiceLocator.getService(DataDictionaryService.class);
        }
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public SponsorService getSponsorService() {
        if (this.sponsorService == null) {
            this.sponsorService = KcServiceLocator.getService(SponsorService.class);
        }
        return this.sponsorService;
    }

    public void setSponsorService(SponsorService sponsorService) {
        this.sponsorService = sponsorService;
    }
}

