/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport;

import java.sql.SQLException;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.dbsupport.SqlStatement;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.scanner.Resource;

public class FlywaySqlScriptException
extends FlywayException {
    private final Resource resource;
    private final SqlStatement statement;

    public FlywaySqlScriptException(Resource resource, SqlStatement statement, SQLException sqlException) {
        super(sqlException);
        this.resource = resource;
        this.statement = statement;
    }

    public int getLineNumber() {
        return this.statement.getLineNumber();
    }

    public String getStatement() {
        return this.statement.getSql();
    }

    @Override
    public String getMessage() {
        String title = this.resource == null ? "Script failed" : "Migration " + this.resource.getFilename() + " failed";
        String underline = StringUtils.trimOrPad("", title.length(), '-');
        SQLException cause = (SQLException)this.getCause();
        while (cause.getNextException() != null) {
            cause = cause.getNextException();
        }
        String message = "\n" + title + "\n" + underline + "\n";
        message = message + "SQL State  : " + cause.getSQLState() + "\n";
        message = message + "Error Code : " + cause.getErrorCode() + "\n";
        message = message + "Message    : " + cause.getMessage() + "\n";
        if (this.resource != null) {
            message = message + "Location   : " + this.resource.getLocation() + " (" + this.resource.getLocationOnDisk() + ")\n";
        }
        message = message + "Line       : " + this.getLineNumber() + "\n";
        message = message + "Statement  : " + this.getStatement() + "\n";
        return message;
    }
}

