/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.util.Map;
import java.util.Properties;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.SequenceDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.util.sequence.SequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;
import org.apache.ojb.broker.util.sequence.SequenceManagerHelper;

public abstract class AbstractSequenceManager
implements SequenceManager {
    public static final String PROPERTY_AUTO_NAMING = "autoNaming";
    protected static final String GLOBAL_SEQUENCE_NAME = "ojb.global.sequence";
    private PersistenceBroker brokerForClass;
    private Platform platform;
    private Properties configurationProperties;

    public AbstractSequenceManager(PersistenceBroker persistenceBroker) {
        this.brokerForClass = persistenceBroker;
        this.configurationProperties = new Properties();
        this.platform = this.brokerForClass.serviceConnectionManager().getSupportedPlatform();
        SequenceDescriptor sequenceDescriptor = this.brokerForClass.serviceConnectionManager().getConnectionDescriptor().getSequenceDescriptor();
        if (sequenceDescriptor != null) {
            this.configurationProperties.putAll((Map<?, ?>)sequenceDescriptor.getConfigurationProperties());
        }
    }

    protected abstract long getUniqueLong(FieldDescriptor var1) throws SequenceManagerException;

    public Platform getPlatform() {
        return this.platform;
    }

    public PersistenceBroker getBrokerForClass() {
        return this.brokerForClass;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(Properties properties) {
        this.configurationProperties.putAll((Map<?, ?>)properties);
    }

    public String getConfigurationProperty(String string, String string2) {
        String string3 = this.configurationProperties.getProperty(string);
        return string3 != null ? string3 : string2;
    }

    public void setConfigurationProperty(String string, String string2) {
        this.configurationProperties.setProperty(string, string2);
    }

    public boolean useAutoNaming() {
        return Boolean.valueOf(this.getConfigurationProperty(PROPERTY_AUTO_NAMING, "true"));
    }

    public String calculateSequenceName(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        String string = fieldDescriptor.getSequenceName();
        if (string == null) {
            string = SequenceManagerHelper.buildSequenceName(this.getBrokerForClass(), fieldDescriptor, this.useAutoNaming());
        }
        return string;
    }

    @Override
    public Object getUniqueValue(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        Object object = fieldDescriptor.getJdbcType().sequenceKeyConversion(new Long(this.getUniqueLong(fieldDescriptor)));
        object = fieldDescriptor.getFieldConversion().sqlToJava(object);
        return object;
    }

    @Override
    public void afterStore(JdbcAccess jdbcAccess, ClassDescriptor classDescriptor, Object object) throws SequenceManagerException {
    }

    public void setReferenceFKs(Object object, ClassDescriptor classDescriptor) throws SequenceManagerException {
    }
}

