/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.onlinereview.authorization;

import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReview;
import org.kuali.kra.iacuc.onlinereview.authorization.IacucProtocolOnlineReviewAuthorizer;
import org.kuali.kra.iacuc.onlinereview.authorization.IacucProtocolOnlineReviewTask;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public class ModifyIacucProtocolOnlineReviewDeterminationAuthorizer
extends IacucProtocolOnlineReviewAuthorizer {
    private static final Logger LOG = LogManager.getLogger(ModifyIacucProtocolOnlineReviewDeterminationAuthorizer.class);
    private KcWorkflowService kraWorkflowService;

    @Override
    public boolean isAuthorized(String userId, IacucProtocolOnlineReviewTask task) {
        boolean hasPermission = false;
        IacucProtocolOnlineReview protocolOnlineReview = (IacucProtocolOnlineReview)task.getProtocolOnlineReview();
        ProtocolOnlineReviewDocumentBase protocolDoc = null;
        try {
            protocolDoc = (ProtocolOnlineReviewDocumentBase)KcServiceLocator.getService(DocumentService.class).getByDocumentHeaderId(protocolOnlineReview.getProtocolOnlineReviewDocument().getDocumentNumber());
            if (protocolOnlineReview.getProtocolOnlineReviewId() != null && !protocolOnlineReview.getProtocolOnlineReviewDocument().isViewOnly()) {
                if (this.hasPermission(userId, protocolOnlineReview, "Maintain IACUC Protocol Online Reviews") && !protocolDoc.getDocumentHeader().getWorkflowDocument().isFinal()) {
                    hasPermission = true;
                } else if (this.hasPermission(userId, protocolOnlineReview, "Maintain IACUC Protocol Online Review Comments") && this.kraWorkflowService.isUserApprovalRequested((Document)protocolDoc, userId)) {
                    String reviewerTypeCode = protocolOnlineReview.getProtocolReviewer().getReviewerTypeCode();
                    if (StringUtils.equals((CharSequence)reviewerTypeCode, (CharSequence)"1") || StringUtils.equals((CharSequence)reviewerTypeCode, (CharSequence)"2")) {
                        hasPermission = true;
                    } else if (StringUtils.equals((CharSequence)reviewerTypeCode, (CharSequence)"3")) {
                        if (protocolOnlineReview.getDeterminationReviewDateDue() != null) {
                            Calendar today = Calendar.getInstance();
                            Calendar typeDueDate = Calendar.getInstance();
                            typeDueDate.setTime(protocolOnlineReview.getDeterminationReviewDateDue());
                            hasPermission = typeDueDate.before(today);
                        } else {
                            hasPermission = true;
                        }
                    }
                }
            }
        }
        catch (WorkflowException e) {
            LOG.error(String.format("Could not find ProtocolOnlineReviewBase, document number %s", protocolOnlineReview.getProtocolOnlineReviewDocument().getDocumentNumber()));
        }
        return hasPermission;
    }

    public KcWorkflowService getKraWorkflowService() {
        return this.kraWorkflowService;
    }

    public void setKraWorkflowService(KcWorkflowService kraWorkflowService) {
        this.kraWorkflowService = kraWorkflowService;
    }
}

