--
-- Copyright © 2005-2019 Kuali, Inc.
-- All Rights Reserved
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
--

DELIMITER /
CREATE PROCEDURE subaward_po_changes()
BEGIN
    DECLARE CURSOR_DONE INT DEFAULT FALSE;

    DECLARE V_SUBAWARD_AMOUNT_INFO_ID DECIMAL(12, 0);
    DECLARE V_SUBAWARD_ID DECIMAL(12, 0);
    DECLARE V_SUBAWARD_CODE VARCHAR(20);
    DECLARE V_SEQUENCE_NUMBER DECIMAL(4, 0);
    DECLARE V_START_DATE DATE;
    DECLARE V_DATE_OF_FULLY_EXECUTED DATE;
    DECLARE V_PURCHASE_ORDER_NUM VARCHAR(10);

    DECLARE COUNTER INT DEFAULT 0;

    DECLARE MAIN_CUR CURSOR FOR select max(subaward_amount_info_id) as subaward_amount_info_id, subaward_id
                                from subaward_amount_info
                                group by subaward_id;

    DECLARE NOSAI_CUR CURSOR FOR select subaward_id,
                                        subaward_code,
                                        sequence_number,
                                        start_date,
                                        date_of_fully_executed,
                                        purchase_order_num
                                 from subaward s
                                 where PURCHASE_ORDER_NUM is not null
                                   and (select count(*) from subaward_amount_info where subaward_id = s.subaward_id) = 0
                                   and subaward_sequence_status IN ('ACTIVE', 'PENDING');

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET CURSOR_DONE = TRUE;

    OPEN MAIN_CUR;

    main_loop:
        LOOP
            FETCH MAIN_CUR INTO V_SUBAWARD_AMOUNT_INFO_ID, V_SUBAWARD_ID;
            IF CURSOR_DONE THEN
                LEAVE main_loop;
            END IF;

            UPDATE subaward_amount_info
            SET PURCHASE_ORDER_NUM = (SELECT PURCHASE_ORDER_NUM FROM subaward WHERE subaward_id = V_SUBAWARD_ID)
            WHERE subaward_amount_info_id = V_SUBAWARD_AMOUNT_INFO_ID;

            IF COUNTER >= 500 THEN
                COMMIT;
                SET COUNTER = 1;
            ELSE
                SET COUNTER = COUNTER + 1;
            END IF;
        END LOOP;

    SET CURSOR_DONE = FALSE;
    OPEN NOSAI_CUR;

    nosai_loop:
        LOOP
            FETCH NOSAI_CUR INTO V_SUBAWARD_ID, V_SUBAWARD_CODE, V_SEQUENCE_NUMBER, V_START_DATE, V_DATE_OF_FULLY_EXECUTED, V_PURCHASE_ORDER_NUM;
            IF CURSOR_DONE THEN
                LEAVE nosai_loop;
            END IF;

            INSERT INTO SUBAWARD_AMT_INFO_ID_S VALUES (NULL);

            INSERT INTO subaward_amount_info (SUBAWARD_AMOUNT_INFO_ID,
                                              SUBAWARD_ID,
                                              OBLIGATED_AMOUNT,
                                              OBLIGATED_CHANGE,
                                              ANTICIPATED_AMOUNT,
                                              ANTICIPATED_CHANGE,
                                              EFFECTIVE_DATE,
                                              UPDATE_TIMESTAMP,
                                              UPDATE_USER,
                                              OBJ_ID,
                                              SEQUENCE_NUMBER,
                                              SUBAWARD_CODE,
                                              PURCHASE_ORDER_NUM)
            values ((SELECT (MAX(ID)) FROM SUBAWARD_AMT_INFO_ID_S),
                    V_SUBAWARD_ID,
                    0,
                    0,
                    0,
                    0,
                    IFNULL(V_DATE_OF_FULLY_EXECUTED, IFNULL(V_START_DATE, '1900-01-01')),
                    NOW(),
                    'admin',
                    UUID(),
                    V_SEQUENCE_NUMBER,
                    V_SUBAWARD_CODE,
                    V_PURCHASE_ORDER_NUM);

            IF COUNTER >= 500 THEN
                COMMIT;
                SET COUNTER = 1;
            ELSE
                SET COUNTER = COUNTER + 1;
            END IF;
        END LOOP;

    COMMIT;

END
/
DELIMITER ;

ALTER TABLE subaward_amount_info
    ADD COLUMN `PURCHASE_ORDER_NUM` varchar(10) DEFAULT NULL;

CALL subaward_po_changes();

drop PROCEDURE if exists subaward_po_changes;

insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
values ('RES-BOOT10049', 'KC-SUBAWARD', 'purchaseOrderOnActiveEntryIsNotNull',
        'Purchase Order on the Active Entry is not null', 'java.lang.Boolean', 'KC1013', 'Y', 1);

insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10092', 'SubAward', 'Sub Award BO', 'org.kuali.kra.subaward.bo.SubAward', 'RES-BOOT10049', 1);

insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
values ('RES-BOOT2132', 'RES-BOOT10049', 'java.lang.Boolean', 'Y', 1, 'Purchase Order on the Active Entry is not null',
        'KC-SUBAWARD');

insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
values ('RES-BOOT2119', 'KC-SUBAWARD', 'Purchase Order on the Active Entry is not null Resolver', 'KC1001',
        'RES-BOOT2132', 'Y', 1);

insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
values ('RES-BOOT1072', 'KC-SUBAWARD-CONTEXT', 'RES-BOOT2132', 'Y');

insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
values ('RES-BOOT2132', 'KC1019');

insert into krms_term_t (term_id, term_spec_id, ver_nbr, desc_txt)
values ('RES-BOOT10025', 'RES-BOOT2132', '1', 'Check if Purchase Order on the Active Entry is not null');
