/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person.citi;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.person.citi.CitiDataLoadingService;
import org.kuali.coeus.common.framework.person.citi.PersonTrainingCitiRecord;
import org.kuali.coeus.common.framework.person.citi.PersonTrainingCitiRecordError;
import org.kuali.coeus.common.framework.person.citi.PersonTrainingCitiRecordStatus;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="citiDataLoadingService")
public class CitiDataLoadingServiceImpl
implements CitiDataLoadingService {
    private static final Logger LOG = LogManager.getLogger(CitiDataLoadingServiceImpl.class);
    private static final Pattern COMMA_REGEX = Pattern.compile(",");
    private static final String CITI_ENDPOINTS = "citi.endpoints";
    private static final String CITI_DELIMETER = "citi.delimiter";
    private static final String CITI_HEADER_LABEL_PREFIX = "citi.header.label.";
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    @Override
    public void loadRecords() {
        String citiEndpoints = this.getConfigurationService().getPropertyValueAsString(CITI_ENDPOINTS);
        if (StringUtils.isNotEmpty((CharSequence)citiEndpoints)) {
            this.getBusinessObjectService().deleteMatching(PersonTrainingCitiRecordError.class, Collections.emptyMap());
            this.getBusinessObjectService().deleteMatching(PersonTrainingCitiRecord.class, Collections.emptyMap());
            char citiDelimiter = this.getConfigurationService().getPropertyValueAsString(CITI_DELIMETER).charAt(0);
            Map headerMap = this.getConfigurationService().getAllProperties().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(CITI_HEADER_LABEL_PREFIX)).collect(CollectionUtils.entriesToMap());
            COMMA_REGEX.splitAsStream(citiEndpoints).map(String::trim).map(endpoint -> (String)this.getRestOperations().getForObject(endpoint, String.class, new Object[0])).forEach(records -> {
                try (StringReader reader = new StringReader((String)records);){
                    CSVParser parser = CSVFormat.DEFAULT.withDelimiter(citiDelimiter).withFirstRecordAsHeader().withAllowMissingColumnNames(true).withIgnoreEmptyLines(true).withIgnoreHeaderCase(true).withIgnoreSurroundingSpaces(true).withTrim(true).withQuote(null).parse((Reader)reader);
                    this.processRecords(headerMap, parser.iterator());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    protected void processRecords(Map<String, String> headerMap, Iterator<CSVRecord> records) {
        StreamSupport.stream(((Iterable)() -> records).spliterator(), false).map(record -> {
            PersonTrainingCitiRecord sr = new PersonTrainingCitiRecord();
            sr.setStatusCode(PersonTrainingCitiRecordStatus.STAGED.getCode());
            try {
                BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)sr);
                wrapper.registerCustomEditor(Timestamp.class, (PropertyEditor)new CitiTimestampEditor());
                headerMap.entrySet().stream().filter(e -> record.isMapped((String)e.getValue())).forEach(arg_0 -> CitiDataLoadingServiceImpl.lambda$processRecords$5((BeanWrapper)wrapper, record, arg_0));
            }
            catch (RuntimeException e2) {
                sr.addError(new PersonTrainingCitiRecordError(e2.getMessage()));
                LOG.error(record.toString() + " has an error", (Throwable)e2);
            }
            sr.setRawRecord(record.toString());
            return sr;
        }).forEach(sr -> {
            try {
                this.getBusinessObjectService().save((PersistableBusinessObject)sr);
            }
            catch (Exception ex) {
                this.recordErrors((PersonTrainingCitiRecord)sr, ex.getMessage());
                LOG.error(sr.toString() + " has an error", (Throwable)ex);
            }
        });
    }

    protected void recordErrors(PersonTrainingCitiRecord currentPersonTrainingCitiRecord, String errorMessage) {
        int firstNameMaxLength = 40;
        int lastNameMaxLength = 80;
        PersonTrainingCitiRecord newPersonTrainingCitiRecord = new PersonTrainingCitiRecord();
        newPersonTrainingCitiRecord.setStatusCode(PersonTrainingCitiRecordStatus.ERRORED.getCode());
        newPersonTrainingCitiRecord.setFirstName(StringUtils.substring((String)currentPersonTrainingCitiRecord.getFirstName(), (int)firstNameMaxLength));
        newPersonTrainingCitiRecord.setLastName(StringUtils.substring((String)currentPersonTrainingCitiRecord.getLastName(), (int)lastNameMaxLength));
        newPersonTrainingCitiRecord.addError(new PersonTrainingCitiRecordError(errorMessage));
        try {
            this.getBusinessObjectService().save((PersistableBusinessObject)newPersonTrainingCitiRecord);
        }
        catch (Exception ex) {
            LOG.error(newPersonTrainingCitiRecord.toString() + " has an error", (Throwable)ex);
        }
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    private static /* synthetic */ void lambda$processRecords$5(BeanWrapper wrapper, CSVRecord record, Map.Entry e) {
        wrapper.setPropertyValue(((String)e.getKey()).replace(CITI_HEADER_LABEL_PREFIX, ""), (Object)record.get((String)e.getValue()));
    }

    private static class CitiTimestampEditor
    extends PropertyEditorSupport {
        private static final String TIMESTAMP_FORMAT1 = "MM/d/yyyy h:m:s a";
        private static final String TIMESTAMP_FORMAT2 = "MM/dd/yy";

        private CitiTimestampEditor() {
        }

        @Override
        public void setAsText(String value) {
            this.setValue(value);
        }

        @Override
        public Object getValue() {
            Date date;
            if (super.getValue() == null || StringUtils.isBlank((CharSequence)super.getValue().toString())) {
                return null;
            }
            SimpleDateFormat format1 = new SimpleDateFormat(TIMESTAMP_FORMAT1);
            try {
                date = format1.parse(super.getValue().toString());
            }
            catch (ParseException e) {
                SimpleDateFormat format2 = new SimpleDateFormat(TIMESTAMP_FORMAT2);
                try {
                    date = format2.parse(super.getValue().toString());
                }
                catch (ParseException e1) {
                    throw new RuntimeException(e);
                }
            }
            return new Timestamp(date.getTime());
        }
    }
}

