/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.lookup.LookupControllerService;
import org.kuali.rice.krad.lookup.LookupForm;
import org.kuali.rice.krad.lookup.LookupUtils;
import org.kuali.rice.krad.lookup.Lookupable;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.UrlFactory;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.kuali.rice.krad.web.service.impl.ControllerServiceImpl;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public class LookupControllerServiceImpl
extends ControllerServiceImpl
implements LookupControllerService {
    private ModelAndViewService modelAndViewService;

    @Override
    public ModelAndView start(UifFormBase form) {
        ModelAndView redirectModelAndView;
        LookupForm lookupForm = (LookupForm)form;
        Lookupable lookupable = lookupForm.getLookupable();
        if (lookupable == null) {
            throw new RuntimeException("Lookupable is null");
        }
        HttpServletRequest request = form.getRequest();
        if (request.getParameter("messageToDisplay") != null) {
            GlobalVariables.getMessageMap().putErrorForSectionId("LookupResultMessages", request.getParameter("messageToDisplay"), new String[0]);
        }
        if (!lookupForm.isRedirectedLookup() && (redirectModelAndView = this.checkForModuleLookupRedirect(lookupForm, request)) != null) {
            return redirectModelAndView;
        }
        String dialogId = request.getParameter("dialogId");
        if (dialogId != null) {
            lookupForm.setShowDialogId(dialogId);
        }
        return super.start(lookupForm);
    }

    protected ModelAndView checkForModuleLookupRedirect(LookupForm lookupForm, HttpServletRequest request) {
        Class<?> lookupObjectClass;
        try {
            lookupObjectClass = Class.forName(lookupForm.getDataObjectClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RiceRuntimeException("Unable to get class for name: " + lookupForm.getDataObjectClassName(), (Throwable)e);
        }
        ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(lookupObjectClass);
        if (responsibleModuleService != null && responsibleModuleService.isExternalizable(lookupObjectClass)) {
            String lookupUrl = responsibleModuleService.getExternalizableDataObjectLookupUrl(lookupObjectClass, KRADUtils.convertRequestMapToProperties(request.getParameterMap()));
            Properties redirectUrlProps = new Properties();
            redirectUrlProps.setProperty("redirectedLookup", "true");
            GlobalVariables.getUifFormManager().removeSessionForm(lookupForm);
            return this.getModelAndViewService().performRedirect(lookupForm, lookupUrl, redirectUrlProps);
        }
        return null;
    }

    @Override
    public ModelAndView search(LookupForm lookupForm) {
        Lookupable lookupable = lookupForm.getLookupable();
        if (lookupable == null) {
            throw new RuntimeException("Lookupable is null.");
        }
        Collection<?> displayList = lookupable.performSearch(lookupForm, lookupForm.getLookupCriteria(), true);
        lookupForm.setLookupResults(displayList);
        return this.getModelAndViewService().getModelAndView(lookupForm);
    }

    @Override
    public ModelAndView clearValues(LookupForm lookupForm) {
        Lookupable lookupable = lookupForm.getLookupable();
        if (lookupable == null) {
            throw new RuntimeException("Lookupable is null.");
        }
        Map<String, String> resetLookupCriteria = lookupable.performClear(lookupForm, lookupForm.getLookupCriteria());
        lookupForm.setLookupCriteria(resetLookupCriteria);
        return this.getModelAndViewService().getModelAndView(lookupForm);
    }

    @Override
    public ModelAndView selectAllPages(LookupForm lookupForm) {
        List lookupResults = (List)lookupForm.getLookupResults();
        ArrayList<String> fromFieldNames = new ArrayList<String>(lookupForm.getFieldConversions().keySet());
        HashSet<String> selectedValues = new HashSet<String>();
        for (Object lineItem : lookupResults) {
            String lineIdentifier = LookupUtils.generateMultiValueKey(lineItem, fromFieldNames);
            selectedValues.add(lineIdentifier);
        }
        lookupForm.setSelectedLookupResultsCache(selectedValues);
        return this.getModelAndViewService().getModelAndView(lookupForm);
    }

    @Override
    public ModelAndView deselectAllPages(LookupForm lookupForm) {
        lookupForm.getSelectedLookupResultsCache().clear();
        Set<String> selectedLines = lookupForm.getSelectedCollectionLines().get("lookupResults");
        if (selectedLines != null) {
            selectedLines.clear();
        }
        return this.getModelAndViewService().getModelAndView(lookupForm);
    }

    @Override
    public String returnSelected(LookupForm lookupForm, RedirectAttributes redirectAttributes) {
        boolean urlGreaterThanMaxLength;
        LookupUtils.refreshLookupResultSelections(lookupForm);
        Properties urlParams = this.buildReturnSelectedParameters(lookupForm);
        String returnUrl = UrlFactory.parameterizeUrl((String)lookupForm.getReturnLocation(), (Properties)urlParams);
        boolean lookupCameFromDifferentServer = KRADUtils.areDifferentDomains(lookupForm.getReturnLocation(), lookupForm.getRequestUrl());
        boolean bl = urlGreaterThanMaxLength = returnUrl.length() > 2048;
        if (urlGreaterThanMaxLength) {
            urlParams.remove("selectedLineValues");
            if (lookupCameFromDifferentServer) {
                urlParams.setProperty("refreshStatus", "ERROR");
                urlParams.setProperty("messageToDisplay", "lookup.results.exceeds.mv.return.limit");
            } else {
                String selectedLineValues = this.getSelectedLineValues(lookupForm);
                redirectAttributes.addFlashAttribute("selectedLineValues", (Object)selectedLineValues);
            }
        }
        GlobalVariables.getUifFormManager().removeSessionForm(lookupForm);
        returnUrl = UrlFactory.parameterizeUrl((String)lookupForm.getReturnLocation(), (Properties)urlParams);
        return "redirect:" + returnUrl;
    }

    protected Properties buildReturnSelectedParameters(LookupForm lookupForm) {
        Properties parameters = new Properties();
        parameters.setProperty("methodToCall", "refresh");
        parameters.setProperty("refreshCallerType", "MULTI_VALUE_LOOKUP");
        if (StringUtils.isNotBlank((String)lookupForm.getView().getId())) {
            parameters.setProperty("refreshCaller", lookupForm.getView().getId());
        }
        if (StringUtils.isNotBlank((String)lookupForm.getDataObjectClassName())) {
            parameters.setProperty("refreshDataObjectClass", lookupForm.getDataObjectClassName());
        }
        if (StringUtils.isNotBlank((String)lookupForm.getReturnFormKey())) {
            parameters.setProperty("formKey", lookupForm.getReturnFormKey());
        }
        String multiValueReturnFieldsParam = this.getMultiValueReturnFields(lookupForm);
        parameters.setProperty("multiValueReturnFields", multiValueReturnFieldsParam);
        String selectedLineValues = this.getSelectedLineValues(lookupForm);
        parameters.setProperty("selectedLineValues", selectedLineValues);
        if (StringUtils.isNotBlank((String)lookupForm.getQuickfinderId())) {
            parameters.setProperty("quickfinderId", lookupForm.getQuickfinderId());
        }
        if (StringUtils.isNotBlank((String)lookupForm.getLookupCollectionName())) {
            parameters.setProperty("lookupCollectionName", lookupForm.getLookupCollectionName());
        }
        if (StringUtils.isNotBlank((String)lookupForm.getLookupCollectionId())) {
            parameters.setProperty("lookupCollectionId", lookupForm.getLookupCollectionId());
        }
        if (StringUtils.isNotBlank((String)lookupForm.getReferencesToRefresh())) {
            parameters.setProperty("referencesToRefresh", lookupForm.getReferencesToRefresh());
        }
        if (StringUtils.isNotBlank((String)lookupForm.getShowDialogId())) {
            parameters.setProperty("dialogId", lookupForm.getShowDialogId());
        }
        return parameters;
    }

    protected String getMultiValueReturnFields(LookupForm lookupForm) {
        Object multiValueReturnFieldsParam = "";
        List<String> multiValueReturnFields = lookupForm.getMultiValueReturnFields();
        Collections.sort(multiValueReturnFields);
        if (multiValueReturnFields != null && !multiValueReturnFields.isEmpty()) {
            for (String field : multiValueReturnFields) {
                multiValueReturnFieldsParam = (String)multiValueReturnFieldsParam + field + ",";
            }
            multiValueReturnFieldsParam = StringUtils.removeEnd((String)multiValueReturnFieldsParam, (String)",");
        }
        return multiValueReturnFieldsParam;
    }

    protected String getSelectedLineValues(LookupForm lookupForm) {
        Object selectedLineValues = "";
        Set<String> selectedLines = lookupForm.getSelectedCollectionLines().get("lookupResults");
        if (selectedLines != null) {
            for (String selectedLine : selectedLines) {
                selectedLineValues = (String)selectedLineValues + selectedLine + ",";
            }
            selectedLineValues = StringUtils.removeEnd((String)selectedLineValues, (String)",");
        }
        return selectedLineValues;
    }

    @Override
    protected ModelAndViewService getModelAndViewService() {
        return this.modelAndViewService;
    }

    @Override
    public void setModelAndViewService(ModelAndViewService modelAndViewService) {
        this.modelAndViewService = modelAndViewService;
    }
}

