/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.ken.api.notification.Notification;
import org.kuali.rice.ken.api.notification.NotificationResponse;
import org.kuali.rice.ken.api.service.SendNotificationService;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationResponseBo;
import org.kuali.rice.ken.service.NotificationService;
import org.kuali.rice.kew.api.WorkflowRuntimeException;

public class SendNotificationServiceKewXmlImpl
implements SendNotificationService {
    private static Logger LOG = LogManager.getLogger(SendNotificationServiceKewXmlImpl.class);
    private final NotificationService notificationService;

    public SendNotificationServiceKewXmlImpl(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public NotificationResponse invoke(String message) {
        if (StringUtils.isBlank((String)message)) {
            throw new RiceIllegalArgumentException("xml is null or blank");
        }
        try {
            NotificationResponseBo response = this.notificationService.sendNotification(message);
            LOG.info(response.getMessage());
            return NotificationResponseBo.to(response);
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    public NotificationResponse sendNotification(Notification notification) {
        if (null == notification) {
            throw new RiceIllegalArgumentException("xml is null or blank");
        }
        try {
            NotificationBo notificationBo = NotificationBo.from(notification);
            NotificationResponseBo response = this.notificationService.sendNotification(notificationBo);
            LOG.info(response.getMessage());
            return NotificationResponseBo.to(response);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

