/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.customdata;

import java.util.Collection;
import java.util.HashMap;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.common.framework.custom.CustomDataHelperBase;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class ProtocolCustomDataHelperBase<T extends DocumentCustomData>
extends CustomDataHelperBase<T> {
    private static final long serialVersionUID = -3821021799847248950L;
    protected ProtocolFormBase form;
    private transient BusinessObjectService businessObjectService;
    private transient TaskAuthorizationService taskAuthorizationService;

    public ProtocolCustomDataHelperBase(ProtocolFormBase form) {
        this.form = form;
    }

    protected ProtocolBase getProtocol() {
        ProtocolDocumentBase document = this.form.getProtocolDocument();
        if (document == null || document.getProtocol() == null) {
            throw new IllegalArgumentException("invalid (null) ProtocolDocumentBase in ProtocolFormBase");
        }
        return document.getProtocol();
    }

    public boolean canDisplayCustomDataTab() {
        boolean localCustomData = this.getCustomAttributeGroups().size() > 0;
        boolean anyProtocolAttr = this.areThereAnyProtocolCustomAttributes();
        return localCustomData || anyProtocolAttr;
    }

    private boolean areThereAnyProtocolCustomAttributes() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("DOCUMENT_TYPE_CODE", this.getDocumentTypeCode());
        fieldValues.put("ACTIVE_FLAG", "Y");
        Collection documents = this.getBusinessObjectService().findMatching(CustomAttributeDocument.class, fieldValues);
        return documents.size() > 0;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    @Override
    public abstract boolean canModifyCustomData();

    @Override
    protected TaskAuthorizationService getTaskAuthorizationService() {
        if (this.taskAuthorizationService == null) {
            this.taskAuthorizationService = KcServiceLocator.getService(TaskAuthorizationService.class);
        }
        return this.taskAuthorizationService;
    }

    protected String getDocumentTypeCode() {
        return this.form.getProtocolDocument().getDocumentTypeCode();
    }

    @Override
    public boolean documentNotRouted() {
        WorkflowDocument doc = this.form.getProtocolDocument().getDocumentHeader().getWorkflowDocument();
        return doc.isSaved() || doc.isInitiated();
    }
}

