/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.ObjectCacheEmptyImpl;
import org.apache.ojb.broker.cache.ObjectCacheInternal;
import org.apache.ojb.broker.metadata.ObjectCacheDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

class CacheDistributor
implements ObjectCacheInternal {
    private static Logger log = LoggerFactory.getLogger(CacheDistributor.class);
    private static final String DESCRIPTOR_BASED_CACHES = "descriptorBasedCaches";
    public static final String CACHE_EXCLUDES_STRING = "cacheExcludes";
    private static final String DELIMITER_FOR_EXCLUDE = ",";
    private static final ObjectCacheInternal DUMMY_CACHE = new ObjectCacheInternalWrapper(new ObjectCacheEmptyImpl(null, null));
    private Map caches = new HashMap();
    private List excludedPackages;
    private final PersistenceBroker broker;
    private boolean descriptorBasedCaches;

    public CacheDistributor(PersistenceBroker persistenceBroker) {
        this.broker = persistenceBroker;
        this.descriptorBasedCaches = OjbConfigurator.getInstance().getConfigurationFor(null).getBoolean(DESCRIPTOR_BASED_CACHES, false);
        String string = persistenceBroker.serviceConnectionManager().getConnectionDescriptor().getAttribute(CACHE_EXCLUDES_STRING);
        if (string != null && (string = string.trim()).length() > 0) {
            this.excludedPackages = this.createExcludedPackagesList(string);
            log.info("Packages to exclude from caching: " + this.excludedPackages);
        }
    }

    @Override
    public void cache(Identity identity, Object object) {
        this.getCache(identity.getObjectsTopLevelClass()).cache(identity, object);
    }

    @Override
    public boolean cacheIfNew(Identity identity, Object object) {
        return this.getCache(identity.getObjectsTopLevelClass()).cacheIfNew(identity, object);
    }

    @Override
    public Object lookup(Identity identity) {
        return this.getCache(identity.getObjectsTopLevelClass()).lookup(identity);
    }

    @Override
    public void remove(Identity identity) {
        this.getCache(identity.getObjectsTopLevelClass()).remove(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map map = this.caches;
        synchronized (map) {
            Iterator iterator = this.caches.values().iterator();
            ObjectCache objectCache = null;
            while (iterator.hasNext()) {
                objectCache = (ObjectCache)iterator.next();
                try {
                    objectCache.clear();
                }
                catch (Exception exception) {
                    log.error("Error while call method 'clear()' on '" + objectCache + "'", exception);
                }
            }
        }
    }

    @Override
    public void doInternalCache(Identity identity, Object object, int n) {
        this.getCache(identity.getObjectsTopLevelClass()).doInternalCache(identity, object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectCacheInternal getCache(Class clazz) {
        boolean bl = false;
        ObjectCacheInternal objectCacheInternal = null;
        ObjectCacheDescriptor objectCacheDescriptor = this.searchInClassDescriptor(clazz);
        if (objectCacheDescriptor == null) {
            objectCacheDescriptor = this.searchInJdbcConnectionDescriptor();
            bl = true;
        }
        if (objectCacheDescriptor == null) {
            throw new OJBRuntimeException("No object cache descriptor found for " + clazz + ", using PBKey " + this.broker.getPBKey() + ". Please set a cache descriptor in jdbc-connection-descriptor or in class-descriptor");
        }
        if (!bl) {
            if (!this.descriptorBasedCaches) {
                Map map = this.caches;
                synchronized (map) {
                    objectCacheInternal = this.lookupCache(clazz);
                    if (objectCacheInternal == null) {
                        if (log.isEnabledFor(2)) {
                            String string = SystemUtils.LINE_SEPARATOR;
                            log.info(string + "<====" + string + "Setup new object cache instance on CLASS LEVEL for" + string + "PersistenceBroker: " + this.broker + string + "descriptorBasedCache: " + this.descriptorBasedCaches + string + "Class: " + clazz + string + "ObjectCache: " + objectCacheDescriptor + string + "====>");
                        }
                        objectCacheInternal = this.prepareAndAddCache(clazz, objectCacheDescriptor);
                    }
                }
            } else {
                Map map = this.caches;
                synchronized (map) {
                    objectCacheInternal = this.lookupCache(objectCacheDescriptor);
                    if (objectCacheInternal == null) {
                        if (log.isEnabledFor(2)) {
                            String string = SystemUtils.LINE_SEPARATOR;
                            log.info(string + "<====" + string + "Setup new object cache instance on CLASS LEVEL for" + string + "PersistenceBroker: " + this.broker + string + "descriptorBasedCache: " + this.descriptorBasedCaches + string + "class: " + clazz + string + "ObjectCache: " + objectCacheDescriptor + string + "====>");
                        }
                        objectCacheInternal = this.prepareAndAddCache(objectCacheDescriptor, objectCacheDescriptor);
                    }
                }
            }
        } else if (this.isExcluded(clazz)) {
            if (log.isDebugEnabled()) {
                log.debug("Class '" + clazz.getName() + "' is excluded from being cached");
            }
            objectCacheInternal = DUMMY_CACHE;
        } else {
            String string = this.broker.serviceConnectionManager().getConnectionDescriptor().getJcdAlias();
            Map map = this.caches;
            synchronized (map) {
                objectCacheInternal = this.lookupCache(string);
                if (objectCacheInternal == null) {
                    if (log.isEnabledFor(2)) {
                        String string2 = SystemUtils.LINE_SEPARATOR;
                        log.info(string2 + "<====" + string2 + "Setup new object cache instance on CONNECTION LEVEL for" + string2 + "PersistenceBroker: " + this.broker + string2 + "descriptorBasedCache: " + this.descriptorBasedCaches + string2 + "Connection jcdAlias: " + string + string2 + "Calling class: " + clazz + "ObjectCache: " + objectCacheDescriptor + string2 + "====>");
                    }
                    objectCacheInternal = this.prepareAndAddCache(string, objectCacheDescriptor);
                }
            }
        }
        return objectCacheInternal;
    }

    private ObjectCacheInternal prepareAndAddCache(Object object, ObjectCacheDescriptor objectCacheDescriptor) {
        ObjectCacheInternal objectCacheInternal = this.lookupCache(object);
        if (objectCacheInternal != null) {
            log.info("Key '" + object + "' was already in use no need to create the ObjectCache instance again");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Create new ObjectCache implementation for " + object);
            }
            try {
                ObjectCache objectCache = (ObjectCache)ClassHelper.newInstance(objectCacheDescriptor.getObjectCache(), new Class[]{PersistenceBroker.class, Properties.class}, new Object[]{this.broker, objectCacheDescriptor.getConfigurationProperties()});
                if (objectCache instanceof ObjectCacheInternal) {
                    objectCacheInternal = (ObjectCacheInternal)objectCache;
                } else {
                    log.info("Specified cache " + objectCacheDescriptor.getObjectCache() + " does not implement " + ObjectCacheInternal.class + " and will be wrapped by a helper class");
                    objectCacheInternal = new ObjectCacheInternalWrapper(objectCache);
                }
            }
            catch (Exception exception) {
                log.error("Can not create ObjectCache instance using class " + objectCacheDescriptor.getObjectCache(), exception);
                throw new OJBRuntimeException(exception);
            }
            this.caches.put(object, objectCacheInternal);
        }
        return objectCacheInternal;
    }

    private ObjectCacheInternal lookupCache(Object object) {
        return (ObjectCacheInternal)this.caches.get(object);
    }

    private List createExcludedPackagesList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER_FOR_EXCLUDE);
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private boolean isExcluded(Class clazz) {
        if (this.excludedPackages != null) {
            String string = clazz.getName();
            for (int i = 0; i < this.excludedPackages.size(); ++i) {
                String string2 = (String)this.excludedPackages.get(i);
                if (!string.startsWith(string2)) continue;
                return true;
            }
        }
        return false;
    }

    protected ObjectCacheDescriptor searchInClassDescriptor(Class clazz) {
        return clazz != null ? this.broker.getClassDescriptor(clazz).getObjectCacheDescriptor() : null;
    }

    protected ObjectCacheDescriptor searchInJdbcConnectionDescriptor() {
        return this.broker.serviceConnectionManager().getConnectionDescriptor().getObjectCacheDescriptor();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        return toStringBuilder.append("Associated PB", (Object)this.broker).append("Mapped caches", (Object)this.caches).toString();
    }

    static final class ObjectCacheInternalWrapper
    implements ObjectCacheInternal {
        ObjectCache cache = null;

        public ObjectCacheInternalWrapper(ObjectCache objectCache) {
            this.cache = objectCache;
        }

        @Override
        public void doInternalCache(Identity identity, Object object, int n) {
            this.cache(identity, object);
        }

        public void doInternalClear() {
        }

        public boolean contains(Identity identity) {
            return this.cache.lookup(identity) != null;
        }

        @Override
        public void cache(Identity identity, Object object) {
            this.cache.cache(identity, object);
        }

        @Override
        public boolean cacheIfNew(Identity identity, Object object) {
            this.cache.cache(identity, object);
            return true;
        }

        @Override
        public Object lookup(Identity identity) {
            return this.cache.lookup(identity);
        }

        @Override
        public void remove(Identity identity) {
            this.cache.remove(identity);
        }

        @Override
        public void clear() {
            this.cache.clear();
        }
    }
}

