/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.orm.ojb;

import java.sql.SQLException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springmodules.orm.ojb.OjbOperationException;

public class OjbAccessor
extends JdbcAccessor {
    private PBKey pbKey = PersistenceBrokerFactory.getDefaultKey();

    public void setJcdAlias(String jcdAlias) {
        this.pbKey = new PBKey(jcdAlias);
    }

    public String getJcdAlias() {
        return this.pbKey != null ? this.pbKey.getAlias() : null;
    }

    public void setPbKey(PBKey pbKey) {
        this.pbKey = pbKey;
    }

    public PBKey getPbKey() {
        return this.pbKey;
    }

    public DataAccessException convertOjbAccessException(PersistenceBrokerException ex) {
        if (ex.getCause() instanceof PersistenceBrokerException) {
            return this.convertOjbAccessException((PersistenceBrokerException)ex.getCause());
        }
        if (ex.getCause() instanceof SQLException) {
            return this.convertJdbcAccessException((SQLException)ex.getCause());
        }
        throw new OjbOperationException(ex);
    }

    protected DataAccessException convertJdbcAccessException(SQLException ex) {
        return this.getExceptionTranslator().translate("OJB operation", null, ex);
    }
}

