/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.inquiry;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.datadictionary.exception.UnknownBusinessClassAttributeException;
import org.kuali.rice.krad.inquiry.Inquirable;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DataObjectAuthorizationService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.service.impl.ViewHelperServiceImpl;
import org.kuali.rice.krad.uif.widget.Inquiry;
import org.kuali.rice.krad.util.ExternalizableBusinessObjectUtils;
import org.kuali.rice.krad.util.KRADUtils;
import org.springframework.beans.PropertyAccessorUtils;

public class InquirableImpl
extends ViewHelperServiceImpl
implements Inquirable {
    private static final Logger LOG = LogManager.getLogger(InquirableImpl.class);
    protected Class<?> dataObjectClass;
    public static List<Class<?>> SUPER_CLASS_TRANSLATOR_LIST = new ArrayList();

    @Override
    public Object retrieveDataObject(Map<String, String> parameters) {
        if (this.dataObjectClass == null) {
            LOG.error("Data object class must be set in inquirable before retrieving the object");
            throw new RuntimeException("Data object class must be set in inquirable before retrieving the object");
        }
        List pkPropertyNames = this.getLegacyDataAdapter().listPrimaryKeyFieldNames(this.dataObjectClass);
        List<List<String>> alternateKeyNameSets = this.getAlternateKeysForClass(this.dataObjectClass);
        alternateKeyNameSets.add(0, pkPropertyNames);
        List<String> dataObjectKeySet = this.retrieveKeySetFromMap(alternateKeyNameSets, parameters);
        if (dataObjectKeySet == null || dataObjectKeySet.isEmpty()) {
            LOG.warn("Matching key set not found in request for class: " + this.getDataObjectClass());
            return null;
        }
        HashMap<String, String> keyPropertyValues = new HashMap<String, String>();
        for (String keyPropertyName : dataObjectKeySet) {
            String keyPropertyValue = parameters.get(keyPropertyName);
            Boolean forceUppercase = Boolean.FALSE;
            try {
                forceUppercase = this.getDataDictionaryService().getAttributeForceUppercase(this.dataObjectClass, keyPropertyName);
            }
            catch (UnknownBusinessClassAttributeException ex) {
                LOG.warn("Data object class " + this.dataObjectClass + " property " + keyPropertyName + " should probably have a DD definition.", (Throwable)ex);
            }
            if (forceUppercase.booleanValue() && keyPropertyValue != null) {
                keyPropertyValue = keyPropertyValue.toUpperCase();
            }
            boolean isSecure = KRADUtils.isSecure(keyPropertyName, this.dataObjectClass);
            if (StringUtils.endsWith((String)keyPropertyValue, (String)"(&^#&)")) {
                keyPropertyValue = StringUtils.removeEnd((String)keyPropertyValue, (String)"(&^#&)");
                isSecure = true;
            }
            if (isSecure) {
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        keyPropertyValue = this.getEncryptionService().decrypt(keyPropertyValue);
                    }
                }
                catch (GeneralSecurityException e) {
                    String message = "Data object class " + this.dataObjectClass + " property " + keyPropertyName + " should have been encrypted, but there was a problem decrypting it.";
                    LOG.error(message, (Throwable)e);
                    throw new RuntimeException(message, e);
                }
            }
            keyPropertyValues.put(keyPropertyName, keyPropertyValue);
        }
        Object dataObject = null;
        Map<String, Object> translatedValues = KRADUtils.coerceRequestParameterTypes(this.getDataObjectClass(), keyPropertyValues);
        ModuleService moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(this.getDataObjectClass());
        if (moduleService != null && moduleService.isExternalizable(this.getDataObjectClass())) {
            dataObject = moduleService.getExternalizableBusinessObject(this.getDataObjectClass().asSubclass(ExternalizableBusinessObject.class), translatedValues);
        } else if (KradDataServiceLocator.getDataObjectService().supports(this.getDataObjectClass())) {
            dataObject = KradDataServiceLocator.getDataObjectService().find(this.getDataObjectClass(), (Object)new CompoundKey(translatedValues));
        } else if (BusinessObject.class.isAssignableFrom(this.getDataObjectClass())) {
            dataObject = this.getLegacyDataAdapter().findByPrimaryKey(this.getDataObjectClass().asSubclass(BusinessObject.class), translatedValues);
        } else {
            throw new IllegalArgumentException("ERROR: Unsupported object type passed to inquiry: " + this.getDataObjectClass() + " / keys=" + keyPropertyValues);
        }
        return dataObject;
    }

    protected List<String> retrieveKeySetFromMap(List<List<String>> potentialKeySets, Map<String, String> parameters) {
        List<String> foundKeySet = null;
        for (List<String> potentialKeySet : potentialKeySets) {
            boolean keySetMatch = true;
            for (String keyName : potentialKeySet) {
                if (parameters.containsKey(keyName) && !StringUtils.isBlank((String)parameters.get(keyName))) continue;
                keySetMatch = false;
            }
            if (!keySetMatch) continue;
            foundKeySet = potentialKeySet;
            break;
        }
        return foundKeySet;
    }

    protected List<List<String>> getAlternateKeysForClass(Class<?> clazz) {
        KualiModuleService kualiModuleService = this.getKualiModuleService();
        ModuleService moduleService = kualiModuleService.getResponsibleModuleService(clazz);
        ArrayList altKeys = null;
        if (moduleService != null) {
            altKeys = moduleService.listAlternatePrimaryKeyFieldNames(clazz);
        }
        return altKeys != null ? altKeys : new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildInquirableLink(Object dataObject, String propertyName, Inquiry inquiry) {
        List<Object> keys;
        Object documentNumber;
        String nestedPropertyName;
        Iterator<Class<?>> nestedPropertyObject;
        Class inquiryObjectClass = null;
        Class objectClass = KRADUtils.materializeClassForProxiedObject(dataObject);
        if (propertyName.equals(KRADServiceLocatorWeb.getLegacyDataAdapter().getTitleAttribute(objectClass))) {
            inquiryObjectClass = objectClass;
        } else if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)propertyName) && KRADUtils.isNotNull(nestedPropertyObject = KRADUtils.getNestedValue(dataObject, nestedPropertyName = KRADUtils.getNestedAttributePrefix(propertyName)))) {
            String string = KRADUtils.getNestedAttributePrimitive(propertyName);
            Class nestedPropertyObjectClass = KRADUtils.materializeClassForProxiedObject(nestedPropertyObject);
            if (string.equals(KRADServiceLocatorWeb.getLegacyDataAdapter().getTitleAttribute(nestedPropertyObjectClass))) {
                inquiryObjectClass = nestedPropertyObjectClass;
            }
        }
        if (inquiryObjectClass == null) {
            inquiryObjectClass = this.getLegacyDataAdapter().getInquiryObjectClassIfNotTitle(dataObject, propertyName);
        }
        if (inquiryObjectClass == null) {
            inquiry.setRender(false);
            return;
        }
        if (DocumentHeader.class.isAssignableFrom(inquiryObjectClass)) {
            documentNumber = (String)KradDataServiceLocator.getDataObjectService().wrap(dataObject).getPropertyValueNullSafe(propertyName);
            if (StringUtils.isNotBlank((String)documentNumber)) {
                inquiry.getInquiryLink().setHref(this.getConfigurationService().getPropertyValueAsString("workflow.url") + "/DocHandler.do?docId=" + (String)documentNumber + "&command=displayDocSearchView");
                inquiry.getInquiryLink().setLinkText((String)documentNumber);
                inquiry.setRender(true);
            }
            return;
        }
        documentNumber = SUPER_CLASS_TRANSLATOR_LIST;
        synchronized (documentNumber) {
            for (Class clazz : SUPER_CLASS_TRANSLATOR_LIST) {
                if (!clazz.isAssignableFrom(inquiryObjectClass)) continue;
                inquiryObjectClass = clazz;
                break;
            }
        }
        if (!inquiryObjectClass.isInterface() && ExternalizableBusinessObject.class.isAssignableFrom(inquiryObjectClass)) {
            inquiryObjectClass = ExternalizableBusinessObjectUtils.determineExternalizableBusinessObjectSubInterface(inquiryObjectClass);
        }
        if ((keys = new ArrayList(this.getLegacyDataAdapter().listPrimaryKeyFieldNames(inquiryObjectClass))) == null) {
            keys = Collections.emptyList();
        }
        Map inquiryParameters = this.getLegacyDataAdapter().getInquiryParameters(dataObject, keys, propertyName);
        inquiry.buildInquiryLink(dataObject, propertyName, inquiryObjectClass, inquiryParameters);
    }

    @Override
    public Class<?> getDataObjectClass() {
        return this.dataObjectClass;
    }

    @Override
    public void setDataObjectClass(Class<?> dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
    }

    @Override
    protected LegacyDataAdapter getLegacyDataAdapter() {
        return KRADServiceLocatorWeb.getLegacyDataAdapter();
    }

    protected KualiModuleService getKualiModuleService() {
        return KRADServiceLocatorWeb.getKualiModuleService();
    }

    @Override
    public DataDictionaryService getDataDictionaryService() {
        return KRADServiceLocatorWeb.getDataDictionaryService();
    }

    protected DataObjectAuthorizationService getDataObjectAuthorizationService() {
        return KRADServiceLocatorWeb.getDataObjectAuthorizationService();
    }

    protected EncryptionService getEncryptionService() {
        return CoreApiServiceLocator.getEncryptionService();
    }
}

