/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.period;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.core.BudgetContainer;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.impl.core.BudgetPeriodValuesFinder;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.web.struts.form.MultipleValueLookupForm;
import org.kuali.rice.krad.service.DocumentService;
import org.springframework.web.servlet.ModelAndView;

public class BudgetExpensePeriodValuesFinder
extends BudgetPeriodValuesFinder {
    protected Logger LOG = LogManager.getLogger(BudgetExpensePeriodValuesFinder.class);
    protected AwardBudgetService awardBudgetService = KcServiceLocator.getService(AwardBudgetService.class);
    protected DocumentService documentService = KcServiceLocator.getService(DocumentService.class);

    @Override
    public List<KeyValue> getKeyValues() {
        List<KeyValue> KeyValues = null;
        Object formOrView = this.getFormOrView();
        if (formOrView instanceof BudgetContainer) {
            List<BudgetPeriod> budgetPeriods = ((BudgetContainer)formOrView).getBudget().getBudgetPeriods();
            if (budgetPeriods.size() > 0) {
                KeyValues = this.buildKeyValues(budgetPeriods);
            }
        } else if (formOrView instanceof MultipleValueLookupForm) {
            try {
                AwardBudgetDocument doc = (AwardBudgetDocument)this.getDocumentService().getByDocumentHeaderId(((MultipleValueLookupForm)formOrView).getDocNum());
                List<BudgetPeriod> budgetPeriods = this.getAwardBudgetService().findBudgetPeriodsFromLinkedProposal(doc.getBudget().getBudgetParent());
                if (budgetPeriods.size() > 0) {
                    KeyValues = this.buildKeyValuesForPeriodSearch(budgetPeriods);
                }
            }
            catch (WorkflowException e) {
                this.LOG.error("Unable to load document for budget period values finder.", (Throwable)e);
            }
        }
        if (KeyValues != null) {
            return KeyValues;
        }
        return new ArrayList<KeyValue>();
    }

    public List<KeyValue> getKeyValues(ModelAndView model) {
        return this.buildKeyValues(((BudgetContainer)model).getBudget().getBudgetPeriods());
    }

    private List<KeyValue> buildKeyValues(List<BudgetPeriod> budgetPeriods) {
        ArrayList<KeyValue> KeyValues = new ArrayList<KeyValue>();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (budgetPeriod.getBudgetPeriod() == null) continue;
            KeyValues.add((KeyValue)new ConcreteKeyValue(budgetPeriod.getBudgetPeriod().toString(), budgetPeriod.getLabel()));
        }
        return KeyValues;
    }

    private List<KeyValue> buildKeyValuesForPeriodSearch(List<BudgetPeriod> budgetPeriods) {
        ArrayList<KeyValue> KeyValues = new ArrayList<KeyValue>();
        ArrayList<Integer> uniqueKeys = new ArrayList<Integer>();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (budgetPeriod.getBudgetPeriod() == null || uniqueKeys.contains(budgetPeriod.getBudgetPeriod())) continue;
            uniqueKeys.add(budgetPeriod.getBudgetPeriod());
            KeyValues.add((KeyValue)new ConcreteKeyValue(budgetPeriod.getBudgetPeriod().toString(), budgetPeriod.getBudgetPeriod().toString()));
        }
        return KeyValues;
    }

    protected AwardBudgetService getAwardBudgetService() {
        return this.awardBudgetService;
    }

    public void setAwardBudgetService(AwardBudgetService awardBudgetService) {
        this.awardBudgetService = awardBudgetService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

