/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.meeting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.coeus.common.committee.impl.meeting.CommonMeetingService;
import org.kuali.coeus.common.committee.impl.meeting.MeetingControllerService;
import org.kuali.coeus.common.committee.impl.meeting.MeetingFormBase;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Required;

public class MeetingControllerServiceImpl
implements MeetingControllerService {
    private static final String LINE_NUMBER = "lineNum";
    private static final String READ_ONLY = "readOnly";
    private static final String TRUE_STRING = "true";
    private static final String ID = "id";
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    private Class<? extends CommitteeScheduleBase> scheduleBusinessObjectClass;
    private ReviewCommentsService reviewCommentsService;
    private CommonMeetingService meetingService;

    @Override
    public void populateSchedule(MeetingFormBase form, HttpServletRequest request, String scheduleId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(ID, scheduleId);
        ArrayList<CommitteeScheduleMinuteBase> permittedMinutes = new ArrayList<CommitteeScheduleMinuteBase>();
        CommitteeScheduleBase commSchedule = (CommitteeScheduleBase)this.businessObjectService.findByPrimaryKey(this.getScheduleBusinessObjectClass(), fieldValues);
        List minutes = commSchedule.getCommitteeScheduleMinutes();
        Collections.sort(minutes, CommitteeScheduleMinuteBase.entryTypeComparator);
        for (CommitteeScheduleMinuteBase minute : minutes) {
            if (!this.getReviewCommentsService().getReviewerCommentsView(minute)) continue;
            permittedMinutes.add(minute);
        }
        commSchedule.setCommitteeScheduleMinutes(permittedMinutes);
        form.setReadOnly(TRUE_STRING.equals(request.getParameter(READ_ONLY)));
        form.getMeetingHelper().setCommitteeSchedule(commSchedule);
        if (!form.getMeetingHelper().hasViewModifySchedulePermission()) {
            throw new AuthorizationException(this.getGlobalVariableService().getUserSession().getPerson().getPrincipalName(), "start", ((Object)((Object)form)).getClass().getSimpleName());
        }
        this.getMeetingService().populateFormHelper(form.getMeetingHelper(), commSchedule, MeetingControllerServiceImpl.getScheduleLineNumber(request, commSchedule));
    }

    private static int getScheduleLineNumber(HttpServletRequest request, CommitteeScheduleBase<?, ?, ?, ?> commSchedule) {
        int lineNumber = 0;
        if (StringUtils.isNotBlank((CharSequence)request.getParameter(LINE_NUMBER))) {
            lineNumber = Integer.parseInt(request.getParameter(LINE_NUMBER));
        } else {
            for (CommitteeScheduleBase schedule : ((CommitteeBase)commSchedule.getParentCommittee()).getCommitteeSchedules()) {
                ++lineNumber;
                if (!schedule.getId().equals(commSchedule.getId())) continue;
                break;
            }
        }
        return lineNumber;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public Class<? extends CommitteeScheduleBase> getScheduleBusinessObjectClass() {
        return this.scheduleBusinessObjectClass;
    }

    @Required
    public void setScheduleBusinessObjectClass(Class<? extends CommitteeScheduleBase> scheduleBusinessObjectClass) {
        this.scheduleBusinessObjectClass = scheduleBusinessObjectClass;
    }

    public ReviewCommentsService getReviewCommentsService() {
        return this.reviewCommentsService;
    }

    @Required
    public void setReviewCommentsService(ReviewCommentsService reviewCommentsService) {
        this.reviewCommentsService = reviewCommentsService;
    }

    public CommonMeetingService getMeetingService() {
        return this.meetingService;
    }

    @Required
    public void setMeetingService(CommonMeetingService meetingService) {
        this.meetingService = meetingService;
    }
}

