/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.api.s2s.S2sOpportunityContract;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.s2s.S2sOppForms;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunityCfda;
import org.kuali.coeus.propdev.impl.s2s.S2sProvider;
import org.kuali.coeus.propdev.impl.s2s.S2sRevisionType;
import org.kuali.coeus.propdev.impl.s2s.S2sSubmissionType;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="S2S_OPPORTUNITY")
public class S2sOpportunity
extends KcPersistableBusinessObjectBase
implements S2sOpportunityContract {
    @Id
    @OneToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER", insertable=true, updatable=true)
    private DevelopmentProposal developmentProposal;
    @Column(name="CLOSING_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar closingDate;
    @Column(name="COMPETETION_ID")
    private String competitionId;
    @Column(name="COMPETITION_TITLE")
    private String competitionTitle;
    @Column(name="PACKAGE_ID")
    private String packageId;
    @Column(name="INSTRUCTION_URL")
    private String instructionUrl;
    @Column(name="OPENING_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar openingDate;
    @Column(name="OPPORTUNITY")
    @Lob
    private String opportunity;
    @Column(name="OPPORTUNITY_ID")
    private String opportunityId;
    @Column(name="OPPORTUNITY_TITLE")
    private String opportunityTitle;
    @Column(name="REVISION_CODE")
    private String revisionCode;
    @Column(name="REVISION_OTHER_DESCRIPTION")
    private String revisionOtherDescription;
    @Column(name="S2S_SUBMISSION_TYPE_CODE")
    private String s2sSubmissionTypeCode;
    @Column(name="SCHEMA_URL")
    private String schemaUrl;
    @Column(name="OFFERING_AGENCY")
    private String offeringAgency;
    @Column(name="AGENCY_CONTACT_INFO")
    private String agencyContactInfo;
    @Column(name="MULTI_PROJECT")
    @Convert(converter=BooleanYNConverter.class)
    private boolean multiProject;
    @Column(name="PROVIDER")
    private String providerCode;
    @Column(name="COMPONENT_TYPE")
    private String componentType;
    @Column(name="OVERALL_SCHEMA_URL")
    private String overallSchemaUrl;
    @Column(name="OVERALL_SCHEMA")
    private String overallSchema;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER")
    private List<S2sOpportunityCfda> s2sOpportunityCfdas = new ArrayList<S2sOpportunityCfda>();
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER")
    private List<S2sOppForms> s2sOppForms;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="S2S_SUBMISSION_TYPE_CODE", referencedColumnName="S2S_SUBMISSION_TYPE_CODE", insertable=false, updatable=false)
    private S2sSubmissionType s2sSubmissionType;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="REVISION_CODE", referencedColumnName="S2S_REVISION_TYPE_CODE", insertable=false, updatable=false)
    private S2sRevisionType s2sRevisionType;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="PROVIDER", referencedColumnName="CODE", insertable=false, updatable=false)
    private S2sProvider s2sProvider;

    @Deprecated
    public String getCfdaNumber() {
        return this.findFirstCfda().map(S2sOpportunityCfda::getCfdaNumber).orElse(null);
    }

    @Deprecated
    public void setCfdaNumber(String cfdaNumber) {
        if (this.s2sOpportunityCfdas == null) {
            this.s2sOpportunityCfdas = new ArrayList<S2sOpportunityCfda>();
        }
        if (StringUtils.isBlank((CharSequence)cfdaNumber)) {
            this.s2sOpportunityCfdas.clear();
        } else {
            S2sOpportunityCfda cfda = this.findFirstCfda().orElseGet(S2sOpportunityCfda::new);
            this.s2sOpportunityCfdas.clear();
            cfda.setCfdaNumber(cfdaNumber);
            if (this.getDevelopmentProposal() != null) {
                cfda.setProposalNumber(this.getProposalNumber());
            }
            this.s2sOpportunityCfdas.add(cfda);
        }
    }

    @Deprecated
    public String getCfdaDescription() {
        return this.findFirstCfda().map(S2sOpportunityCfda::getCfdaDescription).orElse(null);
    }

    @Deprecated
    public void setCfdaDescription(String cfdaDescription) {
        if (this.s2sOpportunityCfdas == null) {
            this.s2sOpportunityCfdas = new ArrayList<S2sOpportunityCfda>();
        }
        S2sOpportunityCfda cfda = this.findFirstCfda().orElseGet(S2sOpportunityCfda::new);
        this.s2sOpportunityCfdas.clear();
        cfda.setCfdaDescription(cfdaDescription);
        if (this.getDevelopmentProposal() != null) {
            cfda.setProposalNumber(this.getProposalNumber());
        }
        this.s2sOpportunityCfdas.add(cfda);
    }

    @Deprecated
    private Optional<S2sOpportunityCfda> findFirstCfda() {
        if (this.s2sOpportunityCfdas != null) {
            return this.s2sOpportunityCfdas.stream().findFirst();
        }
        return Optional.empty();
    }

    public Calendar getClosingDate() {
        return this.closingDate;
    }

    public void setClosingDate(Calendar closingDate) {
        this.closingDate = closingDate;
    }

    public String getCompetitionId() {
        return this.competitionId;
    }

    public void setCompetitionId(String competitionId) {
        this.competitionId = competitionId;
    }

    public String getInstructionUrl() {
        return this.instructionUrl;
    }

    public void setInstructionUrl(String instructionUrl) {
        this.instructionUrl = instructionUrl;
    }

    public Calendar getOpeningDate() {
        return this.openingDate;
    }

    public void setOpeningDate(Calendar openingDate) {
        this.openingDate = openingDate;
    }

    public String getOpportunity() {
        return this.opportunity;
    }

    public void setOpportunity(String opportunity) {
        this.opportunity = opportunity;
    }

    public String getRevisionCode() {
        return this.revisionCode;
    }

    public void setRevisionCode(String revisionCode) {
        this.revisionCode = revisionCode;
    }

    public String getRevisionOtherDescription() {
        return this.revisionOtherDescription;
    }

    public void setRevisionOtherDescription(String revisionOtherDescription) {
        this.revisionOtherDescription = revisionOtherDescription;
    }

    public String getS2sSubmissionTypeCode() {
        return this.s2sSubmissionTypeCode;
    }

    public void setS2sSubmissionTypeCode(String s2sSubmissionTypeCode) {
        this.s2sSubmissionTypeCode = s2sSubmissionTypeCode;
    }

    public String getSchemaUrl() {
        return this.schemaUrl;
    }

    public void setSchemaUrl(String schemaUrl) {
        this.schemaUrl = schemaUrl;
    }

    public List<S2sOppForms> getS2sOppForms() {
        return this.s2sOppForms;
    }

    public void setS2sOppForms(List<S2sOppForms> oppForms) {
        this.s2sOppForms = oppForms;
    }

    public S2sRevisionType getS2sRevisionType() {
        return this.s2sRevisionType;
    }

    public void setS2sRevisionType(S2sRevisionType revisionType) {
        this.s2sRevisionType = revisionType;
    }

    public String getOpportunityId() {
        return this.opportunityId;
    }

    public void setOpportunityId(String opportunityId) {
        this.opportunityId = opportunityId;
    }

    public String getOpportunityTitle() {
        return this.opportunityTitle;
    }

    public void setOpportunityTitle(String opportunityTitle) {
        this.opportunityTitle = opportunityTitle;
    }

    public S2sSubmissionType getS2sSubmissionType() {
        return this.s2sSubmissionType;
    }

    public void setS2sSubmissionType(S2sSubmissionType submissionType) {
        this.s2sSubmissionType = submissionType;
    }

    public String getProviderCode() {
        return this.providerCode;
    }

    public void setProviderCode(String providerCode) {
        this.providerCode = providerCode;
    }

    public S2sProvider getS2sProvider() {
        return this.s2sProvider;
    }

    public void setS2sProvider(S2sProvider s2sProvider) {
        this.s2sProvider = s2sProvider;
    }

    public String getFundingOpportunityNumber() {
        return this.opportunityId;
    }

    public void setFundingOpportunityNumber(String fundingOpportunityNumber) {
        this.opportunityId = fundingOpportunityNumber;
    }

    public String getOfferingAgency() {
        return this.offeringAgency;
    }

    public void setOfferingAgency(String offeringAgency) {
        this.offeringAgency = offeringAgency;
    }

    public String getAgencyContactInfo() {
        return this.agencyContactInfo;
    }

    public void setAgencyContactInfo(String agencyContactInfo) {
        this.agencyContactInfo = agencyContactInfo;
    }

    public boolean isMultiProject() {
        return this.multiProject;
    }

    public void setMultiProject(boolean multiProject) {
        this.multiProject = multiProject;
    }

    public String getCompetitionTitle() {
        return this.competitionTitle;
    }

    public void setCompetitionTitle(String competitionTitle) {
        this.competitionTitle = competitionTitle;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public DevelopmentProposal getDevelopmentProposal() {
        return this.developmentProposal;
    }

    public void setDevelopmentProposal(DevelopmentProposal developmentProposal) {
        this.developmentProposal = developmentProposal;
    }

    public String getProposalNumber() {
        return this.getDevelopmentProposal() != null ? this.getDevelopmentProposal().getProposalNumber() : null;
    }

    public List<S2sOpportunityCfda> getS2sOpportunityCfdas() {
        return this.s2sOpportunityCfdas;
    }

    public void setS2sOpportunityCfdas(List<S2sOpportunityCfda> s2sOpportunityCfdas) {
        this.s2sOpportunityCfdas = s2sOpportunityCfdas;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getOverallSchemaUrl() {
        return this.overallSchemaUrl;
    }

    public void setOverallSchemaUrl(String overallSchemaUrl) {
        this.overallSchemaUrl = overallSchemaUrl;
    }

    public String getOverallSchema() {
        return this.overallSchema;
    }

    public void setOverallSchema(String overallSchema) {
        this.overallSchema = overallSchema;
    }

    public String getS2sOpportunityCfdasSerialized() {
        try {
            return StringEscapeUtils.escapeHtml4((String)new ObjectMapper().writeValueAsString(this.getS2sOpportunityCfdas().stream().map(cfda -> CollectionUtils.entry(cfda.getCfdaNumber(), cfda.getCfdaDescription())).collect(Collectors.toList())));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setS2sOpportunityCfdasSerialized(String s2sOpportunityCfdasSerialized) {
        try {
            List cfdas = (List)new ObjectMapper().readValue(StringEscapeUtils.unescapeHtml4((String)s2sOpportunityCfdasSerialized), (TypeReference)new TypeReference<List<Map.Entry<String, String>>>(){});
            this.setS2sOpportunityCfdas(cfdas.stream().map(e -> {
                S2sOpportunityCfda cfda = new S2sOpportunityCfda();
                cfda.setCfdaNumber((String)e.getKey());
                cfda.setCfdaDescription((String)e.getValue());
                return cfda;
            }).collect(Collectors.toList()));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }
}

