/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.onlinereview;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocolOnlineReviewDocument;
import org.kuali.kra.iacuc.onlinereview.authorization.IacucProtocolOnlineReviewTask;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewFormBase;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolOnlineReviewForm
extends ProtocolOnlineReviewFormBase {
    private static final long serialVersionUID = -5729500189953414964L;
    private static Logger LOG = LogManager.getLogger(IacucProtocolOnlineReviewForm.class);
    private static final Map<String, String> ONLINE_REVIEW_APPROVE_BUTTON_MAP = new HashMap<String, String>();

    @Override
    protected String getDefaultDocumentTypeName() {
        return "IacucProtocolOnlineReviewDocument";
    }

    @Override
    protected String getLockRegion() {
        return "IACUC_PROTOCOL";
    }

    @Override
    public List<ExtraButton> getExtraActionsButtons() {
        this.extraButtons.clear();
        IacucProtocolOnlineReviewDocument doc = (IacucProtocolOnlineReviewDocument)this.getProtocolOnlineReviewDocument();
        String externalImageURL = "kra.externalizable.images.url";
        TaskAuthorizationService tas = KcServiceLocator.getService(TaskAuthorizationService.class);
        if (tas.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), new IacucProtocolOnlineReviewTask("rejectIacucProtocolOnlineReview", doc)) && doc.getDocumentHeader().getWorkflowDocument().isEnroute() && "F".equals(doc.getProtocolOnlineReview().getProtocolOnlineReviewStatusCode())) {
            String resubmissionImage = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "buttonsmall_return_to_reviewer.gif";
            this.addExtraButton("methodToCall.rejectOnlineReview", resubmissionImage, "Return to reviewer");
        }
        return this.extraButtons;
    }

    @Override
    public boolean getAdminFieldsEditable() {
        return KcServiceLocator.getService(KcAuthorizationService.class).hasPermission(GlobalVariables.getUserSession().getPrincipalId(), this.getProtocolOnlineReviewDocument().getProtocolOnlineReview().getProtocol(), "Maintain IACUC Protocol Online Reviews");
    }

    @Override
    protected Map<String, String> getOnlineReviewApproveButtonMapHook() {
        return ONLINE_REVIEW_APPROVE_BUTTON_MAP;
    }

    @Override
    protected Logger getLogHook() {
        return LOG;
    }

    static {
        ONLINE_REVIEW_APPROVE_BUTTON_MAP.put("IACUCAdminInitialReview", "buttonsmall_send_review_request.gif");
        ONLINE_REVIEW_APPROVE_BUTTON_MAP.put("IACUCAdminReview", "buttonsmall_accept_review_comments.gif");
        ONLINE_REVIEW_APPROVE_BUTTON_MAP.put("IACUCOnlineReviewer", "buttonsmall_approve_this_review.gif");
    }
}

