/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.extension.ExtensionRepositoryService;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.service.RuleAttributeService;
import org.w3c.dom.Element;

@XmlRootElement(name="extensionRepositoryService")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="ExtensionRepositoryService", propOrder={"ruleAttributeService", "_futureElements"})
public class ExtensionRepositoryServiceImpl
implements ExtensionRepositoryService {
    @XmlElement(name="ruleAttributeService", required=true)
    private RuleAttributeService ruleAttributeService = null;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private ExtensionRepositoryServiceImpl() {
    }

    public ExtensionDefinition getExtensionById(String id) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("id was null or blank");
        }
        RuleAttribute ruleAttribute = this.ruleAttributeService.findByRuleAttributeId(id);
        return this.translateFromRuleAttribute(ruleAttribute);
    }

    public ExtensionDefinition getExtensionByName(String name) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)name)) {
            throw new RiceIllegalArgumentException("name was null or blank");
        }
        RuleAttribute ruleAttribute = this.ruleAttributeService.findByName(name);
        return this.translateFromRuleAttribute(ruleAttribute);
    }

    public List<ExtensionDefinition> getExtensionsByResourceDescriptor(String resourceDescriptor) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)resourceDescriptor)) {
            throw new RiceIllegalArgumentException("resourceDescriptor was null or blank");
        }
        List<RuleAttribute> ruleAttributes = this.ruleAttributeService.findByClassName(resourceDescriptor);
        if (CollectionUtils.isNotEmpty(ruleAttributes)) {
            ArrayList<ExtensionDefinition> definitions = new ArrayList<ExtensionDefinition>();
            for (RuleAttribute ruleAttribute : ruleAttributes) {
                definitions.add(this.translateFromRuleAttribute(ruleAttribute));
            }
            return Collections.unmodifiableList(definitions);
        }
        return Collections.emptyList();
    }

    private ExtensionDefinition translateFromRuleAttribute(RuleAttribute ruleAttribute) {
        return RuleAttribute.to(ruleAttribute);
    }

    public void setRuleAttributeService(RuleAttributeService ruleAttributeService) {
        this.ruleAttributeService = ruleAttributeService;
    }

    static class Elements {
        static final String RULE_ATTRIBUTE_SERVICE = "ruleAttributeService";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "extensionRepositoryService";
        static final String TYPE_NAME = "ExtensionRepositoryService";

        Constants() {
        }
    }
}

