/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.JdbcMetadataUtils;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ConnectionRepository
implements Serializable,
XmlCapable {
    private static final long serialVersionUID = -5581126412817848887L;
    private static Logger log = LoggerFactory.getLogger(ConnectionRepository.class);
    private HashMap jcdMap = new HashMap();
    private Hashtable jcdAliasToPBKeyMap = new Hashtable();
    private JdbcMetadataUtils utils = new JdbcMetadataUtils();

    public JdbcConnectionDescriptor getDescriptor(PBKey pBKey) {
        JdbcConnectionDescriptor jdbcConnectionDescriptor = (JdbcConnectionDescriptor)this.jcdMap.get(pBKey);
        if (jdbcConnectionDescriptor == null) {
            jdbcConnectionDescriptor = this.deepCopyOfFirstFound(pBKey.getAlias());
            if (jdbcConnectionDescriptor != null) {
                jdbcConnectionDescriptor.setUserName(pBKey.getUser());
                jdbcConnectionDescriptor.setPassWord(pBKey.getPassword());
                jdbcConnectionDescriptor.setDefaultConnection(false);
                log.info("Automatic create of new jdbc-connection-descriptor for PBKey " + pBKey);
                this.addDescriptor(jdbcConnectionDescriptor);
            } else {
                log.info("Could not find " + JdbcConnectionDescriptor.class.getName() + " for PBKey " + pBKey);
            }
        }
        return jdbcConnectionDescriptor;
    }

    private JdbcConnectionDescriptor deepCopyOfFirstFound(String string) {
        for (JdbcConnectionDescriptor jdbcConnectionDescriptor : this.jcdMap.values()) {
            if (!string.equals(jdbcConnectionDescriptor.getJcdAlias())) continue;
            return (JdbcConnectionDescriptor)SerializationUtils.clone((Serializable)jdbcConnectionDescriptor);
        }
        return null;
    }

    public PBKey getStandardPBKeyForJcdAlias(String string) {
        return (PBKey)this.jcdAliasToPBKeyMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescriptor(JdbcConnectionDescriptor jdbcConnectionDescriptor) {
        HashMap hashMap = this.jcdMap;
        synchronized (hashMap) {
            if (this.jcdMap.containsKey(jdbcConnectionDescriptor.getPBKey())) {
                throw new MetadataException("Found duplicate connection descriptor using PBKey " + jdbcConnectionDescriptor.getPBKey() + ", remove the old descriptor first, before add the new one. " + jdbcConnectionDescriptor);
            }
            this.jcdMap.put(jdbcConnectionDescriptor.getPBKey(), jdbcConnectionDescriptor);
            if (!this.jcdAliasToPBKeyMap.containsKey(jdbcConnectionDescriptor.getJcdAlias())) {
                this.jcdAliasToPBKeyMap.put(jdbcConnectionDescriptor.getJcdAlias(), jdbcConnectionDescriptor.getPBKey());
            }
            if (log.isDebugEnabled()) {
                log.debug("New descriptor was added: " + jdbcConnectionDescriptor);
            }
        }
    }

    public JdbcConnectionDescriptor addDescriptor(String string, String string2, String string3, String string4, String string5) {
        JdbcConnectionDescriptor jdbcConnectionDescriptor = new JdbcConnectionDescriptor();
        HashMap hashMap = this.utils.parseConnectionUrl(string3);
        jdbcConnectionDescriptor.setJcdAlias(string);
        jdbcConnectionDescriptor.setProtocol((String)hashMap.get("protocol"));
        jdbcConnectionDescriptor.setSubProtocol((String)hashMap.get("subprotocol"));
        jdbcConnectionDescriptor.setDbAlias((String)hashMap.get("dbAlias"));
        String string6 = this.utils.findPlatformFor(jdbcConnectionDescriptor.getSubProtocol(), string2);
        jdbcConnectionDescriptor.setDbms(string6);
        jdbcConnectionDescriptor.setJdbcLevel(2.0);
        jdbcConnectionDescriptor.setDriver(string2);
        if (string4 != null) {
            jdbcConnectionDescriptor.setUserName(string4);
            jdbcConnectionDescriptor.setPassWord(string5);
        }
        if ("default".equals(string)) {
            jdbcConnectionDescriptor.setDefaultConnection(true);
        }
        this.addDescriptor(jdbcConnectionDescriptor);
        return jdbcConnectionDescriptor;
    }

    public JdbcConnectionDescriptor addDescriptor(String string, DataSource dataSource, String string2, String string3) {
        JdbcConnectionDescriptor jdbcConnectionDescriptor = new JdbcConnectionDescriptor();
        jdbcConnectionDescriptor.setJcdAlias(string);
        jdbcConnectionDescriptor.setDataSource(dataSource);
        if (string2 != null) {
            jdbcConnectionDescriptor.setUserName(string2);
            jdbcConnectionDescriptor.setPassWord(string3);
        }
        this.utils.fillJCDFromDataSource(jdbcConnectionDescriptor, dataSource, string2, string3);
        if ("default".equals(string)) {
            jdbcConnectionDescriptor.setDefaultConnection(true);
        }
        this.addDescriptor(jdbcConnectionDescriptor);
        return jdbcConnectionDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDescriptor(Object object) {
        PBKey pBKey;
        if (object instanceof PBKey) {
            pBKey = (PBKey)object;
        } else if (object instanceof JdbcConnectionDescriptor) {
            pBKey = ((JdbcConnectionDescriptor)object).getPBKey();
        } else {
            throw new MetadataException("Could not remove descriptor, given object was no vaild key: " + object);
        }
        Object var3_3 = null;
        HashMap hashMap = this.jcdMap;
        synchronized (hashMap) {
            var3_3 = this.jcdMap.remove(pBKey);
            this.jcdAliasToPBKeyMap.remove(pBKey.getAlias());
        }
        log.info("Remove descriptor: " + var3_3);
    }

    public List getAllDescriptor() {
        return (List)SerializationUtils.clone(new ArrayList(this.jcdMap.values()));
    }

    @Override
    public String toXML() {
        String string = SystemUtils.LINE_SEPARATOR;
        HashMap hashMap = (HashMap)this.jcdMap.clone();
        StringBuffer stringBuffer = new StringBuffer();
        for (JdbcConnectionDescriptor jdbcConnectionDescriptor : hashMap.values()) {
            stringBuffer.append(jdbcConnectionDescriptor.toXML());
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

